/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.docextraction.IDocumentScreenshotsDrawer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PdfBoxPdfDocumentScreenshotsDrawer
implements IDocumentScreenshotsDrawer {
    private static final String SCREENSHOT_CONVERSION_PDFBOX = "screenshot-conversion-pdfbox";
    public static final long PDFBOX_MEMORY_LIMIT_PER_DOCUMENT = ApplicationConfigurator.getParams().getIntParam("dku.docextraction.pdfbox.memoryLimitPerDocumentInMB", Integer.valueOf(50));
    PDFRenderer pdfRenderer;
    private final int pageNumber;
    PDDocument document;
    private final int scale;

    public PdfBoxPdfDocumentScreenshotsDrawer(InputStream inputStream, int scale) {
        this.scale = scale;
        try {
            MemoryUsageSetting memoryUsageSetting = MemoryUsageSetting.setupMixed((long)(PDFBOX_MEMORY_LIMIT_PER_DOCUMENT * 1000L * 1000L));
            memoryUsageSetting.setTempDir(DSSTempUtils.getTempFolderWithSpecifiName((String)"docextraction", (String)SCREENSHOT_CONVERSION_PDFBOX));
            this.document = PDDocument.load((InputStream)inputStream, (MemoryUsageSetting)memoryUsageSetting);
            this.pdfRenderer = new PDFRenderer(this.document);
            this.pageNumber = this.document.getNumberOfPages();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getPageCount() {
        return this.pageNumber;
    }

    @Override
    public BufferedImage drawImage(int index) throws IOException {
        return this.pdfRenderer.renderImage(index, (float)this.scale);
    }

    @Override
    public void close() throws IOException {
        this.document.close();
    }
}

