/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.docextraction.IDocumentScreenshotsDrawer;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xslf.usermodel.XMLSlideShow;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xslf.usermodel.XSLFSlide;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class PoiPPTXDocumentScreenshotsDrawer
implements IDocumentScreenshotsDrawer {
    List<XSLFSlide> slides;
    Dimension pageSize;
    private final int scale;

    public PoiPPTXDocumentScreenshotsDrawer(InputStream inputStream, int scale) throws IOException {
        this.scale = scale;
        XMLSlideShow ppt = new XMLSlideShow(inputStream);
        this.slides = ppt.getSlides();
        this.pageSize = ppt.getPageSize();
    }

    @Override
    public int getPageCount() {
        return this.slides.size();
    }

    @Override
    public BufferedImage drawImage(int index) {
        BufferedImage img = new BufferedImage(this.pageSize.width * this.scale, this.pageSize.height * this.scale, 2);
        Graphics2D graphics = img.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        graphics.scale(this.scale, this.scale);
        this.slides.get(index).draw(graphics);
        graphics.dispose();
        return img;
    }

    @Override
    public void close() throws IOException {
    }
}

