/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.docextraction.DocExtractionUtils;
import com.dataiku.dip.docextraction.DocumentIterator;
import com.dataiku.dip.docextraction.PdfBoxPdfDocumentScreenshotsDrawer;
import com.dataiku.dip.docextraction.PoiPPTXDocumentScreenshotsDrawer;
import com.dataiku.dip.docextraction.Screenshotter;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.LibreOfficeUtil;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.codec.binary.Hex;
import com.dataiku.dss.shadelib.org.apache.commons.codec.digest.DigestUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FilenameUtils;
import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.server.UnsupportedMediaTypeStatusException;

@Service
public class ScreenshotterService {
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private TransactionService transactionService;
    private Boolean hasLibreOfficeBin = null;
    public static int MAX_LIBREOFFICE_INSTANCES = ApplicationConfigurator.getParams().getIntParam("dku.docextraction.pdfconversion.maxLibreOfficeInstances", Integer.valueOf(1));
    public static long libreOfficeTimeoutInMs = ApplicationConfigurator.getParams().getLongParam("dku.docextraction.pdfconversion.libreOfficeProcessTimeoutSeconds", 1800L) * 1000L;
    public AtomicInteger currentLibreOfficeInstance = new AtomicInteger(0);
    public ConcurrentHashMap<Integer, ReentrantLock> locks = new ConcurrentHashMap();
    public static DKULogger logger = DKULogger.getLogger((String)"dku.screenshoter");

    private boolean isLibreOfficeInstalled() {
        if (this.hasLibreOfficeBin == null) {
            this.hasLibreOfficeBin = LibreOfficeUtil.hasLibreOfficeBin();
        }
        return this.hasLibreOfficeBin;
    }

    public Screenshotter.ScreenshotterResponseOrError extractScreenshotsFromTmpDocumentRef(AuthCtx authCtx, String projectKey, InputRefs.TmpDocumentRef documentRef, Screenshotter.ScreenshotterSettings settings) throws Exception {
        Screenshotter.EnrichedScreenshotterResponseOrError res;
        File tmp = DKUApp.getFile((String[])new String[]{"tmp", "docextraction", "screenshots-extraction", documentRef.tmpFileName});
        if (!tmp.exists()) {
            throw new IOException("Cannot retrieve the associated file from tmp file, try to upload the original file again");
        }
        try (InputStream fileStream = DKUFileUtils.readWithAutoDecompress((File)tmp);){
            res = this.extractScreenshotsFromInputStream(authCtx, projectKey, tmp, fileStream, documentRef.originalFileName, settings);
        }
        res.responseOrError.documentRef = documentRef;
        if (res.responseOrError.ok && !res.responseOrError.hasMoreResults.booleanValue()) {
            res.convertedFile.ifPresent(this::cleanTmpFile);
            this.cleanTmpFile(tmp);
        }
        return res.responseOrError;
    }

    public Screenshotter.ScreenshotterResponseOrError extractScreenshotsFromLocalFileDocumentRef(AuthCtx authCtx, String projectKey, InputRefs.LocalFileDocumentRef document, Screenshotter.ScreenshotterSettings settings) throws Exception {
        File docFile;
        String ext = FilenameUtils.getExtension((String)document.multipartFile.getOriginalFilename());
        try {
            File tmpFolder = DSSTempUtils.getTempFolderWithSpecifiName((String)"docextraction", (String)"screenshots-extraction");
            docFile = File.createTempFile("doc" + FilenameUtils.getBaseName((String)document.multipartFile.getOriginalFilename()), "." + ext, tmpFolder);
            FileUtils.copyInputStreamToFile((InputStream)document.multipartFile.getInputStream(), (File)docFile);
        }
        catch (IOException e) {
            throw new IOException("Cannot write the file to tmp folder", e);
        }
        InputRefs.TmpDocumentRef tmpDocumentRef = new InputRefs.TmpDocumentRef();
        tmpDocumentRef.tmpFileName = docFile.getName();
        tmpDocumentRef.originalFileName = document.multipartFile.getOriginalFilename();
        return this.extractScreenshotsFromTmpDocumentRef(authCtx, projectKey, tmpDocumentRef, settings);
    }

    public Screenshotter.ScreenshotterResponseOrError extractScreenshotsFromManagedFolderDocumentRef(AuthCtx authCtx, String projectKey, InputRefs.ManagedFolderDocumentRef documentRef, Screenshotter.ScreenshotterSettings settings) throws Exception {
        Screenshotter.EnrichedScreenshotterResponseOrError enrichedScreenshotterResponseOrError;
        File tmpFile;
        ManagedFolder mf = this.getManagedFolder(projectKey, documentRef.managedFolderId);
        try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
            handler.getProvider();
            EnrichedInputStream docStream = handler.getInputStream(documentRef.filePath);
            try (InputStream inputStream = docStream.rawStream();){
                File tmpFolder = DSSTempUtils.getTempFolderWithSpecifiName((String)"docextraction", (String)"screenshots-extraction");
                tmpFile = File.createTempFile("doc" + FilenameUtils.getBaseName((String)docStream.getFilename()), "." + FilenameUtils.getExtension((String)docStream.getFilename()), tmpFolder);
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tmpFile);
            }
        }
        try (InputStream fileStream = DKUFileUtils.readWithAutoDecompress((File)tmpFile);){
            enrichedScreenshotterResponseOrError = this.extractScreenshotsFromInputStream(authCtx, projectKey, tmpFile, fileStream, documentRef.filePath, settings);
        }
        this.cleanTmpFile(tmpFile);
        if (enrichedScreenshotterResponseOrError.responseOrError.ok && !enrichedScreenshotterResponseOrError.responseOrError.hasMoreResults.booleanValue()) {
            enrichedScreenshotterResponseOrError.convertedFile.ifPresent(this::cleanTmpFile);
        }
        enrichedScreenshotterResponseOrError.responseOrError.documentRef = documentRef;
        return enrichedScreenshotterResponseOrError.responseOrError;
    }

    private ManagedFolder getManagedFolder(String projectKey, String documentRef) throws IOException {
        ManagedFolder mf;
        AnyLoc managedFolderLoc = AnyLoc.resolveSmart(projectKey, documentRef);
        if (TransactionContext.hasAttachedTransaction()) {
            mf = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(managedFolderLoc);
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                mf = (ManagedFolder)this.managedFolderDAO.getMandatoryUnsafe(managedFolderLoc);
            }
        }
        return mf;
    }

    private void cleanTmpFile(File tmp) {
        try {
            DKUFileUtils.delete((File)tmp);
        }
        catch (IOException e) {
            logger.info((Object)"Failed to clean doc extraction file from tmp directory");
        }
    }

    private Screenshotter.EnrichedScreenshotterResponseOrError extractScreenshotsFromInputStream(AuthCtx authCtx, String projectKey, File tmpFile, InputStream fileStream, String originalFilePath, Screenshotter.ScreenshotterSettings settings) throws Exception {
        String ext = FilenameUtils.getExtension((String)tmpFile.getName()).toLowerCase();
        ErrorContext.check((boolean)StringUtils.isNotBlank((String)ext), (String)"File extension cannot be blank");
        settings.paginationOffset = Objects.requireNonNullElse(settings.paginationOffset, Screenshotter.DEFAULT_PAGINATION_OFFSET);
        settings.paginationSize = Objects.requireNonNullElse(settings.paginationSize, Screenshotter.DEFAULT_PAGINATION_SIZE);
        ErrorContext.check((settings.paginationOffset >= 0 ? 1 : 0) != 0, (String)"Pagination offset cannot be lower than 0");
        ErrorContext.check((settings.paginationSize > 0 ? 1 : 0) != 0, (String)"Pagination size cannot be lower or equal to 0");
        Screenshotter.EnrichedScreenshotterResponseOrError res = new Screenshotter.EnrichedScreenshotterResponseOrError();
        logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Starting screenshot extraction"));
        switch (ext) {
            case "pdf": {
                res.responseOrError = this.generateScreenshotsFromPdfInputStream(authCtx, projectKey, tmpFile, fileStream, Screenshotter.ScreenshotterSettings.ScreenshotterEngine.BACKEND, originalFilePath, settings);
                return res;
            }
            case "odp": 
            case "ppt": 
            case "odt": 
            case "doc": 
            case "docx": 
            case "xls": 
            case "xlsx": 
            case "xlsb": 
            case "xlsm": 
            case "ods": {
                if (!this.isLibreOfficeInstalled()) {
                    throw new UnsupportedOperationException("LibreOffice must be installed to convert " + ext + " files to images, administrators can use install-deps.sh with the -with-libreoffice toggle");
                }
                return this.fileToScreenshotsWithLibreOffice(authCtx, projectKey, fileStream, tmpFile, originalFilePath, settings);
            }
            case "pptx": {
                if (!this.isLibreOfficeInstalled()) {
                    logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "LibreOffice is not installed, default method will be used for file: " + tmpFile.getPath()));
                    return this.generateScreenshotsFromPptxInputStream(authCtx, projectKey, tmpFile, fileStream, originalFilePath, settings);
                }
                return this.fileToScreenshotsWithLibreOffice(authCtx, projectKey, fileStream, tmpFile, originalFilePath, settings);
            }
            case "png": 
            case "jpeg": 
            case "jpg": {
                res.responseOrError = this.generateScreenshotsFromImage(authCtx, projectKey, tmpFile, fileStream, originalFilePath, settings);
                return res;
            }
        }
        throw new UnsupportedMediaTypeStatusException("Cannot convert file:" + originalFilePath + " to screenshots because conversion for ." + ext + " files is not supported");
    }

    private Screenshotter.ScreenshotterResponseOrError generateScreenshotsFromImage(AuthCtx authCtx, String projectKey, File tmpFile, InputStream fileStream, String originalFilePath, Screenshotter.ScreenshotterSettings settings) throws Exception {
        BufferedImage img = ImageIO.read(fileStream);
        if (settings.outputManagedFolderId != null) {
            ManagedFolder outputMf = this.getManagedFolder(projectKey, settings.outputManagedFolderId);
            InputRefs.ManagedFolderImagesRef imagesRef = new InputRefs.ManagedFolderImagesRef();
            imagesRef.managedFolderId = settings.outputManagedFolderId;
            String digest = this.getHashFromFileContentAndStorageImpactingSettings(tmpFile, null);
            imagesRef.commonPrefixPath = this.getOutputScreenshotCommonPrefixPath(originalFilePath, digest);
            try (ManagedFolderHandler handler = (ManagedFolderHandler)outputMf.buildHandler(authCtx);){
                String outputImagePath = this.getOutputScreenshotFullPath(originalFilePath, digest, FilenameUtils.getName((String)originalFilePath));
                imagesRef.imagesPaths.add(this.writeImageToManagedFolder(handler, img, outputImagePath, originalFilePath));
            }
            return Screenshotter.ScreenshotterResponseOrError.fromSuccess(imagesRef, false, 0, 1);
        }
        String content = ScreenshotterService.imageToPngBase64(img);
        InputRefs.InlineImagesRef imagesRef = new InputRefs.InlineImagesRef();
        imagesRef.inlineImages.add(new InputRefs.SingleInlineImage(content, "image/png"));
        return Screenshotter.ScreenshotterResponseOrError.fromSuccess(imagesRef, false, 0, 1);
    }

    private String getOutputScreenshotFullPath(String originalFilePath, String fileAndStorageImpactingSettingsDigest, String screenshotName) {
        return PathUtils.concatLNT((String[])new String[]{this.getOutputScreenshotCommonPrefixPath(originalFilePath, fileAndStorageImpactingSettingsDigest), screenshotName});
    }

    private String getOutputScreenshotCommonPrefixPath(String originalFilePath, String fileAndStorageImpactingSettingsDigest) {
        return PathUtils.concatLNT((String[])new String[]{originalFilePath, fileAndStorageImpactingSettingsDigest});
    }

    private String getHashFromFileContentAndStorageImpactingSettings(File file, Screenshotter.ScreenshotterSettings.StorageImpactingSettings settings) throws IOException {
        MessageDigest messageDigest = DigestUtils.getSha1Digest();
        messageDigest.update(Files.readAllBytes(file.toPath()));
        JSON.updateDigest((MessageDigest)messageDigest, (Object)settings);
        return Hex.encodeHexString((byte[])messageDigest.digest());
    }

    private Screenshotter.EnrichedScreenshotterResponseOrError generateScreenshotsFromPptxInputStream(AuthCtx authCtx, String projectKey, File tmpFile, InputStream fileStream, String originalFilePath, Screenshotter.ScreenshotterSettings settings) throws Exception {
        try (PoiPPTXDocumentScreenshotsDrawer pptxDrawer = new PoiPPTXDocumentScreenshotsDrawer(fileStream, 2);){
            Screenshotter.EnrichedScreenshotterResponseOrError pptxRes = new Screenshotter.EnrichedScreenshotterResponseOrError();
            DocumentIterator pptxDocumentIterator = new DocumentIterator(pptxDrawer, settings);
            boolean writeOutputToManagedFolder = settings.outputManagedFolderId != null;
            try {
                pptxRes.responseOrError = writeOutputToManagedFolder ? this.writeDocumentScreenshotsToManagedFolder(authCtx, pptxDocumentIterator, projectKey, originalFilePath, tmpFile, new Screenshotter.ScreenshotterSettings.StorageImpactingSettings(Screenshotter.ScreenshotterSettings.ScreenshotterEngine.BACKEND, Screenshotter.SCREENSHOTS_SCALE_FACTOR), settings) : this.generateDocumentScreenshotsAsBase64PngImages(pptxDocumentIterator);
            }
            catch (Exception e) {
                logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(originalFilePath, "Failed to generate screenshots with Apache POI for pptx document"), (Throwable)e);
                throw new Exception("Failed to generate screenshots with Apache POI for pptx document " + originalFilePath + " . Please consider installing Libreoffice to process it", e);
            }
            Screenshotter.EnrichedScreenshotterResponseOrError enrichedScreenshotterResponseOrError = pptxRes;
            return enrichedScreenshotterResponseOrError;
        }
    }

    private Screenshotter.ScreenshotterResponseOrError generateDocumentScreenshotsAsBase64PngImages(DocumentIterator documentIterator) throws IOException {
        InputRefs.InlineImagesRef imagesRef = new InputRefs.InlineImagesRef();
        while (documentIterator.hasNext()) {
            String base64Image = ScreenshotterService.imageToPngBase64(documentIterator.next());
            imagesRef.inlineImages.add(new InputRefs.SingleInlineImage(base64Image, "image/png"));
        }
        return Screenshotter.ScreenshotterResponseOrError.fromSuccess(imagesRef, documentIterator.hasNextPaginationResults, documentIterator.endIndex, documentIterator.pageCount);
    }

    private Screenshotter.ScreenshotterResponseOrError writeDocumentScreenshotsToManagedFolder(AuthCtx authCtx, DocumentIterator documentIterator, String projectKey, String originalFilePath, File tmpFile, Screenshotter.ScreenshotterSettings.StorageImpactingSettings storageImpactingSettings, Screenshotter.ScreenshotterSettings settings) throws Exception {
        ManagedFolder mf = this.getManagedFolder(projectKey, settings.outputManagedFolderId);
        InputRefs.ManagedFolderImagesRef imagesRef = new InputRefs.ManagedFolderImagesRef();
        imagesRef.managedFolderId = settings.outputManagedFolderId;
        String digest = this.getHashFromFileContentAndStorageImpactingSettings(tmpFile, storageImpactingSettings);
        try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(authCtx);){
            if (documentIterator.hasNext()) {
                imagesRef.commonPrefixPath = this.getOutputScreenshotCommonPrefixPath(originalFilePath, digest);
            }
            while (documentIterator.hasNext()) {
                int page_number = documentIterator.currentIndex + 1;
                String outputImagePath = this.getOutputScreenshotFullPath(originalFilePath, digest, "page_" + page_number + ".png");
                imagesRef.imagesPaths.add(this.writeImageToManagedFolder(handler, documentIterator.next(), outputImagePath, originalFilePath));
            }
        }
        return Screenshotter.ScreenshotterResponseOrError.fromSuccess(imagesRef, documentIterator.hasNextPaginationResults, documentIterator.endIndex, documentIterator.pageCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private LibreOfficeExecutionResults convertFileToPDFWithLibreOffice(String inputFilePath, String outputDirPath, String originalFileName) {
        int libreOfficeInstance = this.getLibreOfficeInstance();
        ReentrantLock lock = this.locks.computeIfAbsent(libreOfficeInstance, k -> new ReentrantLock());
        lock.lock();
        try {
            DKUtils.ExecutionResults executionResults;
            String userProfileDirectoryPath = outputDirPath + "/instance_" + libreOfficeInstance;
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Using LibreOffice user profile in : " + userProfileDirectoryPath));
            ArrayList cmd = Lists.newArrayList();
            cmd.add("soffice");
            cmd.add("-env:UserInstallation=file://" + userProfileDirectoryPath);
            cmd.add("--headless");
            cmd.add("--convert-to");
            cmd.add("pdf");
            cmd.add(inputFilePath);
            cmd.add("--outdir");
            cmd.add(outputDirPath);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            try {
                executionResults = DKUtils.execAndGetOutputAndErrors((ProcessBuilder)pb, (Long)libreOfficeTimeoutInMs);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Interrupted while waiting for LibreOffice execution results"), (Throwable)e);
                LibreOfficeExecutionResults libreOfficeExecutionResults = LibreOfficeExecutionResults.fromError(e);
                lock.unlock();
                return libreOfficeExecutionResults;
            }
            catch (IOException e) {
                logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Failed to convert file to PDF using LibreOffice"), (Throwable)e);
                LibreOfficeExecutionResults libreOfficeExecutionResults = LibreOfficeExecutionResults.fromError(e);
                lock.unlock();
                return libreOfficeExecutionResults;
            }
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Libreoffice stdout: " + executionResults.out));
            if (StringUtils.isNotBlank((String)executionResults.err)) {
                logger.error((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Libreoffice stderr: " + executionResults.err));
            }
            String outputFileName = FilenameUtils.getBaseName((String)inputFilePath) + ".pdf";
            File convertedFile = new File(PathUtils.concatLNT((String[])new String[]{outputDirPath, outputFileName}));
            if (!convertedFile.exists()) {
                StringBuilder message = new StringBuilder();
                message.append("Conversion to pdf using LibreOffice was not successful, it did not fail but did not create the converted pdf for file: ").append(originalFileName);
                logger.warn((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, message.toString()));
                message.append(". Libreoffice stout was: ").append(executionResults.out).append(", Libreoffice stderr was: ").append(executionResults.err);
                LibreOfficeExecutionResults libreOfficeExecutionResults = LibreOfficeExecutionResults.fromMissingOutputFile(executionResults, message.toString());
                return libreOfficeExecutionResults;
            }
            logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Converted file to PDF: " + outputFileName));
            LibreOfficeExecutionResults libreOfficeExecutionResults = LibreOfficeExecutionResults.fromSuccess(new File(PathUtils.concatLNT((String[])new String[]{outputDirPath, outputFileName})), executionResults);
            return libreOfficeExecutionResults;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private int getLibreOfficeInstance() {
        return this.currentLibreOfficeInstance.getAndUpdate(i -> (i + 1) % MAX_LIBREOFFICE_INSTANCES) + 1;
    }

    private Screenshotter.ScreenshotterResponseOrError generateScreenshotsFromPdfInputStream(AuthCtx authCtx, String projectKey, File tmpFile, InputStream fileStream, Screenshotter.ScreenshotterSettings.ScreenshotterEngine engine, String originalFilePath, Screenshotter.ScreenshotterSettings settings) throws Exception {
        Screenshotter.ScreenshotterResponseOrError res;
        boolean writeOutputToManagedFolder = settings.outputManagedFolderId != null;
        try (PdfBoxPdfDocumentScreenshotsDrawer pdfDrawer = new PdfBoxPdfDocumentScreenshotsDrawer(fileStream, 2);){
            DocumentIterator pdfDocumentIterator = new DocumentIterator(pdfDrawer, settings);
            res = writeOutputToManagedFolder ? this.writeDocumentScreenshotsToManagedFolder(authCtx, pdfDocumentIterator, projectKey, originalFilePath, tmpFile, new Screenshotter.ScreenshotterSettings.StorageImpactingSettings(engine, Screenshotter.SCREENSHOTS_SCALE_FACTOR), settings) : this.generateDocumentScreenshotsAsBase64PngImages(pdfDocumentIterator);
        }
        return res;
    }

    private Screenshotter.EnrichedScreenshotterResponseOrError fileToScreenshotsWithLibreOffice(AuthCtx authCtx, String projectKey, InputStream inputStreamForFallback, File tmpFile, String originalFileName, Screenshotter.ScreenshotterSettings settings) throws Exception {
        ErrorContext.check((boolean)tmpFile.exists(), (String)"The document is not accessible anymore, please try again");
        logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Using LibreOffice engine to extract content from document"));
        String conversionTmpFolderPath = DSSTempUtils.getTempFolderWithSpecifiName((String)"docextraction", (String)"to-pdf-conversion").getAbsolutePath();
        String digest = this.getHashFromFileContentAndStorageImpactingSettings(tmpFile, new Screenshotter.ScreenshotterSettings.StorageImpactingSettings(Screenshotter.ScreenshotterSettings.ScreenshotterEngine.LIBRE_OFFICE, Screenshotter.SCREENSHOTS_SCALE_FACTOR));
        File relatedPdfFile = new File(conversionTmpFolderPath, digest + ".pdf");
        if (!relatedPdfFile.exists()) {
            LibreOfficeExecutionResults libreOfficeExecutionResults = this.convertFileToPDFWithLibreOffice(tmpFile.getPath(), conversionTmpFolderPath, originalFileName);
            if (!libreOfficeExecutionResults.ok) {
                if (Objects.equals(FilenameUtils.getExtension((String)originalFileName).toLowerCase(), "pptx")) {
                    logger.info((Object)("Falling back on default extraction method for pptx file: " + originalFileName));
                    return this.generateScreenshotsFromPptxInputStream(authCtx, projectKey, tmpFile, inputStreamForFallback, originalFileName, settings);
                }
                Screenshotter.ScreenshotterResponseOrError error = Screenshotter.ScreenshotterResponseOrError.fromError(new Exception("Error while converting file: " + originalFileName + " to pdf with Libreoffice", libreOfficeExecutionResults.error));
                Screenshotter.EnrichedScreenshotterResponseOrError enrichedError = new Screenshotter.EnrichedScreenshotterResponseOrError();
                enrichedError.responseOrError = error;
                return enrichedError;
            }
            if (libreOfficeExecutionResults.outputFile.renameTo(relatedPdfFile)) {
                logger.info((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Renamed converted pdf file to: " + relatedPdfFile.getPath()));
            } else {
                logger.warn((Object)DocExtractionUtils.buildMessageLogForDocument(originalFileName, "Cannot rename file: " + libreOfficeExecutionResults.outputFile.getPath()));
                relatedPdfFile = libreOfficeExecutionResults.outputFile;
            }
        }
        Screenshotter.EnrichedScreenshotterResponseOrError res = new Screenshotter.EnrichedScreenshotterResponseOrError();
        try (FileInputStream pdfFileStream = new FileInputStream(relatedPdfFile);){
            res.responseOrError = this.generateScreenshotsFromPdfInputStream(authCtx, projectKey, tmpFile, pdfFileStream, Screenshotter.ScreenshotterSettings.ScreenshotterEngine.LIBRE_OFFICE, originalFileName, settings);
            res.convertedFile = Optional.of(relatedPdfFile);
            Screenshotter.EnrichedScreenshotterResponseOrError enrichedScreenshotterResponseOrError = res;
            return enrichedScreenshotterResponseOrError;
        }
    }

    /*
     * Exception decompiling
     */
    private String writeImageToManagedFolder(ManagedFolderHandler managedFolderHandler, BufferedImage img, String outputImagePath, String originalFilePath) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String imageToPngBase64(BufferedImage img) throws IOException {
        String string;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, "png", outputStream);
            byte[] imageBytes = outputStream.toByteArray();
            string = Base64.getEncoder().encodeToString(imageBytes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IOException("Error converting image to Base64", e);
            }
        }
        outputStream.close();
        return string;
    }

    private static class LibreOfficeExecutionResults {
        File outputFile;
        DKUtils.ExecutionResults executionResults;
        public boolean ok;
        public Throwable error;

        private LibreOfficeExecutionResults() {
        }

        public static LibreOfficeExecutionResults fromSuccess(File convertedFile, DKUtils.ExecutionResults executionResults) {
            LibreOfficeExecutionResults resp = new LibreOfficeExecutionResults();
            resp.ok = true;
            resp.outputFile = convertedFile;
            resp.executionResults = executionResults;
            return resp;
        }

        public static LibreOfficeExecutionResults fromError(Throwable e) {
            LibreOfficeExecutionResults resp = new LibreOfficeExecutionResults();
            resp.ok = false;
            resp.error = e;
            return resp;
        }

        public static LibreOfficeExecutionResults fromMissingOutputFile(DKUtils.ExecutionResults executionResults, String message) {
            LibreOfficeExecutionResults resp = new LibreOfficeExecutionResults();
            resp.ok = false;
            resp.executionResults = executionResults;
            resp.error = new Exception(message);
            return resp;
        }
    }
}

