/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipeMeta;
import com.dataiku.dip.dataflow.exec.autofeaturegeneration.AutoFeatureGenerationRecipePayloadParams;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.DataRelationshipFullDesc;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.utils.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RecipeGenerateFeaturesRelationshipIterable
implements FlowPlaceholder.IterablePlaceholder<SerializedRecipe, DataRelationshipFullDesc> {
    @Override
    public Collection<DataRelationshipFullDesc> resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
        if (!AutoFeatureGenerationRecipeMeta.META.getType().equals(recipe.getType())) {
            throw new BadTemplatePlaceholderException("Placeholder not available for recipe " + recipe.name + ". " + recipe.type + ". It is not a generate feature recipe.");
        }
        AutoFeatureGenerationRecipePayloadParams payload = (AutoFeatureGenerationRecipePayloadParams)JSON.parse((String)context.getCachedPayload(recipe), AutoFeatureGenerationRecipePayloadParams.class);
        return payload.relationships.stream().map(relationshipDesc -> {
            if (relationshipDesc.table1 >= payload.virtualInputs.size() || relationshipDesc.table2 >= payload.virtualInputs.size()) {
                return null;
            }
            List<SerializedRecipe.RecipeInput> inputs = recipe.getInputsForRole("main");
            AutoFeatureGenerationRecipePayloadParams.InputDesc leftVirtualInput = (AutoFeatureGenerationRecipePayloadParams.InputDesc)payload.virtualInputs.get(relationshipDesc.table1);
            AutoFeatureGenerationRecipePayloadParams.InputDesc rightVirtualInput = (AutoFeatureGenerationRecipePayloadParams.InputDesc)payload.virtualInputs.get(relationshipDesc.table2);
            int rightRealIndex = rightVirtualInput.index;
            int leftRealIndex = leftVirtualInput.index;
            return new DataRelationshipFullDesc((AutoFeatureGenerationRecipePayloadParams.RelationshipDesc)relationshipDesc, inputs.get((int)leftRealIndex).ref, leftVirtualInput, inputs.get((int)rightRealIndex).ref, rightVirtualInput);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public IterableDescription<SerializedRecipe, DataRelationshipFullDesc> getDescription() {
        return IterableDescription.iterablePlaceholder(SerializedRecipe.class, DataRelationshipFullDesc.class, "$data_relationship");
    }
}

