/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets;

import com.dataiku.dip.eda.compute.ComputeService;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.transformers.Factorizer;
import com.dataiku.dip.eda.compute.computations.transformers.Flattener;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.engine.ComputationResultSession;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.compute.sampling.Sample;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NullChecker;
import com.google.common.base.Stopwatch;
import com.google.gson.reflect.TypeToken;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardComputeService {
    @Autowired
    FutureService futureService;
    @Autowired
    ComputeService computeService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.eda.cardcompute");

    public FutureResponse<CardResult> computeResultsInFuture(final AuthCtx authCtx, final Card card, final boolean cacheOnly, final Sample sample) throws Exception {
        return this.futureService.runFuture(new SimpleFutureThread<CardResult>(authCtx){

            public FuturePayload getPayload() {
                FuturePayload fp = FuturePayload.newSimple((String)"eda_compute_worksheet", (String)"Compute worksheet results");
                fp.targets.add(new FuturePayload.FuturePayloadTarget(sample.getProjectKey(), card.id, "Card " + card.id + " of project " + sample.getProjectKey(), null));
                return fp;
            }

            @Override
            protected CardResult compute() throws Exception {
                return CardComputeService.this.computeResults_NT(authCtx, card, cacheOnly, sample);
            }
        }, 0L, new TypeToken<FutureResponse<CardResult>>(){});
    }

    public CardResult computeResults_NT(AuthCtx authCtx, Card card, boolean cacheOnly, Sample sample) throws Exception {
        logger.info((Object)("Compute card " + card.id + " on sample " + sample.id + " (cacheOnly=" + cacheOnly + ")"));
        try (ComputationRunner runner = cacheOnly ? this.computeService.getCacheReader(sample) : this.computeService.getCachedSampleRunner(authCtx, sample);){
            CardResult cardResult = this.computeResultsWithRunner(card, runner);
            return cardResult;
        }
    }

    private CardResult computeResultsWithRunner(Card card, ComputationRunner runner) throws Exception {
        CardResult cardResult;
        logger.info((Object)("Started computing card " + card.id));
        Stopwatch stopwatch = Stopwatch.createStarted();
        TransactionContext.assertNoAttachedTransaction();
        NullChecker.checkObject((Object)((Object)card));
        CompiledCard compiledCard = card.compile();
        Computation computation = compiledCard.getComputationPlan();
        try (ComputationResultSession session = runner.computeAndOpenSession(computation);){
            ComputationResult result = session.getComputationResult();
            ComputationResultDataStreamer dataStreamer = session.getDataStreamer();
            cardResult = compiledCard.buildResult(result, dataStreamer);
        }
        NullChecker.checkObject((Object)((Object)cardResult));
        logger.info((Object)("Computed card " + card.id + " in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + "ms"));
        return cardResult;
    }

    public Computation humanFriendlyComputationPlan(Card card) {
        return new Factorizer().transform((Computation)new Flattener().transform((Computation)card.compile().getComputationPlan()).computation).computation;
    }
}

