/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.univariate.SignTest1Samp;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.UnivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceLevel;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.eda.worksheets.models.Variable;

public class SignTest1SampCard
extends UnivariateCard
implements CardWithConfidenceLevel,
RecipeCompatibleCard {
    public static final String TYPE = "sign_test_1samp";
    public double hypothesizedMedian;
    public double confidenceLevel;

    @Override
    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public SignTest1SampCard(Variable column, double hypothesizedMedian) {
        this.column = column;
        this.hypothesizedMedian = hypothesizedMedian;
    }

    private SignTest1SampCard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult>(){

            @Override
            public MultiComputation getComputationPlan() {
                return new MultiComputation(new SignTest1Samp(SignTest1SampCard.this.column.name, SignTest1SampCard.this.hypothesizedMedian), BoxPlotFragment.getComputationPlan(SignTest1SampCard.this.column.name));
            }

            @Override
            public CardResult buildFromFullyAvailableResult(MultiComputation.MultiComputationResult result) {
                SignTest1Samp.SignTest1SampResult signTest = result.get(0).as(SignTest1Samp.SignTest1SampResult.class);
                BoxPlotFragment boxPlot = BoxPlotFragment.build(result.get(1));
                return new SignTest1SampCardResult(signTest.pvalue, boxPlot, signTest.nbSmaller, signTest.nbLarger, signTest.nbEqual);
            }
        };
    }

    public static class SignTest1SampCardResult
    extends CardResult {
        public double pvalue;
        public long nbSmaller;
        public long nbLarger;
        public long nbEqual;
        public BoxPlotFragment boxPlot;

        public SignTest1SampCardResult(double pvalue, BoxPlotFragment boxPlot, long nbSmaller, long nbLarger, long nbEqual) {
            this.pvalue = pvalue;
            this.boxPlot = boxPlot;
            this.nbSmaller = nbSmaller;
            this.nbLarger = nbLarger;
            this.nbEqual = nbEqual;
        }

        private SignTest1SampCardResult() {
        }
    }
}

