/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithColorBy;
import com.dataiku.dip.eda.worksheets.models.SplitBySpec;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import com.dataiku.dip.utils.JSON;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SplitSuggester
implements Suggester {
    private final Suggester[] delegateSuggesters;

    public SplitSuggester(Suggester ... delegateSuggesters) {
        this.delegateSuggesters = delegateSuggesters;
    }

    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        Optional<SniffedVariable> splitByCandidate = sniffedVariables.stream().filter(SniffedVariable::isLikelyCategorical).filter(SniffedVariable::hasLowCardinality).filter(it -> it.cardinality > 1L).min(Comparator.comparing(it -> it.cardinality));
        if (!splitByCandidate.isPresent()) {
            return Collections.emptyList();
        }
        SniffedVariable splitBySniffedVariable = splitByCandidate.get();
        List remainingSniffedVariables = sniffedVariables.stream().filter(it -> !it.equals(splitBySniffedVariable)).collect(Collectors.toList());
        Variable splitByVariable = Suggester.toCategoricalVariable(splitBySniffedVariable);
        return Arrays.stream(this.delegateSuggesters).flatMap(it -> it.suggestCards(remainingSniffedVariables).stream()).filter(it -> it.card.filter == null).map(it -> this.applySplitBy((SuggestCards.SuggestedCard)it, splitByVariable)).collect(Collectors.toList());
    }

    private SuggestCards.SuggestedCard applySplitBy(SuggestCards.SuggestedCard suggestion, Variable splitByVariable) {
        SplitBySpec splitBySpec = new SplitBySpec(splitByVariable);
        splitBySpec.maxValues = 5;
        splitBySpec.groupWithOthers = true;
        splitBySpec.groupWithAll = false;
        Card card = this.applySplitBy(suggestion.card, splitBySpec);
        String name = String.format("%s split by %s", suggestion.name, splitByVariable.name);
        return new SuggestCards.SuggestedCard(name, card);
    }

    private Card applySplitBy(Card card, SplitBySpec splitBySpec) {
        if (card instanceof CardWithColorBy) {
            Card copy = (Card)((Object)JSON.deepCopy((Object)((Object)card)));
            ((CardWithColorBy)((Object)copy)).setColorBy(splitBySpec);
            return copy;
        }
        return card.withSplitBy(splitBySpec);
    }
}

