/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.export.CustomExporterDesc;
import com.dataiku.dip.export.CustomExportersRegistry;
import com.dataiku.dip.export.CustomLoadedExporter;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportStatus;
import com.dataiku.dip.export.input.ExportDataset;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.export.input.ExportShaker;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.formats.custom.CustomJavaFormatDesc;
import com.dataiku.dip.formats.custom.CustomJavaFormatsService;
import com.dataiku.dip.formats.custom.CustomPythonFormatDesc;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.formats.custom.LoadedFormat;
import com.dataiku.dip.formats.custom.LoadedJavaFormat;
import com.dataiku.dip.formats.custom.LoadedPythonFormat;
import com.dataiku.dip.input.TableColoring;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportUtils {
    @Autowired
    private CustomPythonFormatsService customPythonFormatsService;
    @Autowired
    private CustomJavaFormatsService customJavaFormatsService;
    private static final Logger logger = Logger.getLogger(ExportUtils.class);

    public static boolean canExportToStream(StreamableDatasetSelection selection) {
        HashSet streamCompatibleMethods = Sets.newHashSet((Object[])new SamplingParam.SamplingMethod[]{SamplingParam.SamplingMethod.FULL, SamplingParam.SamplingMethod.HEAD_SEQUENTIAL, SamplingParam.SamplingMethod.RANDOM_FIXED_RATIO});
        return streamCompatibleMethods.contains(selection.samplingMethod);
    }

    public static ExportStatus.ExportMethod computeExportMethod(ExportInput input, ExportParams params) {
        if (params.destinationType == ExportParams.ExportDestinationType.CUSTOM_MANAGED) {
            return ExportStatus.ExportMethod.CUSTOM_MANAGED;
        }
        if (params.destinationType == ExportParams.ExportDestinationType.DATASET) {
            return ExportStatus.ExportMethod.DATASET;
        }
        assert (params.destinationType == ExportParams.ExportDestinationType.DOWNLOAD);
        if (params.exporterType != null) {
            CustomLoadedExporter<?> exporter = CustomExportersRegistry.getExporter(params.exporterType);
            assert (exporter.getBehavior() == CustomExporterDesc.ExportBehavior.OUTPUT_TO_FILE);
            return ExportStatus.ExportMethod.CUSTOM_TO_FILE;
        }
        assert (params.format != null);
        assert (params.format.type != null);
        if (ApplicationConfigurator.getParams().getBoolParam("dku.exports.disableDirectDownload", false)) {
            params.temporaryFileBehavior = ExportParams.TemporaryFileBehavior.YES;
        }
        if (params.temporaryFileBehavior == ExportParams.TemporaryFileBehavior.YES) {
            return ExportStatus.ExportMethod.FORMATTER_TO_FILE;
        }
        if (params.temporaryFileBehavior == ExportParams.TemporaryFileBehavior.NO) {
            return ExportStatus.ExportMethod.FORMATTER_STREAM;
        }
        if (input instanceof ExportDataset || input instanceof ExportShaker) {
            if (params.format.type.equals("excel") || !ExportUtils.canExportToStream(params.selection)) {
                return ExportStatus.ExportMethod.FORMATTER_TO_FILE;
            }
            return ExportStatus.ExportMethod.FORMATTER_STREAM;
        }
        return ExportStatus.ExportMethod.FORMATTER_TO_FILE;
    }

    public static TableColoring computeColoring(ExportInput input) {
        if (input instanceof ExportDataset) {
            return ((ExportDataset)input).getColoring();
        }
        if (input instanceof ExportShaker) {
            return ((ExportShaker)input).getColoring();
        }
        return null;
    }

    public static DSSAuthCtx getAuthCtx(ExportInput input) {
        if (input instanceof ExportDataset) {
            return ((ExportDataset)input).authCtx;
        }
        if (input instanceof ExportShaker) {
            return ((ExportShaker)input).user;
        }
        return null;
    }

    public static SerializedDataset getSerializedDataset(ExportInput input) {
        if (input instanceof ExportDataset) {
            return ((ExportDataset)input).dataset;
        }
        if (input instanceof ExportShaker) {
            return ((ExportShaker)input).getSerializedDataset();
        }
        return null;
    }

    public static TableColoring convertColoring(SerializedShakerScript.TableColoring coloring) {
        if (coloring == null) {
            return null;
        }
        TableColoring result = new TableColoring();
        result.individualColumns = coloring.individualColumns;
        result.individualColumnsRules = coloring.individualColumnsRules;
        result.singleColumn = coloring.singleColumn;
        result.singleValue = coloring.singleValue;
        result.valueColoringMode = coloring.valueColoringMode;
        result.scheme = coloring.scheme;
        result.coloringGroups = coloring.coloringGroups;
        return result;
    }

    public static SerializedShakerScript.TableColoring convertColoring(TableColoring coloring) {
        if (coloring == null) {
            return null;
        }
        SerializedShakerScript.TableColoring result = new SerializedShakerScript.TableColoring();
        result.individualColumns = coloring.individualColumns;
        result.individualColumnsRules = coloring.individualColumnsRules;
        result.singleColumn = coloring.singleColumn;
        result.singleValue = coloring.singleValue;
        result.valueColoringMode = coloring.valueColoringMode;
        result.scheme = coloring.scheme;
        result.coloringGroups = coloring.coloringGroups;
        return result;
    }

    public MimeTypeUtils.MimeType getMimeType(ExportStatus status) {
        MimeTypeUtils.MimeType mt = status.exportMethod == ExportStatus.ExportMethod.FORMATTER_TO_FILE || status.exportMethod == ExportStatus.ExportMethod.FORMATTER_STREAM ? this.computeMimeType(status.params) : CustomExportersRegistry.getExporter(status.params.exporterType).getMimeType(status.params);
        return mt;
    }

    public MimeTypeUtils.MimeType computeMimeType(ExportParams params) {
        MimeTypeUtils.MimeType mt = new MimeTypeUtils.MimeType();
        switch (params.format.type.toLowerCase(Locale.ENGLISH)) {
            case "shapefile": {
                mt.extension = ".zip";
                mt.mimeType = "application/zip";
                break;
            }
            case "csv": {
                CSVFormatConfig cf = (CSVFormatConfig)JSON.parse((String)JSON.json((Object)params.format.params), CSVFormatConfig.class);
                if ("gz".equals(cf.compress)) {
                    mt.extension = ".csv.gz";
                    mt.mimeType = "application/x-gzip";
                    break;
                }
                mt.extension = ".csv";
                mt.mimeType = "text/csv";
                break;
            }
            case "excel": {
                mt.extension = ".xlsx";
                mt.mimeType = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
                break;
            }
            case "avro": {
                mt.extension = ".avro";
                mt.mimeType = "avro/binary";
                break;
            }
            case "geojson": {
                mt.extension = ".geojson";
                mt.mimeType = "application/geo+json";
                break;
            }
            default: {
                boolean isCustom = false;
                for (LoadedFormat format : this.customPythonFormatsService.list()) {
                    if (!format.getType().equalsIgnoreCase(params.format.type) || ((CustomPythonFormatDesc)((LoadedPythonFormat)format).desc).mime == null) continue;
                    mt = ((CustomPythonFormatDesc)((LoadedPythonFormat)format).desc).mime;
                    isCustom = true;
                }
                for (LoadedFormat format : this.customJavaFormatsService.list()) {
                    if (!((LoadedJavaFormat)format).getType().equalsIgnoreCase(params.format.type) || ((CustomJavaFormatDesc)((LoadedJavaFormat)format).desc).mime == null) continue;
                    mt = ((CustomJavaFormatDesc)((LoadedJavaFormat)format).desc).mime;
                    isCustom = true;
                }
                if (isCustom) break;
                mt.mimeType = "application/octet-stream";
                mt.extension = "";
            }
        }
        logger.info((Object)("USED MT: " + JSON.json((Object)mt)));
        return mt;
    }
}

