/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.input;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.prediction.PredictedDataService;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.memimpl.MemColumn;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.TableToSchema;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;

public class ExportPredictedDataInput
implements ExportInput {
    @Autowired
    private PredictedDataService predictedDataService;
    private final FullModelId fullModelId;
    private final ExportInput.InputDescription description;
    private Schema schema;
    private MemTable table;
    private RowFactory rowFactory;
    private ColumnFactory columnFactory;

    public ExportPredictedDataInput(FullModelId fullModelId) {
        this.fullModelId = fullModelId;
        this.description = new ExportInput.InputDescription();
        this.description.name = "Predicted data export";
        this.description.projectKey = fullModelId.getProjectKey();
        this.description.description = "Export this model's predicted data to a new dataset.";
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, StreamableDatasetSelection selection, ColumnFactory cf) throws Exception {
        this.rowFactory = new StreamRowFactory();
        this.columnFactory = cf;
        SpringUtils.getInstance().autowire((Object)this);
        SerializedShakerScript.ShakerExplorationSampleSettings explorationSampling = this.fullModelId.getHeadMLTask().predictionDisplayScript.explorationSampling;
        this.table = this.predictedDataService.getUncachedUnfiltered_NOTRANSACTION((FullModelId)this.fullModelId, (SerializedShakerScript.ShakerExplorationSampleSettings)explorationSampling).table;
        this.schema = TableToSchema.inferSchemaSimple(this.table, true);
    }

    @Override
    public long getInputSize() {
        return this.table.nrows();
    }

    @Override
    public ExportInput.InputDescription describe() {
        return this.description;
    }

    @Override
    public Schema getSchema() throws Exception {
        return this.schema;
    }

    @Override
    public void stream(ProcessorOutput output) throws Exception {
        ArrayList<Column> outputColumns = new ArrayList<Column>();
        for (MemColumn memColumn : this.table.columnsList) {
            outputColumns.add(this.columnFactory.column(memColumn.getName()));
        }
        for (MemRow inputRow : this.table.rows) {
            Row outputRow = this.rowFactory.row();
            for (int i = 0; i < outputColumns.size(); ++i) {
                MemColumn inputColumn = this.table.columnsList.get(i);
                Column outputColumn = (Column)outputColumns.get(i);
                String value = inputRow.get(inputColumn);
                outputRow.put(outputColumn, value);
            }
            output.emitRow(outputRow);
        }
        output.lastRowEmitted();
    }

    @Override
    public FuturePayload.FuturePayloadTarget getSource() {
        return DSSFuturePayloadUtils.forFMI(this.fullModelId);
    }

    @Override
    public void close() {
    }
}

