/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.gh;

import com.dataiku.common.rpc.APIKeyAuthAPIClient;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.gh.GovernIntegrationService;
import com.dataiku.dip.utils.BackOffStrategy;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss_gh.api.models.GovernInstanceStatus;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatusList;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifierList;
import com.dataiku.dss_gh.api.models.metrics.DSSSavedModelVersionEvaluationMetrics;
import com.dataiku.dss_gh.api.models.sync.DSSDeployerItems;
import com.dataiku.dss_gh.api.models.sync.DSSProject;
import com.dataiku.dss_gh.api.models.sync.DSSProjectList;
import com.google.api.client.util.BackOff;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;

public class GovernIntegrationClient
extends APIKeyAuthAPIClient {
    private static final String BASE_URL = "dip/publicapi/";
    private static final String DSS_URL = "dip/publicapi/dss/";
    private static final String FUTURES_URL = "dip/publicapi/futures/";
    private static final BackOffStrategy BACK_OFF_STRATEGY = BackOffStrategy.expBackOff((int)DKUApp.getProperty((String)"dku.governIntegrationClient.backoff.initialWaitMs", (int)10), (int)DKUApp.getProperty((String)"dku.governIntegrationClient.backoff.maxWaitMs", (int)15000), (double)Double.parseDouble(DKUApp.getProperty((String)"dku.governIntegrationClient.backoff.multiplier", (String)"2")));
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.govern-integration-client");

    protected static GovernIntegrationClient build() throws CodedException {
        GeneralSettingsDAO.NodeRef governRef = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().governIntegrationSettings.getRef();
        GovernIntegrationService.checkGovernIntegrationIsEnabledAndProperlyConfigured(governRef);
        return new GovernIntegrationClient(governRef);
    }

    private GovernIntegrationClient(GeneralSettingsDAO.NodeRef governRef) {
        super(governRef.nodeUrl, governRef.apiKey, governRef.trustAllSSLCertificates);
    }

    protected GovernInstanceStatus getGovernInstanceStatus() throws IOException {
        return (GovernInstanceStatus)this.get("dip/publicapi/dss/status", GovernInstanceStatus.class);
    }

    protected void projectListDeleteDiff(DSSProjectList dssProjectList) throws IOException, InterruptedException {
        FutureResponse<Void> fr = (FutureResponse<Void>)this.postObject("dip/publicapi/dss/project-list/delete-diff", (TypeToken)new TypeToken<FutureResponse<Void>>(){}, dssProjectList);
        fr = this.waitForFuture(fr, new TypeToken<FutureResponse<Void>>(){});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DSS project delete diff completed: " + JSON.pretty(fr)));
        }
    }

    protected void projectPartialSync(DSSProject dssProject) throws IOException, InterruptedException {
        FutureResponse<Void> fr = (FutureResponse<Void>)this.postObject("dip/publicapi/dss/project/partial-sync", (TypeToken)new TypeToken<FutureResponse<Void>>(){}, dssProject);
        fr = this.waitForFuture(fr, new TypeToken<FutureResponse<Void>>(){});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DSS partial sync completed: " + JSON.pretty(fr)));
        }
    }

    protected void projectFullSync(DSSProject dssProject) throws IOException, InterruptedException {
        FutureResponse<Void> fr = (FutureResponse<Void>)this.postObject("dip/publicapi/dss/project/full-sync", (TypeToken)new TypeToken<FutureResponse<Void>>(){}, dssProject);
        fr = this.waitForFuture(fr, new TypeToken<FutureResponse<Void>>(){});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Project sync completed: " + JSON.pretty(fr)));
        }
    }

    protected void deleteDSSItem(DSSItemIdentifier dssItemIdentifier) throws IOException, InterruptedException {
        FutureResponse<Void> fr = (FutureResponse<Void>)this.postObject("dip/publicapi/dss/delete", (TypeToken)new TypeToken<FutureResponse<Void>>(){}, dssItemIdentifier);
        fr = this.waitForFuture(fr, new TypeToken<FutureResponse<Void>>(){});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DSS item deletion completed: " + JSON.pretty(fr)));
        }
    }

    protected void modelVersionEvaluationMetricsPartialSync(DSSSavedModelVersionEvaluationMetrics dssSavedModelVersionEvaluationMetrics) throws IOException, InterruptedException {
        FutureResponse<Void> fr = (FutureResponse<Void>)this.postObject("dip/publicapi/dss/saved-model-version/evaluation-metrics/partial-sync", (TypeToken)new TypeToken<FutureResponse<Void>>(){}, dssSavedModelVersionEvaluationMetrics);
        fr = this.waitForFuture(fr, new TypeToken<FutureResponse<Void>>(){});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deployer sync completed: " + JSON.pretty(fr)));
        }
    }

    protected void deployerSync(DSSDeployerItems dssDeployerItems) throws IOException, InterruptedException {
        FutureResponse<Void> fr = (FutureResponse<Void>)this.postObject("dip/publicapi/dss/deployer/full-sync", (TypeToken)new TypeToken<FutureResponse<Void>>(){}, dssDeployerItems);
        fr = this.waitForFuture(fr, new TypeToken<FutureResponse<Void>>(){});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deployer sync completed: " + JSON.pretty(fr)));
        }
    }

    protected void deployerPartialSync(DSSDeployerItems dssDeployerItems) throws IOException, InterruptedException {
        FutureResponse<Void> fr = (FutureResponse<Void>)this.postObject("dip/publicapi/dss/deployer/partial-sync", (TypeToken)new TypeToken<FutureResponse<Void>>(){}, dssDeployerItems);
        fr = this.waitForFuture(fr, new TypeToken<FutureResponse<Void>>(){});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deployer partial sync completed: " + JSON.pretty(fr)));
        }
    }

    protected void deleteDeployerItem(DSSItemIdentifier dssItemIdentifier) throws IOException, InterruptedException {
        FutureResponse<Void> fr = (FutureResponse<Void>)this.postObject("dip/publicapi/dss/delete-deployer", (TypeToken)new TypeToken<FutureResponse<Void>>(){}, dssItemIdentifier);
        fr = this.waitForFuture(fr, new TypeToken<FutureResponse<Void>>(){});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delete deployer item completed: " + JSON.pretty(fr)));
        }
    }

    protected DSSItemGovernanceStatusList getDSSItemsGovernanceStatus(DSSItemIdentifierList dssItemIdentifierList) throws IOException {
        return (DSSItemGovernanceStatusList)this.postObject("dip/publicapi/dss/governance-status", DSSItemGovernanceStatusList.class, dssItemIdentifierList);
    }

    protected <T> FutureResponse<T> waitForFuture(FutureResponse<T> fr, TypeToken<FutureResponse<T>> clazz) throws IOException, InterruptedException {
        BackOff backoffStrategy = BACK_OFF_STRATEGY.build();
        while (!fr.hasResult && !fr.aborted) {
            logger.debugV("Wait some more for the instantiation to finish on future '%s'", new Object[]{fr.jobId});
            long waitMillis = backoffStrategy.nextBackOffMillis();
            if (waitMillis < 0L) {
                backoffStrategy = BACK_OFF_STRATEGY.build();
                waitMillis = backoffStrategy.nextBackOffMillis();
            }
            Thread.sleep(waitMillis);
            fr = (FutureResponse)this.get(FUTURES_URL + fr.jobId, clazz);
        }
        return fr;
    }
}

