/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.graphicsexport.charts.execution;

import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.graphicsexport.execution.GraphicsExportUtils;
import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.regex.Pattern;

public class DomElementExportPostProcessor {
    private static final Pattern FILENAME_PATTERN = Pattern.compile("(?<chartId>.+)\\.(png|txt|json)");
    private final File finalDirectory;
    private final File rawExportDirectory;
    private final File postProcessDirectory;

    public DomElementExportPostProcessor(File rawExportDirectory, File postProcessDirectory, File finalDirectory) {
        this.rawExportDirectory = rawExportDirectory;
        this.postProcessDirectory = postProcessDirectory;
        this.finalDirectory = finalDirectory;
    }

    public File execute() throws IOException {
        return this.postProcessFiles();
    }

    private File postProcessFiles() throws IOException {
        for (File f : DomElementExportPostProcessor.listFiles(this.rawExportDirectory)) {
            DomElementExportPostProcessor.move(f, new File(this.postProcessDirectory, f.getName()));
        }
        File finalFile = new File(this.finalDirectory, "export.zip");
        ZipUnzipDir.zipDirectory(this.postProcessDirectory, finalFile);
        return finalFile;
    }

    private static List<File> listFiles(File directory) {
        return GraphicsExportUtils.listFiles(directory, (FilenameFilter)new PatternFilenameFilter(FILENAME_PATTERN));
    }

    private static void move(File srcFile, File destFile) throws IOException {
        Files.move(srcFile.toPath(), destFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }
}

