/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.serde;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.hive.HiveSerdeShimsLoader;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.serde2.objectinspector.DSSArrayObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.DSSBaseInspector;
import org.apache.hadoop.hive.serde2.objectinspector.DSSMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.DSSObjectObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.DSSRowObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DSSBooleanInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DSSByteInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DSSDoubleInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DSSFloatInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DSSIntInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DSSLongInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DSSShortInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DSSStringInspector;

public class ObjectInspectorBuilder {
    public static String hiveTypeInfoFromDSSSchema(Schema schema) {
        ObjectInspectorBuilder oib = new ObjectInspectorBuilder();
        ArrayList<String> types = new ArrayList<String>();
        for (SchemaColumn sc : schema.getColumns()) {
            types.add(oib.buildObjectInspector(sc).getTypeName());
        }
        return Joiner.on((String)",").join(types);
    }

    public StructObjectInspector buildRowInspector(ColumnFactory cf, Schema schema) {
        return new DSSRowObjectInspector(this, schema, cf);
    }

    public DSSBaseInspector buildMapObjectInspector(SchemaColumn sc) {
        SchemaColumn mapKeys = sc.mapKeys;
        SchemaColumn mapValues = sc.mapValues;
        if (mapKeys == null) {
            throw new RuntimeException("Map key type is not defined (must be 'string')");
        }
        if (mapValues == null) {
            throw new RuntimeException("Map value type is not defined");
        }
        DSSBaseInspector keyInspector = this.buildObjectInspector(mapKeys);
        DSSBaseInspector valueInspector = this.buildObjectInspector(mapValues);
        DSSMapObjectInspector mapInspector = new DSSMapObjectInspector(keyInspector, valueInspector);
        keyInspector.setParent(mapInspector);
        valueInspector.setParent(mapInspector);
        return mapInspector;
    }

    public DSSObjectObjectInspector buildStructObjectInspector(SchemaColumn sc) {
        List objectFields = sc.objectFields;
        if (objectFields == null) {
            throw new RuntimeException("Object fields type are not defined");
        }
        ArrayList<DSSBaseInspector> ois = new ArrayList<DSSBaseInspector>();
        ArrayList<String> names = new ArrayList<String>();
        for (SchemaColumn field : objectFields) {
            ois.add(this.buildObjectInspector(field));
            String name = field.getName();
            if (StringUtils.isBlank((String)name)) {
                throw new RuntimeException("Invalid struct field name:" + name);
            }
            names.add(name);
        }
        DSSObjectObjectInspector structObjectInspector = new DSSObjectObjectInspector(names, ois);
        for (DSSBaseInspector oi : ois) {
            oi.setParent(structObjectInspector);
        }
        return structObjectInspector;
    }

    public DSSBaseInspector buildArrayObjectInspector(SchemaColumn sc) {
        SchemaColumn arrayContent = sc.arrayContent;
        if (arrayContent == null) {
            throw new RuntimeException("Array element type is not defined");
        }
        DSSBaseInspector arrayContentInspector = this.buildObjectInspector(arrayContent);
        DSSArrayObjectInspector arrayInspector = new DSSArrayObjectInspector(arrayContentInspector);
        arrayContentInspector.setParent(arrayInspector);
        return arrayInspector;
    }

    public DSSBaseInspector buildObjectInspector(SchemaColumn sc) {
        switch (sc.getType()) {
            case TINYINT: {
                return new DSSByteInspector();
            }
            case SMALLINT: {
                return new DSSShortInspector();
            }
            case INT: {
                return new DSSIntInspector();
            }
            case BIGINT: {
                return new DSSLongInspector();
            }
            case FLOAT: {
                return new DSSFloatInspector();
            }
            case DOUBLE: {
                return new DSSDoubleInspector();
            }
            case BOOLEAN: {
                return new DSSBooleanInspector();
            }
            case STRING: {
                return new DSSStringInspector();
            }
            case DATE: 
            case DATETIMENOTZ: {
                return HiveSerdeShimsLoader.get().getTimestampInspector();
            }
            case DATEONLY: {
                return HiveSerdeShimsLoader.get().getDateInspector();
            }
            case ARRAY: {
                return this.buildArrayObjectInspector(sc);
            }
            case MAP: {
                return this.buildMapObjectInspector(sc);
            }
            case OBJECT: {
                return this.buildStructObjectInspector(sc);
            }
        }
        throw new RuntimeException("Not a primitive type or unsupported type " + String.valueOf(sc.getType()));
    }
}

