/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.input.formats.parquet.ConverterFactory;
import com.dataiku.dip.input.formats.parquet.DSSParquetInputFormat;
import com.dataiku.dip.input.formats.parquet.ParentValueContainer;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetSchemaConverter;
import org.apache.log4j.Logger;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;

class RowTupleConverter
extends GroupConverter {
    private static Logger logger = Logger.getLogger(RowTupleConverter.class);
    private final RowFactory rowFactory;
    private final ColumnFactory columnFactory;
    private MessageType schema;
    private Converter[] converters;
    private Row currentRow;
    private ConverterFactory converterFactory;

    public static ParquetFormatConfig.Flavor messageTypeNameToFlavor(String mtn, ParquetFormatConfig.Flavor datasetDefaultFlavor) {
        switch (mtn) {
            case "hive_schema": {
                return ParquetFormatConfig.Flavor.HIVE;
            }
            case "pig_schema": {
                return ParquetFormatConfig.Flavor.PIG;
            }
            case "spark_schema": {
                return ParquetFormatConfig.Flavor.SPARK;
            }
        }
        logger.warn((Object)("Unrecognized Parquet message type name : " + mtn + ". The detected flavor may be incorrect. Using " + String.valueOf((Object)datasetDefaultFlavor) + " from dataset"));
        return datasetDefaultFlavor;
    }

    public RowTupleConverter(DSSParquetInputFormat dssParquetInputFormat, MessageType schema, ColumnFactory cf, RowFactory rf, boolean representsNullFields, ParquetFormatConfig.Flavor datasetDefaultFlavor) {
        this.schema = schema;
        this.rowFactory = rf;
        this.columnFactory = cf;
        this.converters = new Converter[schema.getFieldCount()];
        ParquetFormatConfig.Flavor flavor = RowTupleConverter.messageTypeNameToFlavor(schema.getName(), datasetDefaultFlavor);
        this.converterFactory = new ConverterFactory(flavor, representsNullFields);
        logger.info((Object)("Reading Input Parquet flavor: " + String.valueOf((Object)flavor) + " schema: " + schema.toString().replace("\n", " ")));
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            Type type = schema.getType(i);
            String name = schema.getFieldName(i);
            final Column col = this.columnFactory.column(name);
            SchemaColumn sc = null;
            if (dssParquetInputFormat.getCurrentSchema() != null) {
                sc = dssParquetInputFormat.getCurrentSchema().getColumn(name);
            }
            this.converters[i] = this.converterFactory.createConverter(type, sc, new ParentValueContainer(){

                @Override
                void add(Object value) {
                    RowTupleConverter.this.currentRow.put(col, value.toString());
                }

                @Override
                void addInteger(int value) {
                    RowTupleConverter.this.currentRow.put(col, String.valueOf(value));
                }

                @Override
                void addLong(long value) {
                    RowTupleConverter.this.currentRow.put(col, String.valueOf(value));
                }

                @Override
                void addString(String value) {
                    RowTupleConverter.this.currentRow.put(col, value);
                }

                @Override
                void addDouble(double value) {
                    RowTupleConverter.this.currentRow.put(col, String.valueOf(value));
                }

                @Override
                void addFloat(float value) {
                    RowTupleConverter.this.currentRow.put(col, String.valueOf(value));
                }

                @Override
                void addBoolean(boolean value) {
                    RowTupleConverter.this.currentRow.put(col, String.valueOf(value));
                }
            });
        }
        dssParquetInputFormat.setDetectedSchema(ParquetSchemaConverter.convert(schema, dssParquetInputFormat.getCurrentSchema(), dssParquetInputFormat.getReadTemporalMode(), datasetDefaultFlavor));
    }

    public Converter getConverter(int i) {
        return this.converters[i];
    }

    public void start() {
        this.currentRow = this.rowFactory.row();
    }

    public void end() {
    }

    public Row getCurrentRow() {
        return this.currentRow;
    }
}

