/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.apideployer.datamodel.config.K8SAPIDeploymentInfra;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecUtils;
import com.dataiku.dip.containers.exec.KubectlHelper;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.io.JavaBlockLink;
import com.dataiku.dip.io.KernelErrorCodes;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.k8s.IK8SContainerLimits;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;

public class KubernetesSimplePythonKernel
extends DSSKernelBase
implements SimplePythonKernel {
    private final ContainerExecRuntimeConfig containerConfig;
    private ResponderKernelLink link;
    private final String identifier;
    private final String executionId;
    private final String projectKey;
    private final AuthCtx authCtx;
    private final File workDir;
    private final String pythonModule;
    private final String prefix;
    private final List<CodeEnvModel.EnvFullRef> codeEnvs;
    private String imageTag;
    private final Boolean loadInstanceLibs;
    private final Boolean loadProjectLibs;
    private final DKULogger logger;
    private CountDownLatch monitorThreadCDL;
    private final Map<String, String> extraEnv = new HashMap<String, String>();
    private List<String> readablePaths = new ArrayList<String>();
    private String executionPath;
    private APITicketService.Ticket ticket;
    private static final DKULogger loggerAdditive = DKULogger.getLogger((String)"com.dataiku.dip.io");
    public static final DKULogger loggerNotAdditive = DKULogger.getLogger((String)"notadditive.com.dataiku.dip.io");

    KubernetesSimplePythonKernel(String id, AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, CodeEnvModel.UsedCodeEnvRef codeEnvRef, String pythonModule, String prefix, boolean loadInstanceLibs, boolean loadProjectLibs, boolean additiveLogging) throws IOException {
        super(id);
        this.projectKey = projectKey;
        this.authCtx = authCtx;
        this.identifier = SecretKeyGenerator.generateSmall();
        this.executionId = KubernetesExecUtils.getNormalizedExecutionId(prefix + this.identifier);
        this.containerConfig = containerConfig;
        this.workDir = DSSTempUtils.getTempFolder((String)("dku_exec-" + this.executionId));
        this.pythonModule = pythonModule;
        this.prefix = prefix;
        this.loadInstanceLibs = loadInstanceLibs;
        this.loadProjectLibs = loadProjectLibs;
        if (codeEnvRef == null) {
            this.codeEnvs = Collections.emptyList();
            this.imageTag = ContainerExecImagesHelper.getBaseImageTag(containerConfig.baseImage, ContainerExecUtils.BaseImageType.EXEC);
        } else {
            String envVersion = ((CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class)).getEnvVersionToUseForContainerImageLookup(codeEnvRef.envName, codeEnvRef.envLang, projectKey);
            CodeEnvModel.EnvFullRef envRef = new CodeEnvModel.EnvFullRef(codeEnvRef.envLang, codeEnvRef.envName, envVersion);
            this.imageTag = ContainerExecImagesHelper.getImageTagToUse(containerConfig.dockerHost, containerConfig.baseImage, ContainerExecUtils.BaseImageType.EXEC, codeEnvRef.envLang, codeEnvRef.envName, envVersion);
            this.imageTag = ContainerExecImagesHelper.withRepositoryURL(containerConfig.repositoryURL, this.imageTag);
            this.codeEnvs = Collections.singletonList(envRef);
        }
        this.logger = additiveLogging ? loggerAdditive : loggerNotAdditive;
    }

    public KubernetesSimplePythonKernel withExtraEnv(Map<String, String> extraEnv) {
        this.extraEnv.putAll(extraEnv);
        return this;
    }

    @Override
    public KubernetesSimplePythonKernel withReadablePaths(List<String> readablePaths) {
        this.readablePaths.addAll(readablePaths);
        return this;
    }

    @Override
    public KubernetesSimplePythonKernel withExecutionPath(String executionPath) {
        this.executionPath = executionPath;
        return this;
    }

    public String getClusterId() throws IOException {
        if (StringUtils.isNotBlank((String)this.containerConfig.overridenFromK8SClusterId)) {
            return this.containerConfig.overridenFromK8SClusterId;
        }
        return new ClusterSelector().getClusterForProject(this.projectKey, Cluster.ClusterArchitecture.KUBERNETES);
    }

    public String getPodName() {
        return KubernetesExecUtils.getPodName(this.executionId);
    }

    public ComputeResourceUsage buildComputeResourceUsage() throws IOException {
        String k8sClusterId = this.getClusterId();
        K8SAPIDeploymentInfra.K8SContainerLimits k8sContainerLimits = this.containerConfig.kubernetesResources;
        return ComputeResourceUsage.forSingleK8SJob((String)k8sClusterId, (String)this.executionId, (IK8SContainerLimits)k8sContainerLimits);
    }

    @Override
    public void start() throws IOException, InterruptedException, CodedException {
        KubectlHelper.KubectlLoopCaller kubectlPodTopper;
        block21: {
            if (this.link != null) {
                throw new IllegalStateException("Kernel already started");
            }
            String k8sClusterId = this.getClusterId();
            ComputeResourceUsage computeResourceUsage = ComputeResourceUsage.forSingleK8SJob((String)k8sClusterId, (String)this.executionId, (IK8SContainerLimits)this.containerConfig.kubernetesResources);
            KubernetesExecUtils.KubernetesPod kubernetesPod = null;
            KubectlHelper.KubectlLoopCaller kubectlPodDescriber = null;
            kubectlPodTopper = null;
            try {
                try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Initializing kubernetes kernel", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    FutureProgress.updateState((double)0.0);
                    PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
                    this.link = new ResponderKernelLink(dssPortRange, EncryptedRPC.getSSLContext());
                    final APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                    this.ticket = ticketService.createTicket(this.authCtx, this.prefix + this.projectKey + "-" + this.identifier, null);
                    this.addOnShutdown(new Runnable(){

                        @Override
                        public void run() {
                            ticketService.expireTicket(KubernetesSimplePythonKernel.this.ticket);
                        }
                    });
                    JsonObject definition = new JsonObject();
                    definition.addProperty("port", (Number)this.link.getPort());
                    definition.addProperty("secret", this.link.getSecret());
                    definition.addProperty("server_cert", EncryptedRPC.getPEMCertificateTextB64orNA());
                    definition.addProperty("module", this.pythonModule);
                    definition.addProperty("load_instance_libs", this.loadInstanceLibs);
                    definition.addProperty("load_project_libs", this.loadProjectLibs);
                    RemoteRunsRegistry.add(this.executionId, this.authCtx, this.projectKey, null, this.executionPath, RemoteRunsRegistry.ExecutionType.SIMPLE_PYTHON, definition.toString(), null, this.readablePaths, Collections.emptyList(), this.codeEnvs);
                    File secretFile = new File(this.workDir, "secret.yaml");
                    File podFile = new File(this.workDir, "pod.yaml");
                    EnvironmentStash environmentStash = new EnvironmentStash();
                    environmentStash.fillDefaultForRemote().fillCommunicationVars();
                    RemoteRunEnvDef envResource = new RemoteRunEnvDef();
                    environmentStash.copyToRemoteRunEnvDef(envResource, false, false, false);
                    envResource.runsRemotely = true;
                    envResource.jobId = this.executionId;
                    RemoteRunsRegistry.get((String)this.executionId).envResource = envResource;
                    Map<String, String> env = environmentStash.getAsEnvVariables(false, false, false);
                    env.putAll(this.extraEnv);
                    env.put("DKU_CURRENT_PROJECT_KEY", this.projectKey);
                    String secretDesc = KubernetesExecUtils.getTicketSecretConf(this.executionId, this.ticket.getSecret());
                    KubernetesExecUtils.LabelsAndAnnotations laa = KubernetesExecUtils.getIdentifiersBasedOnCRUContext(this.authCtx, this.executionId, this.containerConfig);
                    String podDesc = KubernetesExecUtils.getPodConf(this.authCtx, this.executionId, this.projectKey, "NA", this.identifier, laa, env, this.imageTag, this.containerConfig);
                    String podName = this.getPodName();
                    DKUFileUtils.writeFileUTF8((File)secretFile, (String)secretDesc);
                    DKUFileUtils.writeFileUTF8((File)podFile, (String)podDesc);
                    kubernetesPod = new KubernetesExecUtils.KubernetesPod(this.authCtx, this.projectKey, podName, this.containerConfig, secretFile, podFile);
                    this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)kubernetesPod.getErrorSniffer());
                    this.process = kubernetesPod;
                    this.process.start();
                    computeResourceUsage.reportStartNoFail();
                    this.startStandardTailers();
                    this.monitorThread = new K8SKernelMonitorThread();
                    this.monitorThread.setCloseOnFailure((Closeable)this);
                    this.monitorThread.start();
                    this.monitorThreadCDL = new CountDownLatch(1);
                    JobActivity currentActivity = JobContext.getCurrentActivityObj();
                    if (currentActivity != null) {
                        kubectlPodDescriber = KubectlHelper.createPodDescriber(this.authCtx, this.projectKey, currentActivity, this.containerConfig, this.executionId);
                        if (kubectlPodDescriber != null) {
                            this.logger.info((Object)("Starting kubectl-loop: " + String.valueOf(kubectlPodDescriber)));
                            kubectlPodDescriber.start();
                        }
                        if ((kubectlPodTopper = KubectlHelper.createPodTopper(this.authCtx, this.projectKey, currentActivity, this.containerConfig, this.executionId)) != null) {
                            this.logger.info((Object)("Starting kubectl-loop: " + String.valueOf(kubectlPodTopper)));
                            kubectlPodTopper.start();
                        }
                    }
                    this.link.waitForProcess();
                    FutureProgress.updateState((double)1.0);
                    computeResourceUsage.reportCompleteNoFail();
                }
                if (kubectlPodDescriber == null) break block21;
            }
            catch (Exception e) {
                try {
                    IOException sniffed;
                    computeResourceUsage.markComplete();
                    this.close();
                    if (kubernetesPod != null && (sniffed = kubernetesPod.getSniffedException()) != null) {
                        throw sniffed;
                    }
                    throw new CodedException((InfoMessage.MessageCode)KernelErrorCodes.ERR_COMPUTE_KERNEL_FAILURE, "Kubernetes kernel failed to start", (Throwable)e);
                }
                catch (Throwable throwable) {
                    if (kubectlPodDescriber != null) {
                        this.logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodDescriber)));
                        kubectlPodDescriber.cancel();
                    }
                    if (kubectlPodTopper != null) {
                        this.logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodTopper)));
                        kubectlPodTopper.cancel();
                    }
                    if (this.monitorThread != null) {
                        this.monitorThread.setCloseOnFailure(null);
                    }
                    throw throwable;
                }
            }
            this.logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodDescriber)));
            kubectlPodDescriber.cancel();
        }
        if (kubectlPodTopper != null) {
            this.logger.info((Object)("Stopping kubectl-loop: " + String.valueOf(kubectlPodTopper)));
            kubectlPodTopper.cancel();
        }
        if (this.monitorThread != null) {
            this.monitorThread.setCloseOnFailure(null);
        }
    }

    protected void startStandardTailers() throws IOException {
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(this.logger, Level.INFO));
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(this.logger, Level.INFO));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
    }

    @Override
    public DKUtils.SmartLogTailBuilder getSmartLogTailBuilder() {
        return this.smartLogTailBuilder;
    }

    @Override
    public APITicketService.Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public String getType() {
        return "kubernetes";
    }

    public IOException maybeRethrowAsProcessDied(IOException e) {
        IsolableProcess process = this.process;
        if (process == null) {
            this.logger.info((Object)"Kubernetes: process was cleaned up by monitoring thread");
            this.logger.info((Object)("Kubernetes: Trying to enrich exception: " + String.valueOf(e) + " from kernel " + String.valueOf(this) + " retcode=" + this.savedReturnCode));
        } else {
            this.logger.info((Object)("Kubernetes: Trying to enrich exception: " + String.valueOf(e) + " from kernel " + String.valueOf(this) + " process=" + String.valueOf(process) + " pid=" + process.getWorkingPid() + " retcode=" + this.savedReturnCode));
        }
        if (e instanceof EOFException || e.getCause() instanceof EOFException) {
            Integer returnCode = null;
            for (int i = 0; i < 20; ++i) {
                this.logger.debug((Object)"Trying to enrich exception, still waiting for pod to complete ...");
                DKUtils.unsafeSleep((long)1000L);
                returnCode = this.savedReturnCode;
                if (returnCode != null) break;
            }
            if (returnCode != null && returnCode != 0) {
                return new ProcessDiedException("Kubernetes pod failed: " + ExceptionUtils.getMessageWithCauses((Throwable)this.processExitException), this.getLogTail(), null, returnCode.intValue());
            }
            this.logger.warn((Object)"Still did not get a return code after EOF exception");
            return e;
        }
        return e;
    }

    @Override
    public JavaBlockLink getLink() {
        return this.link != null ? this.link.getBlockLink() : null;
    }

    @Override
    public boolean isAlive() {
        return !this.killed && this.link.isAlive() && !this.isFinished();
    }

    @Override
    public AuthCtx getAuthCtx() {
        return this.authCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.logger.info((Object)"Killing Kubernetes kernel");
        try {
            try {
                this.link.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"Could not close Javalink", (Throwable)e);
            }
            if (!this.killed) {
                try {
                    long pollingPeriodInMillis;
                    int pollingMaxTries;
                    long timeoutInMillis;
                    boolean cleanExit;
                    if (this.monitorThreadCDL != null && !(cleanExit = this.monitorThreadCDL.await(timeoutInMillis = (long)((pollingMaxTries = KubernetesExecUtils.getPodStatusPollingMaxTries()) + 1) * (pollingPeriodInMillis = KubernetesExecUtils.getPodStatusPollingPeriodInMillis()), TimeUnit.MILLISECONDS))) {
                        this.logger.warn((Object)"K8SKernelMonitorThread still waiting for pod completion: killing the kubernetes kernel anyway");
                    }
                    this.killWithoutMercy();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.logger.error((Object)"Interrupted while killing kubernetes kernel", (Throwable)e);
                }
                catch (IOException e) {
                    this.logger.error((Object)"Could not kill the kubernetes kernel", (Throwable)e);
                }
            }
        }
        finally {
            RemoteRunsRegistry.remove(this.executionId);
            boolean keepTempFolder = DKUApp.getParams().getBoolParam("dku.pythonKernel.keepTempFolder", false);
            if (!keepTempFolder) {
                ((AutoDelete)this.workDir).close();
            }
        }
    }

    @Override
    public void appendKernelLogsToLogFile(File deploymentLogFile) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(new FileOutputStream(deploymentLogFile, true), true);
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.OutputWriterSubscription((Writer)writer, true));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.OutputWriterSubscription((Writer)writer, true));
    }

    @Override
    public void appendKernelLogsToSubscription(DKUtils.LineSubscription subscription) {
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)subscription);
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)subscription);
    }

    static {
        loggerNotAdditive.setAdditivity(false);
    }

    protected class K8SKernelMonitorThread
    extends DSSKernelBase.KernelMonitorThread {
        protected K8SKernelMonitorThread() {
            super((DSSKernelBase)KubernetesSimplePythonKernel.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setName("KNL-" + KubernetesSimplePythonKernel.this.id + "-k8smonitor-" + Thread.currentThread().getId());
            try {
                KubernetesSimplePythonKernel.this.outputConsumer.start(KubernetesSimplePythonKernel.this.process.getInputStream(), KubernetesSimplePythonKernel.this.process.getErrorStream(), KubernetesSimplePythonKernel.this.process.getOutputStream());
                KubernetesSimplePythonKernel.this.logger.info((Object)"Waiting for K8S pod termination");
                Object k8sPodException = KubernetesExecUtils.waitForPod(KubernetesSimplePythonKernel.this.authCtx, KubernetesSimplePythonKernel.this.projectKey, KubernetesExecUtils.getPodName(KubernetesSimplePythonKernel.this.executionId), KubernetesSimplePythonKernel.this.containerConfig, null);
                KubernetesSimplePythonKernel.this.monitorThreadCDL.countDown();
                KubernetesSimplePythonKernel.this.logger.info((Object)("K8S pod terminated, exception:" + String.valueOf(k8sPodException)));
                int logHandlerReturnValue = KubernetesSimplePythonKernel.this.process.waitFor();
                KubernetesSimplePythonKernel.this.logger.info((Object)("Log handling process done with code " + logHandlerReturnValue));
                KubernetesSimplePythonKernel.this.processExitException = k8sPodException;
                KubernetesSimplePythonKernel kubernetesSimplePythonKernel = KubernetesSimplePythonKernel.this;
                synchronized (kubernetesSimplePythonKernel) {
                    if (k8sPodException == null) {
                        KubernetesSimplePythonKernel.this.savedReturnCode = 0;
                    } else {
                        KubernetesSimplePythonKernel.this.savedReturnCode = 1;
                    }
                }
                KubernetesSimplePythonKernel.this.tryUnregisterHook();
                KubernetesSimplePythonKernel.this.outputConsumer.finish();
            }
            catch (Exception e) {
                KubernetesSimplePythonKernel.this.logger.error((Object)"Failure while monitoring K8S pod", (Throwable)e);
            }
            finally {
                K8SKernelMonitorThread k8SKernelMonitorThread = this;
                synchronized (k8SKernelMonitorThread) {
                    if (this.toInterrupt != null) {
                        KubernetesSimplePythonKernel.this.logger.info((Object)("K8SKernelMonitorThread done: Interrupting : " + String.valueOf(this.toInterrupt)));
                        this.toInterrupt.interrupt();
                    }
                    if (this.toClose != null) {
                        KubernetesSimplePythonKernel.this.logger.error((Object)("K8SKernelMonitorThread done:  Closing: " + String.valueOf(this.toClose)));
                        IOUtils.closeQuietly((Closeable)this.toClose);
                    }
                }
            }
        }
    }
}

