/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerPool;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.io.AbstractImpersonableSecretProtectedPythonKernel;
import com.dataiku.dip.io.JavaBlockLink;
import com.dataiku.dip.io.KernelErrorCodes;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;

public class LocalSimplePythonKernel
extends AbstractImpersonableSecretProtectedPythonKernel<ResponderKernelLink>
implements SimplePythonKernel {
    private final String pythonPackage;
    private final DKULogger logger;
    private boolean createdTheWorkdir = false;
    private static final DKULogger loggerAdditive = DKULogger.getLogger((String)"com.dataiku.dip.io");
    public static final DKULogger loggerNotAdditive = DKULogger.getLogger((String)"notadditive.com.dataiku.dip.io");

    public LocalSimplePythonKernel(AuthCtx authCtx, String projectKey, GeneralSettingsDAO.CGrouppableProcessType cGrouppableProcessType, String envName, String pythonPackage, boolean impersonate, boolean useProjectLibs, Map<String, String> pythonLibs, boolean additiveLogging, String kernelId) throws IOException {
        this(authCtx, projectKey, cGrouppableProcessType, envName, pythonPackage, impersonate, useProjectLibs, pythonLibs, additiveLogging, null, kernelId);
    }

    public LocalSimplePythonKernel(AuthCtx authCtx, String projectKey, GeneralSettingsDAO.CGrouppableProcessType cGrouppableProcessType, String envName, String pythonPackage, boolean impersonate, boolean useProjectLibs, Map<String, String> pythonLibs, boolean additiveLogging, WorkerPool workerPool, String kernelId) throws IOException {
        this(authCtx, projectKey, cGrouppableProcessType, envName, pythonPackage, impersonate, (File)(impersonate ? DSSTempUtils.getTempFolder((String)("dku_exec-" + projectKey + "-" + SecretKeyGenerator.generateSmall())) : null), useProjectLibs, pythonLibs, additiveLogging, workerPool, kernelId, ((APITicketService)SpringUtils.getBean(APITicketService.class)).createTicket(authCtx, projectKey, null));
        this.createdTheWorkdir = impersonate;
    }

    private LocalSimplePythonKernel(AuthCtx authCtx, String projectKey, GeneralSettingsDAO.CGrouppableProcessType cGrouppableProcessType, String envName, String pythonPackage, boolean impersonate, File workDir, boolean useProjectLibs, Map<String, String> pythonLibs, boolean additiveLogging, WorkerPool workerPool, String kernelId, APITicketService.Ticket ticket) throws IOException {
        super(new ResponderKernelLink(ApplicationConfigurator.getPortRangeParams()), cGrouppableProcessType, ticket, null, useProjectLibs, pythonLibs, workDir, impersonate, projectKey, authCtx, envName, workerPool, kernelId);
        if (!impersonate) assert (!this.useProjectLibs);
        this.pythonPackage = pythonPackage;
        this.logger = additiveLogging ? loggerAdditive : loggerNotAdditive;
        this.kernelEnvVariables.putAll(new EnvironmentStash().fillDefault().fillDefaultForLocalExec().getAsEnvVariables(true, false, false));
        this.kernelEnvVariables.put("DKU_EXECUTION_ENV", "local");
        this.addOnShutdown(() -> ((APITicketService)SpringUtils.getBean(APITicketService.class)).expireTicket(ticket));
    }

    @Override
    public SimplePythonKernel withReadablePaths(List<String> readablePaths) {
        return this;
    }

    @Override
    public SimplePythonKernel withExecutionPath(String executionPath) {
        return this;
    }

    @Override
    public void start() throws CodedException, IOException, InterruptedException {
        ComputeResourceUsage computeResourceUsage = ComputeResourceUsage.forLocalProcess();
        try (FutureProgress.AutocloseableFutureProgressState fp = FutureProgress.pushAutoCloseableState((String)"Initializing kernel", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            FutureProgress.updateState((double)0.0);
            super.start();
            computeResourceUsage.reportStartNoFail();
            FutureProgress.updateState((double)1.0);
            computeResourceUsage.reportCompleteNoFail();
        }
        catch (Exception e) {
            computeResourceUsage.markComplete();
            this.close();
            throw new CodedException((InfoMessage.MessageCode)KernelErrorCodes.ERR_COMPUTE_KERNEL_FAILURE, "Local kernel failed to start", (Throwable)e);
        }
    }

    protected void startStandardTailers() throws IOException {
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(this.logger, Level.INFO));
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.LoggingLineSubscription(this.logger, Level.INFO));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(this.smartLogTailBuilder));
    }

    @Override
    public String getType() {
        return "local";
    }

    @Override
    public void close() throws IOException {
        this.logger.info((Object)"Killing local kernel");
        try {
            try {
                ((ResponderKernelLink)this.link).close();
            }
            catch (IOException e) {
                this.logger.error((Object)"Could not close Javalink", (Throwable)e);
            }
            try {
                if (!this.killed) {
                    this.killWithoutMercy();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while killing local kernel", e);
            }
        }
        finally {
            boolean keepTempFolder;
            if (this.workDir != null && this.createdTheWorkdir && !(keepTempFolder = DKUApp.getParams().getBoolParam("dku.pythonKernel.keepTempFolder", false))) {
                ((AutoDelete)this.workDir).close();
            }
        }
    }

    @Override
    public void appendKernelLogsToLogFile(File deploymentLogFile) throws FileNotFoundException {
        PrintWriter writer = new PrintWriter(new FileOutputStream(deploymentLogFile, true), true);
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.OutputWriterSubscription((Writer)writer, true));
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.OutputWriterSubscription((Writer)writer, true));
    }

    @Override
    public void appendKernelLogsToSubscription(DKUtils.LineSubscription subscription) {
        this.outputConsumer.withOutputConsumer((DKUtils.ExecSubscription)subscription);
        this.outputConsumer.withErrorConsumer((DKUtils.ExecSubscription)subscription);
    }

    @Override
    public APITicketService.Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public JavaBlockLink getLink() {
        return ((ResponderKernelLink)this.link).getBlockLink();
    }

    @Override
    public boolean isAlive() {
        return !this.killed && ((ResponderKernelLink)this.link).isAlive() && !this.isFinished();
    }

    @Override
    public AuthCtx getAuthCtx() {
        return this.authCtx;
    }

    @Override
    protected String getPythonModule() {
        return this.pythonPackage;
    }

    @Override
    public DKUtils.SmartLogTailBuilder getSmartLogTailBuilder() {
        return this.smartLogTailBuilder;
    }

    static {
        loggerNotAdditive.setAdditivity(false);
    }
}

