/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.consensus;

import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.consensus.LabelingCommentMerger;
import java.util.Map;

public class ConsensualCommentComputer {
    private final LabelingTask.AutoValidateCommentStrategy strategy;

    public ConsensualCommentComputer(LabelingTask.AutoValidateCommentStrategy strategy) {
        this.strategy = strategy;
    }

    public Result compute(Map<String, String> commentsByAnnotators) {
        LabelingCommentMerger.MergeResult mergeResult = LabelingCommentMerger.merge(commentsByAnnotators);
        if (this.strategy == LabelingTask.AutoValidateCommentStrategy.BLOCK_IF_ANY && mergeResult.nbDistinctComments > 0) {
            return Result.conflict(mergeResult.mergedComment);
        }
        if (mergeResult.nbDistinctComments <= 1) {
            return Result.success(mergeResult.mergedComment);
        }
        if (this.strategy == LabelingTask.AutoValidateCommentStrategy.CONCATENATE_IF_DIFFERENT) {
            return Result.success(mergeResult.mergedComment);
        }
        return Result.conflict(mergeResult.mergedComment);
    }

    public static class Result {
        public final boolean conflict;
        public final String comment;

        private Result(boolean conflict, String comment) {
            this.conflict = conflict;
            this.comment = comment;
        }

        public static Result conflict(String suggestedComment) {
            return new Result(true, suggestedComment);
        }

        public static Result success(String resolvedComment) {
            return new Result(false, resolvedComment);
        }
    }
}

