/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.llm.LLMStructuredRef;
import javax.annotation.Nonnull;

public class EnrichedLLMStructuredRef
extends LLMStructuredRef {
    public boolean promptDriven = true;
    public boolean customClassificationRequiresHypothesisTemplate;
    public boolean canDoNativeSentimentAnalysis;
    public boolean canDoNativeEmotionAnalysis;
    public boolean canGenerateCrossLanguageOutput;
    public boolean handlesSystemMessage;
    public boolean supportsImageInputs;
    public String baseModelId;
    public boolean canBeFinetuned = true;
    public boolean originalLLMIsUnreferenced = false;
    public Integer embeddingSize;
    public Integer maxTokensLimit;
    public String friendlyName;
    public String friendlyNameShort;
    public FieldRange temperatureRange;
    public FieldRange topKRange;

    public EnrichedLLMStructuredRef(LLMStructuredRef llmRef, String friendlyName, String friendlyNameShort) {
        this(llmRef, friendlyName, friendlyNameShort, null, null);
    }

    public EnrichedLLMStructuredRef(LLMStructuredRef llmRef, String friendlyName, String friendlyNameShort, Integer embeddingSize, Integer maxTokensLimit, String baseModelId, boolean originalLLMIsUnreferenced) {
        this(llmRef, friendlyName, friendlyNameShort, embeddingSize, maxTokensLimit);
        this.baseModelId = baseModelId;
        this.originalLLMIsUnreferenced = originalLLMIsUnreferenced;
    }

    public EnrichedLLMStructuredRef(LLMStructuredRef llmRef, String friendlyName, String friendlyNameShort, Integer embeddingSize, Integer maxTokensLimit) {
        this.id = llmRef.id;
        this.type = llmRef.type;
        this.connection = llmRef.connection;
        this.model = llmRef.model;
        this.deployment = llmRef.deployment;
        this.savedModelSmartId = llmRef.savedModelSmartId;
        this.savedModelVersionId = llmRef.savedModelVersionId;
        this.sageMakerModelType = llmRef.sageMakerModelType;
        this.friendlyName = friendlyName;
        this.friendlyNameShort = friendlyNameShort;
        this.embeddingSize = embeddingSize;
        this.maxTokensLimit = maxTokensLimit;
    }

    public void loadModelCapabilities(AbstractLLMConnection.ModelCapabilities modelCapabilities) {
        this.promptDriven = modelCapabilities.promptDriven;
        this.temperatureRange = modelCapabilities.temperatureRange;
        this.topKRange = modelCapabilities.topKRange;
        this.customClassificationRequiresHypothesisTemplate = modelCapabilities.customClassificationRequiresHypothesisTemplate;
        this.canDoNativeSentimentAnalysis = modelCapabilities.canDoNativeSentimentAnalysis;
        this.canDoNativeEmotionAnalysis = modelCapabilities.canDoNativeEmotionAnalysis;
        this.canGenerateCrossLanguageOutput = modelCapabilities.canGenerateCrossLanguageOutput;
        this.handlesSystemMessage = modelCapabilities.handlesSystemMessage;
        this.supportsImageInputs = modelCapabilities.supportsImageInputs;
    }

    public AbstractLLMConnection.ModelCapabilities getModelCapabilities() {
        AbstractLLMConnection.ModelCapabilities modelCapabilities = new AbstractLLMConnection.ModelCapabilities();
        modelCapabilities.promptDriven = this.promptDriven;
        modelCapabilities.temperatureRange = this.temperatureRange;
        modelCapabilities.topKRange = this.topKRange;
        modelCapabilities.customClassificationRequiresHypothesisTemplate = this.customClassificationRequiresHypothesisTemplate;
        modelCapabilities.canDoNativeSentimentAnalysis = this.canDoNativeSentimentAnalysis;
        modelCapabilities.canDoNativeEmotionAnalysis = this.canDoNativeEmotionAnalysis;
        modelCapabilities.canGenerateCrossLanguageOutput = this.canGenerateCrossLanguageOutput;
        modelCapabilities.handlesSystemMessage = this.handlesSystemMessage;
        modelCapabilities.supportsImageInputs = this.supportsImageInputs;
        return modelCapabilities;
    }

    public static final class FieldRange {
        public final Double min;
        public final Double max;
        public final Double step;

        public FieldRange(Double min, Double max, Double step) {
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public FieldRange() {
            this(null, null, null);
        }

        public FieldRange(@Nonnull FieldRange originalRange) {
            this(originalRange.min, originalRange.max, originalRange.step);
        }
    }
}

