/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class LLMRelatedPoolablePythonServer {
    protected final String logsPropertiesPrefix;
    protected SimplePythonKernel kernel;
    protected final String kernelId;
    private static final Logger logger = Logger.getLogger((String)"dku.llm.poolableserver");

    public LLMRelatedPoolablePythonServer(String logsPropertiesPrefix, String kernelId) {
        this.logsPropertiesPrefix = logsPropertiesPrefix;
        this.kernelId = kernelId;
    }

    public void close() {
        if (this.kernel != null) {
            try {
                this.kernel.close();
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to kill kernel", e);
            }
        }
    }

    protected void setLogsWithRotation(File logDir, boolean devMode) throws IOException {
        int maxRotated = DKUApp.getParams().getIntParam(this.logsPropertiesPrefix + ".maxRotatedFiles", Integer.valueOf(2));
        long maxSize = DKUApp.getParams().getLongParam(this.logsPropertiesPrefix + "maxFileSizeKB", 1024L) * 1024L;
        int maxDevTailLines = DKUApp.getParams().getIntParam(this.logsPropertiesPrefix + "maxDevTailLines", Integer.valueOf(1000));
        int maxDevKeptFiles = DKUApp.getParams().getIntParam(this.logsPropertiesPrefix + "maxDevKeptFiles", Integer.valueOf(10));
        if (devMode) {
            DKUFileUtils.keepLastNItemsInFolder((File)logDir, (int)maxDevKeptFiles);
            logDir = DKUFileUtils.getWithin((File)logDir, (String[])new String[]{DKUDateUtils.isoFormatFileFriendlyLocalNow()});
            this.kernel.getSmartLogTailBuilder().setMaxLines(maxDevTailLines);
        } else {
            logDir = DKUFileUtils.getWithin((File)logDir, (String[])new String[]{this.kernelId});
        }
        DKUFileUtils.mkdirs((File)logDir);
        DKUtils.RotatingLoggingSubscription rls = new DKUtils.RotatingLoggingSubscription(logDir, "llm.log", maxRotated, maxSize);
        this.kernel.appendKernelLogsToSubscription((DKUtils.LineSubscription)rls);
    }

    public boolean isAlive() {
        return this.kernel != null && this.kernel.isAlive();
    }

    public String getKernelId() {
        return this.kernelId;
    }
}

