/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.governance.custom;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.llm.LLMRelatedPoolablePythonServer;
import com.dataiku.dip.llm.governance.custom.PythonGuardrailServerAPI;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PythonGuardrailServer
extends LLMRelatedPoolablePythonServer
implements PythonGuardrailServerAPI {
    private final DSSAuthCtx authCtx;
    private final String projectKey;
    private final String code;
    private final String envName;
    private final String containerConfName;
    private final String pluginId;
    private final String pluginPythonLibFolderPath;
    private final JsonObject config;
    private final JsonObject pluginConfig;
    private final boolean loadPythonLibs;
    private File tmpDir;
    private static Logger logger = Logger.getLogger((String)"dku.llm.guardrails.python.server");

    public PythonGuardrailServer(DSSAuthCtx authCtx, String projectKey, String code, String envName, String containerConfName, String pluginId, String pluginPythonLibFolderPath, JsonObject config, JsonObject pluginConfig, boolean loadPythonLibs) {
        super("dku.llm.guardrails.python", "python-guardrail-" + projectKey + "-" + SecretKeyGenerator.generateSmall());
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.code = code;
        this.envName = envName;
        this.containerConfName = containerConfName;
        this.pluginId = pluginId;
        this.pluginPythonLibFolderPath = pluginPythonLibFolderPath;
        this.config = config;
        this.pluginConfig = pluginConfig;
        this.loadPythonLibs = loadPythonLibs;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public SmartLogTail getKernelLogTail() {
        return this.kernel.getSmartLogTailBuilder().get();
    }

    @Override
    public CompletableFuture<PythonGuardrailServerAPI.Response> processAsync(PythonGuardrailServerAPI.Query input) {
        ProcessCommand preq = new ProcessCommand(input);
        return this.kernel.getLink().getAsyncLink().asyncStreamRequest((Object)preq, PythonGuardrailServerAPI.Response.class).last().doOnNext(scr -> logger.info((Object)("Got response from Guardrail: " + JSON.json((Object)scr)))).toFuture();
    }

    public void start(boolean devMode, File logBaseDir) throws Exception {
        Map<String, String> extraEnv = null;
        if (StringUtils.isNotBlank((String)this.pluginId)) {
            extraEnv = Map.of("DKU_PLUGIN_ID", this.pluginId);
        }
        HashMap libs = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)this.pluginPythonLibFolderPath)) {
            libs.put("plugin-libs", this.pluginPythonLibFolderPath);
        }
        this.kernel = SimplePythonKernelFactory.prepareKernel(this.authCtx, this.projectKey, GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, this.envName, "dataiku.llm.guardrails.server", true, this.loadPythonLibs, libs, this.containerConfName, this.kernelId, this.loadPythonLibs, extraEnv);
        this.setLogsWithRotation(logBaseDir, devMode);
        try {
            this.kernel.start();
            StartCommand sc = new StartCommand();
            sc.code = this.code;
            sc.projectKey = this.projectKey;
            sc.config = this.config;
            sc.pluginConfig = this.pluginConfig;
            this.kernel.getLink().getAsyncLink().request((Object)sc, JsonElement.class);
        }
        catch (Exception e) {
            DKUtils.SmartLogTailBuilder sltb = this.kernel.getSmartLogTailBuilder();
            logger.info((Object)("Start failed, with a SLTB: " + String.valueOf(sltb)));
            if (sltb != null) {
                logger.info((Object)("SLTB:\n" + JSON.json((Object)sltb.get())));
                throw new CustomPythonKernelException("Failed to start Guardrails server", e, sltb.get());
            }
            throw e;
        }
    }

    public static class ProcessCommand {
        public String type = "process";
        public PythonGuardrailServerAPI.Query input;

        public ProcessCommand(PythonGuardrailServerAPI.Query input) {
            this.input = input;
        }
    }

    public static class StartCommand {
        public String type = "start";
        public String projectKey;
        public String code;
        public boolean isPlugin;
        public JsonObject config;
        public JsonObject pluginConfig;
    }
}

