/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.governance.custom;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.llm.LLMRelatedPoolablePythonServerKernelPool;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.governance.custom.PythonGuardrailServer;
import com.dataiku.dip.llm.governance.custom.PythonGuardrailServerAPI;
import com.dataiku.dip.llm.governance.custom.PythonGuardrailServerKernelDesc;
import com.dataiku.dip.llm.kernel.KernelPool;
import com.dataiku.dip.llm.kernel.KernelPoolThreadFactory;
import com.dataiku.dip.llm.kernel.KernelScalingStrategyBuilder;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.DKUCompletableFuture;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PythonGuardrailServerPool
extends LLMRelatedPoolablePythonServerKernelPool<PythonGuardrailServer, PythonGuardrailServerKernelDesc, PythonGuardrailServerKernelDesc> {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.guardrails.python.pool");

    public PythonGuardrailServerAPI getServerAPI(DSSAuthCtx authCtx, String contextProjectKey, GuardrailsPipelineSettings.GuardrailsPipelineElement elt, String code, String pluginId, String libFolder, boolean loadPythonLibs, JsonObject config, JsonObject pluginConfig, String envName, String containerConfName, String clusterId) {
        final PythonGuardrailServerKernelDesc kernelDesc = new PythonGuardrailServerKernelDesc();
        kernelDesc.authCtx = authCtx;
        kernelDesc.projectKey = contextProjectKey;
        kernelDesc.code = code;
        kernelDesc.pluginId = pluginId;
        kernelDesc.libFolder = libFolder;
        kernelDesc.loadPythonLibs = loadPythonLibs;
        kernelDesc.config = config;
        kernelDesc.pluginConfig = pluginConfig;
        kernelDesc.envName = envName;
        kernelDesc.containerConfName = containerConfName;
        kernelDesc.clusterId = clusterId;
        kernelDesc.poolKey = authCtx.getIdentifier() + "-" + contextProjectKey + "-" + DigestUtils.sha1Hex((String)StringUtils.join((Object[])new String[]{JSON.json((Object)elt), code, pluginId, libFolder, "" + loadPythonLibs, JSON.json((Object)config), JSON.json((Object)pluginConfig), envName, containerConfName, clusterId}, (String)"__DKU__"));
        return new PythonGuardrailServerAPI(){

            @Override
            public CompletableFuture<PythonGuardrailServerAPI.Response> processAsync(PythonGuardrailServerAPI.Query input) throws Exception {
                return PythonGuardrailServerPool.this.manager.handle(kernel -> kernel.processAsync(input), kernelDesc, kernelDesc.poolKey, input);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public PythonGuardrailServerPool() {
        super("python-guardrails");
        this.setManager(new KernelPool(new LLMRelatedPoolablePythonServerKernelPool.LLMRelatedPoolablePythonServerKernelController("dku.llm.guardrails.python"){

            @Override
            public PythonGuardrailServer createKernel(PythonGuardrailServerKernelDesc kernelDesc) {
                return new PythonGuardrailServer(kernelDesc.authCtx, kernelDesc.projectKey, kernelDesc.code, kernelDesc.envName, kernelDesc.containerConfName, kernelDesc.pluginId, kernelDesc.libFolder, kernelDesc.config, kernelDesc.pluginConfig, kernelDesc.loadPythonLibs);
            }

            @Override
            public CompletableFuture<Void> startKernel(PythonGuardrailServer kernel, PythonGuardrailServerKernelDesc kernelDesc) {
                File logBaseDir = DKUApp.getFile((String[])new String[]{"python-guardrails", kernelDesc.projectKey, "wut", "logs"});
                return DKUCompletableFuture.runAsync(() -> {
                    this.setKernelContext(kernelDesc.cruContext, kernelDesc.jobContext, logger);
                    kernel.start(false, logBaseDir);
                }, (Executor)PythonGuardrailServerPool.this.executorService);
            }

            @Override
            public int getHardMaxParallelRequests(PythonGuardrailServerKernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".hardMaxRequestsPerKernel", Integer.valueOf(16));
            }

            @Override
            public int getSoftMaxParallelRequests(PythonGuardrailServerKernelDesc kernelDesc) {
                return ApplicationConfigurator.getParams().getIntParam(this.propertiesPrefix + ".softMaxRequestsPerKernel", Integer.valueOf(16));
            }
        }, new KernelScalingStrategyBuilder(), new KernelPoolThreadFactory("python-guardrails"), logger));
    }
}

