/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.kernel;

import com.dataiku.dip.ApplicationConfigurator;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class KernelPoolThreadFactory {
    private final String kernelType;

    public KernelPoolThreadFactory(String kernelType) {
        this.kernelType = kernelType;
    }

    public ScheduledExecutorService buildMaintenanceThreadPool() {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("kernel-pool-" + this.kernelType + "-maintainer").build());
    }

    public ExecutorService buildDispatcherThreadPool() {
        return Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("kernel-pool-" + this.kernelType + "-dispatcher").build());
    }

    public ExecutorService buildRequestCompletionHandlerThreadPool() {
        return Executors.newFixedThreadPool(ApplicationConfigurator.getParams().getIntParam("dku.llm." + this.kernelType + ".completionHandlerThreads", Integer.valueOf(2)), new ThreadFactoryBuilder().setNameFormat("kernel-pool-" + this.kernelType + "-completion-handler-%d").build());
    }
}

