/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.langchain;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.llm.io.PythonRequestUtils;
import com.dataiku.dip.llm.io.commands.ProcessSinglePromptCommand;
import com.dataiku.dip.llm.io.commands.StartResponse;
import com.dataiku.dip.llm.langchain.PythonLLMServerAPI;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.j2py.annotations.PyModel;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PythonLLMServer
implements PythonLLMServerAPI {
    private final DSSAuthCtx authCtx;
    private final String projectKey;
    private final String savedModelId;
    private final String savedModelVersionId;
    private final String pyClazz;
    private final String code;
    private final String envName;
    private final String containerConfName;
    private final File logBaseDir;
    private final String pluginId;
    private final String pluginPythonLibFolderPath;
    private final JsonObject config;
    private final JsonObject pluginConfig;
    private final boolean devMode;
    private final boolean loadPythonLibs;
    private final String kernelId;
    private SimplePythonKernel kernel;
    private static final Logger logger = Logger.getLogger((String)"dku.llm.python.server");

    public PythonLLMServer(DSSAuthCtx authCtx, String projectKey, String savedModelId, String savedModelVersionId, String pyClazz, String code, String envName, String containerConfName, String pluginId, String pluginPythonLibFolderPath, File logBaseDir, JsonObject config, JsonObject pluginConfig, boolean devMode, boolean loadPythonLibs) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.savedModelId = savedModelId;
        this.savedModelVersionId = savedModelVersionId;
        this.pyClazz = pyClazz;
        this.code = code;
        this.envName = envName;
        this.logBaseDir = logBaseDir;
        this.devMode = devMode;
        this.containerConfName = containerConfName;
        this.pluginId = pluginId;
        this.pluginPythonLibFolderPath = pluginPythonLibFolderPath;
        this.config = config;
        this.pluginConfig = pluginConfig;
        this.kernelId = "python-llm-agent-" + projectKey + "-" + SecretKeyGenerator.generateSmall();
        this.loadPythonLibs = loadPythonLibs;
        assert (StringUtils.isBlank((String)code) != StringUtils.isBlank((String)pyClazz));
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void close() {
        logger.info((Object)("Closing PythonLLMServer, kernel=" + String.valueOf(this.kernel)));
        if (this.kernel != null) {
            try {
                this.kernel.close();
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to kill kernel", e);
            }
        }
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public boolean isAlive() {
        return this.kernel != null && this.kernel.isAlive();
    }

    public SmartLogTail getKernelLogTail() {
        return this.kernel.getSmartLogTailBuilder().get();
    }

    @Override
    public CompletableFuture<LLMClient.SimpleCompletionResponse> processAsync(LLMClient.SingleCompletionQuery query, LLMClient.CompletionSettings settings) {
        ProcessSinglePromptCommand command = new ProcessSinglePromptCommand(query, settings, false);
        return this.kernel.getAsyncLink().asyncStreamRequest((Object)command, LLMClient.SimpleCompletionResponse.class).last().toFuture();
    }

    @Override
    public CompletableFuture<Integer> streamProcessAsync(LLMClient.SingleCompletionQuery query, LLMClient.CompletionSettings settings, LLMClient.StreamedCompletionResponseConsumer consumer) {
        return PythonRequestUtils.asyncStreamRequest(this.kernel.getAsyncLink(), query, settings, consumer);
    }

    public void start() throws Exception {
        Map<String, String> extraEnv = null;
        if (StringUtils.isNotBlank((String)this.pluginId)) {
            extraEnv = Map.of("DKU_PLUGIN_ID", this.pluginId);
        }
        HashMap libs = Maps.newHashMap();
        if (StringUtils.isNotBlank((String)this.pluginPythonLibFolderPath)) {
            libs.put("plugin-libs", this.pluginPythonLibFolderPath);
        }
        this.kernel = SimplePythonKernelFactory.prepareKernel(this.authCtx, this.projectKey, GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, this.envName, "dataiku.llm.python.server", true, this.loadPythonLibs, libs, this.containerConfName, this.kernelId, this.loadPythonLibs, extraEnv);
        int maxRotated = DKUApp.getParams().getIntParam("dku.llm.python.logs.maxRotatedFiles", Integer.valueOf(2));
        long maxSize = DKUApp.getParams().getLongParam("dku.llm.python.logs.maxFileSizeKB", 1024L) * 1024L;
        int maxDevTailLines = DKUApp.getParams().getIntParam("dku.llm.python.logs.maxDevTailLines", Integer.valueOf(1000));
        int maxDevKeptFiles = DKUApp.getParams().getIntParam("dku.llm.python.logs.maxDevKeptFiles", Integer.valueOf(10));
        File logDir = null;
        if (this.devMode) {
            DKUFileUtils.keepLastNItemsInFolder((File)new File(this.logBaseDir, "dev-runs"), (int)maxDevKeptFiles);
            logDir = DKUFileUtils.getWithin((File)this.logBaseDir, (String[])new String[]{"dev-runs", DKUDateUtils.isoFormatFileFriendlyLocalNow()});
            this.kernel.getSmartLogTailBuilder().setMaxLines(maxDevTailLines);
        } else {
            logDir = DKUFileUtils.getWithin((File)this.logBaseDir, (String[])new String[]{"runs", this.kernelId});
        }
        DKUFileUtils.mkdirs((File)logDir);
        DKUtils.RotatingLoggingSubscription rls = new DKUtils.RotatingLoggingSubscription(logDir, "llm.log", maxRotated, maxSize);
        this.kernel.appendKernelLogsToSubscription((DKUtils.LineSubscription)rls);
        try {
            this.kernel.start();
            this.kernel.getTicket().localFolderAwareWorkload = new APITicketService.LocalFolderAwareWorkload(APITicketService.LocalFolderAwareWorkloadType.AGENT, this.projectKey, this.savedModelId + "-" + this.savedModelVersionId);
            StartAgentServerCommand startCommand = new StartAgentServerCommand();
            startCommand.code = this.code;
            startCommand.pyClazz = this.pyClazz;
            startCommand.projectKey = this.projectKey;
            startCommand.config = this.config;
            startCommand.pluginConfig = this.pluginConfig;
            startCommand.isPlugin = this.pluginConfig != null;
            this.kernel.getLink().getAsyncLink().request((Object)startCommand, StartResponse.class);
        }
        catch (Exception e) {
            DKUtils.SmartLogTailBuilder sltb = this.kernel.getSmartLogTailBuilder();
            logger.info((Object)("Start failed, with a SLTB: " + String.valueOf(sltb)));
            if (sltb != null) {
                logger.info((Object)("SLTB:\n" + JSON.json((Object)sltb.get())));
                throw new CustomPythonKernelException("Failed to start LLM server", e, sltb.get());
            }
            throw e;
        }
    }

    @PyModel
    private static class StartAgentServerCommand {
        public final String type = "start-agent-server";
        public String projectKey;
        public String code;
        public String pyClazz;
        public boolean isPlugin;
        public JsonObject config;
        public JsonObject pluginConfig;

        private StartAgentServerCommand() {
        }
    }
}

