/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online;

import com.dataiku.common.stereotype.RoutinelyUsedInExtensionCode;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.governance.GuardrailsPipelineRunner;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.online.ISavedModelDeployer;
import com.dataiku.dip.llm.online.RemoteFineTuningClient;
import com.dataiku.dip.recipes.nlp.common.LLMCompletionSettings;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUEhcacheSerializer;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.GsonNullableJsonElementTypeAdapterFactory;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.j2py.annotations.PyModel;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.JsonAdapter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public interface LLMClient
extends AutoCloseable {
    public static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.online.llmclient");

    public boolean supportNativeBatch();

    public boolean requiresCostLimiting();

    public String getProviderId();

    public AbstractLLMConnection getConnection();

    default public void throwIfBadImageAuditFolder() {
        AbstractLLMConnection connection = this.getConnection();
        if (connection != null) {
            connection.throwIfBadImageAuditFolder();
        }
    }

    public int getMaxParallelism();

    default public int getBatchSize(AbstractLLMConnection.QueryType queryType, LLMStructuredRef llmRef) {
        logger.info((Object)"No batching supported");
        return 1;
    }

    public List<SimpleCompletionResponse> completeBatch(List<SingleCompletionQuery> var1, CompletionSettings var2) throws Exception;

    public List<SimpleEmbeddingResponse> embedBatch(List<EmbeddingQuery> var1, EmbeddingSettings var2) throws Exception;

    default public boolean supportsStream() {
        return false;
    }

    default public void streamComplete(SingleCompletionQuery query, CompletionSettings settings, StreamedCompletionResponseConsumer consumer) throws Exception {
        throw new UnsupportedOperationException("Streaming not supported on LLM: " + String.valueOf(this.getClass()));
    }

    default public ImageGenerationResponse generateImages(ImageGenerationQuery query) throws Exception {
        throw new UnsupportedOperationException("Image generation not supported on LLM: " + String.valueOf(this.getClass()));
    }

    public ComputeResourceUsage getTotalCRU(ComputeResourceUsage.LLMUsageType var1, LLMStructuredRef var2);

    public EnrichedLLMStructuredRef getEnrichedRef() throws Exception;

    default public RemoteFineTuningClient newFineTuningClient() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Fine-tuning is not supported on this LLM: " + String.valueOf(this.getClass()));
    }

    default public ISavedModelDeployer newSavedModelDeployer(AuthCtx authCtx) throws UnsupportedOperationException, AzureMLUtils.AzureAuthenticationException, IOException, DKUSecurityException {
        throw new UnsupportedOperationException("Model deployment is not supported on this LLM: " + String.valueOf(this.getClass()));
    }

    public List<ChatMessage> getFormattedPrompt(List<ChatMessage> var1);

    default public void setDevMode(boolean devMode) {
        throw new UnsupportedOperationException("Dev mode is not supported on this LLM: " + String.valueOf(this.getClass()));
    }

    default public SmartLogTail getKernelLog() throws Exception {
        return null;
    }

    @RoutinelyUsedInExtensionCode
    public static class RefusalException
    extends LLMException {
        public RefusalException(String message) {
            super(message);
        }
    }

    @RoutinelyUsedInExtensionCode
    public static class LLMException
    extends RuntimeException {
        public Integer promptTokens;
        public Integer completionTokens;
        public Integer totalTokens;
        public Double estimatedCost;

        public LLMException(String message) {
            super(message);
        }
    }

    public static class ImageGenerationResponseOrError
    extends ImageGenerationResponse {
        public boolean ok;
        public String errorMessage;
        public transient JsonArray guardrailsAuditData;

        private ImageGenerationResponseOrError() {
        }

        public static ImageGenerationResponseOrError fromSuccess(ImageGenerationResponse origResp) {
            ImageGenerationResponseOrError resp = new ImageGenerationResponseOrError();
            resp.ok = true;
            resp.images = origResp.images;
            resp.estimatedCost = origResp.estimatedCost;
            resp.additionalInformation = origResp.additionalInformation;
            return resp;
        }

        public static ImageGenerationResponseOrError fromError(Throwable e) {
            ImageGenerationResponseOrError resp = new ImageGenerationResponseOrError();
            resp.ok = false;
            resp.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return resp;
        }
    }

    @PyModel
    public static class ImageGenerationResponse {
        public List<ImageGenerationImage> images = new ArrayList<ImageGenerationImage>();
        public double estimatedCost;
        public JsonObject additionalInformation;
        public LLMMeshTraceSpan trace;
        public transient ComputeResourceUsage cru = new ComputeResourceUsage();

        public ImageGenerationResponse audit(List<String> savedOutputImagePaths) {
            ImageGenerationResponse auditedResponse = (ImageGenerationResponse)JSON.deepCopy((Object)this);
            if (savedOutputImagePaths == null || savedOutputImagePaths.isEmpty()) {
                auditedResponse.images.forEach(image -> {
                    image.data = null;
                });
                return auditedResponse;
            }
            assert (savedOutputImagePaths.size() == auditedResponse.images.size()) : "There should be as many saved images as generated images";
            for (int i = 0; i < savedOutputImagePaths.size(); ++i) {
                ImageGenerationImage generation = auditedResponse.images.get(i);
                String savedImageOutput = savedOutputImagePaths.get(i);
                generation.data = null;
                generation.savedImagePath = savedImageOutput;
            }
            return auditedResponse;
        }
    }

    public static class ImageGenerationImage {
        public String data;
        public String savedImagePath;

        public ImageGenerationImage() {
        }

        public ImageGenerationImage(String data) {
            this.data = data;
        }
    }

    public static class ImageGenerationQuery {
        public String llmId;
        public List<ImageGenerationPrompt> prompts = new ArrayList<ImageGenerationPrompt>();
        public List<ImageGenerationPrompt> negativePrompts = new ArrayList<ImageGenerationPrompt>();
        public Integer nbImagesToGenerate;
        public Integer height;
        public Integer width;
        public String quality;
        public Integer seed;
        public String style;
        public Double fidelity;
        public ImageGenerationEditionMode originalImageEditionMode = ImageGenerationEditionMode.MASK_FREE;
        public String originalImage;
        public Double originalImageWeight;
        public String originalImagePath;
        public ImageGenerationMaskMode maskMode;
        public String maskImage;
        public String maskPrompt;
        public GuardrailsPipelineSettings guardrails;

        public String getConcatenatedPrompts() {
            if (this.prompts == null || this.prompts.isEmpty()) {
                return null;
            }
            return this.prompts.stream().map(p -> p.prompt).collect(Collectors.joining(" "));
        }

        public String getConcatenatedNegativePrompts() {
            if (this.negativePrompts == null || this.negativePrompts.isEmpty()) {
                return null;
            }
            return this.negativePrompts.stream().map(p -> p.prompt).collect(Collectors.joining(" "));
        }

        public void throwIfNullOriginalImageEditionMode() {
            if (this.originalImageEditionMode == null) {
                throw new IllegalArgumentException("Invalid image edition mode.");
            }
        }

        public ImageGenerationQuery audit(@Nullable String savedOriginalImagePath) {
            ImageGenerationQuery auditedQuery = (ImageGenerationQuery)JSON.deepCopy((Object)this);
            if (auditedQuery.originalImage != null) {
                auditedQuery.originalImage = "provided";
            }
            auditedQuery.originalImagePath = savedOriginalImagePath;
            return auditedQuery;
        }
    }

    public static enum ImageGenerationMaskMode {
        MASK_IMAGE_ALPHA,
        MASK_IMAGE_BLACK,
        ORIGINAL_IMAGE_ALPHA,
        TEXT;

    }

    public static enum ImageGenerationEditionMode {
        MASK_FREE,
        INPAINTING,
        OUTPAINTING,
        VARY,
        CONTROLNET_SKETCH,
        CONTROLNET_STRUCTURE;

    }

    @PyModel
    public static class ImageGenerationPrompt {
        public String prompt;
        public Double weight;
    }

    public static class StreamedCompletionResponseConsumerProxy
    implements StreamedCompletionResponseConsumer {
        private final StreamedCompletionResponseConsumer consumer;
        private final ExceptionUtils.ThrowingConsumer<StreamedCompletionResponseFooter, Exception> footerHook;

        public StreamedCompletionResponseConsumerProxy(StreamedCompletionResponseConsumer consumer, ExceptionUtils.ThrowingConsumer<StreamedCompletionResponseFooter, Exception> footerHook) {
            this.consumer = consumer;
            this.footerHook = footerHook;
        }

        @Override
        public void onStreamStarted() throws Exception {
            this.consumer.onStreamStarted();
        }

        @Override
        public void onStreamChunk(StreamedCompletionResponseChunk chunk) throws Exception {
            this.consumer.onStreamChunk(chunk);
        }

        @Override
        public void onStreamComplete(StreamedCompletionResponseFooter footer) throws Exception {
            this.footerHook.accept((Object)footer);
            this.consumer.onStreamComplete(footer);
        }
    }

    public static abstract class StreamedCompletionResponseFilter
    implements StreamedCompletionResponseConsumer {
        protected final StreamedCompletionResponseConsumer underlying;

        protected StreamedCompletionResponseFilter(StreamedCompletionResponseConsumer underlying) {
            this.underlying = underlying;
        }

        @Override
        public void onStreamStarted() throws Exception {
            this.underlying.onStreamStarted();
        }

        @Override
        public void onStreamComplete(StreamedCompletionResponseFooter footer) throws Exception {
            this.underlying.onStreamComplete(footer);
        }
    }

    public static interface StreamedCompletionResponseConsumer {
        public void onStreamStarted() throws Exception;

        public void onStreamChunk(StreamedCompletionResponseChunk var1) throws Exception;

        public void onStreamComplete(StreamedCompletionResponseFooter var1) throws Exception;
    }

    public static class StreamedCompletionResponseFooter {
        public final String type = "footer";
        public FinishReason finishReason = FinishReason.UNKNOWN;
        public Integer promptTokens;
        public Integer completionTokens;
        public Integer totalTokens;
        public Boolean tokenCountsAreEstimated;
        public Double estimatedCost;
        public JsonObject additionalInformation;
        public LLMMeshTraceSpan trace;
        public transient ComputeResourceUsage cru = new ComputeResourceUsage();
    }

    public static class StreamedCompletionResponseChunk {
        public String type = "content";
        @Nullable
        public String text;
        @Nullable
        public List<DetailedLogProb> logProbs;
        @Nullable
        public List<AbstractToolCall> toolCalls;
        @Nullable
        public String eventKind;
        @Nullable
        public JsonObject eventData = new JsonObject();

        public boolean isEmpty() {
            return !(this.text != null && !this.text.isEmpty() || this.toolCalls != null && !this.toolCalls.isEmpty());
        }

        public static StreamedCompletionResponseChunk empty() {
            return new StreamedCompletionResponseChunk();
        }

        public static StreamedCompletionResponseChunk event(String eventKind, JsonObject eventData) {
            StreamedCompletionResponseChunk ret = new StreamedCompletionResponseChunk();
            ret.type = "event";
            ret.eventKind = eventKind;
            ret.eventData = eventData;
            return ret;
        }

        public static StreamedCompletionResponseChunk textContent(String content) {
            StreamedCompletionResponseChunk ret = new StreamedCompletionResponseChunk();
            ret.type = "content";
            ret.text = content;
            return ret;
        }
    }

    public static class SimpleEmbeddingResponseOrError
    extends SimpleEmbeddingResponse {
        public boolean ok;
        public String errorMessage;
        public transient JsonArray guardrailsAuditData;

        private SimpleEmbeddingResponseOrError() {
        }

        public static SimpleEmbeddingResponseOrError fromSuccess(SimpleEmbeddingResponse origResp) {
            SimpleEmbeddingResponseOrError resp = new SimpleEmbeddingResponseOrError();
            resp.ok = true;
            resp.embedding = origResp.embedding;
            resp.promptTokens = origResp.promptTokens;
            resp.tokenCountsAreEstimated = origResp.tokenCountsAreEstimated;
            resp.estimatedCost = origResp.estimatedCost;
            resp.additionalInformation = origResp.additionalInformation;
            resp.trace = origResp.trace;
            return resp;
        }

        public static SimpleEmbeddingResponseOrError fromError(Throwable e) {
            SimpleEmbeddingResponseOrError resp = new SimpleEmbeddingResponseOrError();
            resp.ok = false;
            resp.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)e);
            return resp;
        }

        @Override
        public void serializeToCache(DataOutputStream dos) throws IOException {
            super.serializeToCache(dos);
            dos.writeBoolean(this.ok);
            dos.writeBoolean(this.errorMessage != null);
            if (this.errorMessage != null) {
                dos.writeUTF(this.errorMessage);
            }
        }

        @Override
        public void deserializeFromCache(DataInputStream dis) throws IOException {
            super.deserializeFromCache(dis);
            this.ok = dis.readBoolean();
            if (dis.readBoolean()) {
                this.errorMessage = dis.readUTF();
            }
        }
    }

    @PyModel
    public static class SimpleEmbeddingResponse
    implements DKUEhcacheSerializer.WithCustomCacheSerializer {
        public double[] embedding;
        public Integer promptTokens;
        public Boolean tokenCountsAreEstimated;
        public boolean fromCache;
        public Double estimatedCost;
        public JsonObject additionalInformation;
        public LLMMeshTraceSpan trace;
        public transient ComputeResourceUsage cru = new ComputeResourceUsage();

        @Override
        public void serializeToCache(DataOutputStream dos) throws IOException {
            dos.writeInt(this.embedding.length);
            for (double d : this.embedding) {
                dos.writeFloat((float)d);
            }
            if (this.promptTokens != null) {
                dos.writeInt(this.promptTokens);
            } else {
                dos.writeInt(-1);
            }
            if (this.tokenCountsAreEstimated != null) {
                dos.writeBoolean(this.tokenCountsAreEstimated);
            } else {
                dos.writeBoolean(false);
            }
            if (this.estimatedCost != null) {
                dos.writeDouble(this.estimatedCost);
            } else {
                dos.writeDouble(Double.NEGATIVE_INFINITY);
            }
            dos.writeBoolean(this.additionalInformation != null);
            if (this.additionalInformation != null) {
                dos.writeUTF(JSON.json((Object)this.additionalInformation));
            }
        }

        @Override
        public void deserializeFromCache(DataInputStream dis) throws IOException {
            int embeddingLength = dis.readInt();
            this.embedding = new double[embeddingLength];
            for (int i = 0; i < embeddingLength; ++i) {
                this.embedding[i] = dis.readFloat();
            }
            this.promptTokens = dis.readInt();
            if (this.promptTokens < 0) {
                this.promptTokens = null;
            }
            this.tokenCountsAreEstimated = dis.readBoolean();
            this.estimatedCost = dis.readDouble();
            if (Double.isInfinite(this.estimatedCost)) {
                this.estimatedCost = null;
            }
            if (dis.readBoolean()) {
                this.additionalInformation = (JsonObject)JSON.parse((String)dis.readUTF(), JsonObject.class);
            }
        }
    }

    @PyModel
    public static enum LLMErrorType {
        REFUSAL,
        ERROR;

    }

    public static class SimpleCompletionResponseOrError
    extends SimpleCompletionResponse {
        public boolean ok;
        public LLMResponseErrorSource errorSource;
        public String errorCode;
        public LLMErrorType errorType;
        public String errorMessage;
        public transient JsonArray guardrailsAuditData;

        private SimpleCompletionResponseOrError() {
        }

        public static SimpleCompletionResponseOrError blank() {
            return new SimpleCompletionResponseOrError();
        }

        public static SimpleCompletionResponseOrError fromSuccess(SimpleCompletionResponse origResp) {
            SimpleCompletionResponseOrError resp = new SimpleCompletionResponseOrError();
            resp.ok = true;
            resp.text = origResp.text;
            resp.finishReason = origResp.finishReason;
            resp.logProbs = origResp.logProbs;
            resp.toolCalls = origResp.toolCalls;
            resp.sources = origResp.sources;
            resp.predictedClass = origResp.predictedClass;
            resp.predictedClassProbas = origResp.predictedClassProbas;
            resp.promptTokens = origResp.promptTokens;
            resp.completionTokens = origResp.completionTokens;
            if (origResp.promptTokens != null || origResp.completionTokens != null) {
                resp.totalTokens = (origResp.promptTokens != null ? origResp.promptTokens : 0) + (origResp.completionTokens != null ? origResp.completionTokens : 0);
            }
            resp.tokenCountsAreEstimated = origResp.tokenCountsAreEstimated;
            resp.estimatedCost = origResp.estimatedCost;
            resp.additionalInformation = origResp.additionalInformation;
            resp.reportedUsageMetadata = origResp.reportedUsageMetadata;
            resp.trace = origResp.trace;
            return resp;
        }

        public static SimpleCompletionResponseOrError fromError(Throwable t) {
            if (t instanceof GuardrailsPipelineRunner.LLMUsageEnforcerException) {
                SimpleCompletionResponseOrError ret = SimpleCompletionResponseOrError.fromError(t, ((GuardrailsPipelineRunner.LLMUsageEnforcerException)((Object)t)).errorSource);
                ret.errorCode = ((GuardrailsPipelineRunner.LLMUsageEnforcerException)((Object)t)).getCode().getCode();
                return ret;
            }
            return SimpleCompletionResponseOrError.fromError(t, null);
        }

        public static SimpleCompletionResponseOrError fromErrorWithTrace(Throwable t, LLMMeshTraceSpan trace) {
            SimpleCompletionResponseOrError ret = SimpleCompletionResponseOrError.fromError(t);
            ret.trace = trace;
            return ret;
        }

        public static SimpleCompletionResponseOrError fromError(Throwable t, LLMResponseErrorSource errorSource) {
            SimpleCompletionResponseOrError resp = new SimpleCompletionResponseOrError();
            resp.ok = false;
            resp.errorSource = errorSource;
            if (t instanceof RefusalException) {
                RefusalException refusal = (RefusalException)t;
                resp.promptTokens = refusal.promptTokens;
                resp.completionTokens = refusal.completionTokens;
                resp.totalTokens = refusal.totalTokens;
                resp.estimatedCost = refusal.estimatedCost;
                resp.errorType = LLMErrorType.REFUSAL;
                resp.errorMessage = refusal.getMessage();
            } else {
                resp.errorMessage = ExceptionUtils.getMessageWithCauses((Throwable)t);
                resp.errorType = LLMErrorType.ERROR;
            }
            return resp;
        }
    }

    public static class ImageRefExcerpt {
        String fullFolderId;
        String path;

        public ImageRefExcerpt() {
        }

        public ImageRefExcerpt(String fullFolderId, String path) {
            this.fullFolderId = fullFolderId;
            this.path = path;
        }
    }

    public static class ImagesRefExcerpt
    extends Excerpt {
        List<ImageRefExcerpt> images;

        public ImagesRefExcerpt() {
            this.type = Excerpt.Type.IMAGE_REF;
        }
    }

    public static class TextExcerpt
    extends Excerpt {
        String text;

        public TextExcerpt() {
            this.type = Excerpt.Type.TEXT;
        }
    }

    @PolyJSON(value={@Mapping(value=TextExcerpt.class, type="TEXT"), @Mapping(value=ImagesRefExcerpt.class, type="IMAGE_REF")}, enumClass=Type.class)
    public static abstract class Excerpt {
        Type type;

        public static enum Type {
            TEXT,
            IMAGE_REF;

        }
    }

    @PyModel
    public static class SourceItem {
        public String type;
        public JsonObject metadata;
        public String performedQuery;
        public SourceRecords records;
        public FileRef fileRef;
        public List<ImageRef> imageRefs;
        public String title;
        public String url;
        public String thumbnailInlineB64;
        public String thumbnailURL;
        public Integer thumbnailW;
        public Integer thumbnailH;
        public String textSnippet;
        public String markdownSnippet;
        public String htmlSnippet;
    }

    public static class DocumentPageRange {
        int start;
        int end;
    }

    public static class FileRef {
        String folderId;
        String path;
        DocumentPageRange pageRange;
    }

    public static class ImageRef {
        public String folderId;
        public String path;
    }

    public static class SourceRecords {
        public List<String> columns;
        public List<List<JsonElement>> data;
    }

    @PyModel
    @Deprecated(forRemoval=true)
    public static class Source {
        Excerpt excerpt;
        Map<String, String> metadata;
    }

    public static class DetailedLogProb
    extends SimpleLogProb {
        @Nullable
        public List<SimpleLogProb> topLogProbs;
    }

    public static class SimpleLogProb {
        public String token;
        public double logProb;
    }

    public static enum LLMResponseErrorSource {
        QUERY_FORBIDDEN_TERMS,
        QUERY_PII_DETECTION,
        QUERY_TOXICITY_DETECTION,
        QUERY_PROMPT_INJECTION_DETECTION,
        QUERY_CUSTOM_HOOK,
        LLM,
        GUARDRAIL,
        RESPONSE_FORBIDDEN_TERMS,
        RESPONSE_TOXICITY_DETECTION,
        RESPONSE_CUSTOM_HOOK;

    }

    @PyModel
    public static class SimpleCompletionResponse
    extends UsageMetadata {
        @Nullable
        public String text;
        public FinishReason finishReason = FinishReason.UNKNOWN;
        @Nullable
        public List<DetailedLogProb> logProbs;
        @Nullable
        public List<AbstractToolCall> toolCalls;
        @Nullable
        public List<Source> sources;
        public String predictedClass;
        public List<PredictedClassProba> predictedClassProbas = new ArrayList<PredictedClassProba>();
        public boolean fromCache;
        public JsonObject additionalInformation;
        public UsageMetadata reportedUsageMetadata;
        public LLMMeshTraceSpan trace;
        public transient ComputeResourceUsage cru = new ComputeResourceUsage();
    }

    @RoutinelyUsedInExtensionCode
    public static enum FinishReason {
        STOP,
        LENGTH,
        CONTENT_FILTER,
        TOOL_CALLS,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static class LLMMeshTraceEvent
    extends LLMMeshTraceObservation {
        public String timestamp;

        public static LLMMeshTraceEvent mark(String subtype) {
            LLMMeshTraceEvent ret = new LLMMeshTraceEvent();
            ret.type = "event";
            ret.name = subtype;
            ret.timestamp = DKUDateUtils.isoFormatUTCNow();
            return ret;
        }
    }

    public static class LLMMeshTraceSpan
    extends LLMMeshTraceObservation
    implements AutoCloseable {
        public String begin;
        public String end;
        private transient long _begin;
        public Long duration;
        public UsageMetadata usageMetadata;

        private LLMMeshTraceSpan() {
        }

        public static LLMMeshTraceSpan newNotStarted() {
            LLMMeshTraceSpan ret = new LLMMeshTraceSpan();
            ret.type = "span";
            return ret;
        }

        public static LLMMeshTraceSpan start(String name) {
            LLMMeshTraceSpan ret = LLMMeshTraceSpan.newNotStarted();
            ret.name = name;
            ret.start();
            return ret;
        }

        public void start() {
            this._begin = System.currentTimeMillis();
            this.begin = DKUDateUtils.isoFormatUTC((long)this._begin);
        }

        @Override
        public void close() {
            long _end = System.currentTimeMillis();
            this.duration = _end - this._begin;
            this.end = DKUDateUtils.isoFormatUTC((long)_end);
        }
    }

    @PolyJSON(value={@Mapping(value=LLMMeshTraceEvent.class, type="event"), @Mapping(value=LLMMeshTraceSpan.class, type="span")})
    public static abstract class LLMMeshTraceObservation {
        public String type;
        public String name;
        public List<LLMMeshTraceObservation> children = new ArrayList<LLMMeshTraceObservation>();
        public JsonObject attributes = new JsonObject();
        public JsonObject inputs;
        public JsonObject outputs;

        public LLMMeshTraceSpan withChildSpan(String subtype) {
            LLMMeshTraceSpan ret = LLMMeshTraceSpan.start(subtype);
            this.addObservation(ret);
            return ret;
        }

        public LLMMeshTraceEvent withChildEvent(String name) {
            LLMMeshTraceEvent ret = LLMMeshTraceEvent.mark(name);
            this.addObservation(ret);
            return ret;
        }

        public void addObservation(LLMMeshTraceObservation observation) {
            this.children.add(observation);
        }

        public void setInputs(JsonObject inputs) {
            this.inputs = inputs;
        }

        public void setInput(String key, Object value) {
            if (this.inputs == null) {
                this.inputs = new JsonObject();
            }
            if (value instanceof String) {
                this.inputs.addProperty(key, (String)value);
            } else if (value instanceof JsonObject) {
                this.inputs.add(key, (JsonElement)((JsonObject)value));
            } else if (value instanceof JsonArray) {
                this.inputs.add(key, (JsonElement)((JsonArray)value));
            } else if (value instanceof Collection) {
                this.inputs.add(key, (JsonElement)JSON.toJsonArray((Object)value));
            } else {
                this.inputs.add(key, (JsonElement)JSON.toJsonObject((Object)value));
            }
        }

        public void setCompletionLLMInput(SingleCompletionQuery query) {
            JsonArray msgs = new JsonArray();
            for (ChatMessage msg : query.messages) {
                JF.ObjectBuilder ob = JF.obj();
                if (msg.isTextOnly()) {
                    ob.with("role", msg.role).with("text", msg.getTextEvenIfNotTextOnly());
                } else {
                    ob.with("role", msg.role).with("content", "non-text-only-message");
                }
                if (msg.toolCalls != null && msg.toolCalls.size() > 0) {
                    ob.with("toolCalls", (JsonElement)JSON.toJsonArray(msg.toolCalls));
                }
                if (msg.toolOutputs != null && msg.toolOutputs.size() > 0) {
                    ob.with("toolOutputs", (JsonElement)JSON.toJsonArray(msg.toolOutputs));
                }
                msgs.add((JsonElement)ob.get());
            }
            this.setInput("messages", msgs);
        }

        public void setEmbeddingLLMInput(EmbeddingQuery query) {
            if (query.hasText()) {
                this.setInput("text", query.text);
            }
        }

        public void setLLMOutput(SimpleCompletionResponseOrError scror) {
            this.outputs = new JsonObject();
            if (StringUtils.isNotBlank((String)scror.text)) {
                this.outputs.addProperty("text", scror.text);
            }
            if (scror.toolCalls != null && scror.toolCalls.size() > 0) {
                this.outputs.add("toolCalls", (JsonElement)JSON.toJsonArray((Object)scror.toolCalls));
            }
        }
    }

    public static class UsageMetadata {
        public Integer promptTokens;
        public Integer completionTokens;
        public Integer totalTokens;
        public Boolean tokenCountsAreEstimated;
        public Double estimatedCost;

        public UsageMetadata() {
        }

        public UsageMetadata(SimpleCompletionResponse r) {
            this.promptTokens = r.promptTokens;
            this.completionTokens = r.completionTokens;
            this.totalTokens = r.totalTokens;
            this.tokenCountsAreEstimated = r.tokenCountsAreEstimated;
            this.estimatedCost = r.estimatedCost;
        }

        public UsageMetadata(StreamedCompletionResponseFooter f) {
            this.promptTokens = f.promptTokens;
            this.completionTokens = f.completionTokens;
            this.totalTokens = f.totalTokens;
            this.tokenCountsAreEstimated = f.tokenCountsAreEstimated;
            this.estimatedCost = f.estimatedCost;
        }

        public UsageMetadata(SimpleEmbeddingResponse f) {
            this.promptTokens = f.promptTokens;
            this.totalTokens = f.promptTokens;
            this.tokenCountsAreEstimated = f.tokenCountsAreEstimated;
            this.estimatedCost = f.estimatedCost;
        }
    }

    public static class PredictedClassProba {
        public String className;
        public double proba;
    }

    public static enum TextOverflowMode {
        TRUNCATE,
        FAIL;

    }

    public static enum EmbeddingType {
        TEXT,
        IMAGE;


        public AbstractLLMConnection.QueryType getQueryType() {
            switch (this) {
                case TEXT: {
                    return AbstractLLMConnection.QueryType.textEmbedding;
                }
                case IMAGE: {
                    return AbstractLLMConnection.QueryType.imageEmbedding;
                }
            }
            throw new RuntimeException("Unreachable");
        }
    }

    public static class EmbeddingSettings {
        public TextOverflowMode textOverflowMode = TextOverflowMode.TRUNCATE;
    }

    public static class EmbeddingQuery {
        public String text;
        public String inlineImage;

        public boolean hasImage() {
            return this.inlineImage != null;
        }

        public boolean hasText() {
            return this.text != null;
        }
    }

    @PyModel
    public static class ChatMessage {
        public static final String PARTS_JOINING_SEPARATOR = "\n";
        public String role;
        @Nullable
        private String content;
        @Nullable
        public Boolean partOfExample;
        @Nullable
        public List<ChatMessagePart> parts;
        @Nullable
        public List<ToolOutput> toolOutputs;
        @Nullable
        public List<AbstractToolCall> toolCalls;

        public ChatMessage() {
        }

        public ChatMessage(String role, String content) {
            this.role = role;
            this.content = content;
        }

        public ChatMessage(ChatMessage other) {
            this.role = other.role;
            this.content = other.content;
            this.partOfExample = other.partOfExample;
            if (other.parts != null) {
                this.parts = other.parts.stream().map(ChatMessagePart::new).collect(Collectors.toList());
            }
            if (other.toolCalls != null) {
                this.toolCalls = other.toolCalls.stream().map(AbstractToolCall::copy).collect(Collectors.toList());
            }
            if (other.toolOutputs != null) {
                this.toolOutputs = other.toolOutputs.stream().map(ToolOutput::new).collect(Collectors.toList());
            }
        }

        public ChatMessage(String role, List<ChatMessagePart> parts) {
            this.role = role;
            this.parts = parts.stream().map(ChatMessagePart::new).collect(Collectors.toList());
        }

        public ChatMessage withIsPartOfExample() {
            this.partOfExample = true;
            return this;
        }

        public boolean isTextOnly() {
            return this.parts == null || this.parts.stream().allMatch(p -> p.type == ChatMessagePartType.TEXT);
        }

        public String getText() {
            if (!this.isTextOnly()) {
                throw new IllegalArgumentException("This message is not text-only");
            }
            if (this.parts == null) {
                return this.content;
            }
            return this.parts.stream().map(p -> p.text).collect(Collectors.joining(PARTS_JOINING_SEPARATOR));
        }

        public String getTextEvenIfNotTextOnly() {
            if (this.parts == null) {
                return this.content;
            }
            return this.parts.stream().map(p -> p.text == null ? "" : p.text).collect(Collectors.joining(PARTS_JOINING_SEPARATOR));
        }

        public void setTextOnly(String text) {
            this.parts = null;
            this.content = text;
        }
    }

    public static class FunctionToolCallInfo {
        @Nullable
        public String name;
        public String arguments;
    }

    @PyModel
    public static class FunctionToolCall
    extends AbstractToolCall {
        public FunctionToolCallInfo function;

        @Override
        public AbstractToolCall copy() {
            FunctionToolCall copy = new FunctionToolCall();
            copy.id = this.id;
            copy.index = this.index;
            copy.function = new FunctionToolCallInfo();
            copy.function.name = this.function.name;
            copy.function.arguments = this.function.arguments;
            return copy;
        }
    }

    @PolyJSON(value={@Mapping(value=FunctionToolCall.class, type="function")})
    public static abstract class AbstractToolCall {
        @Nullable
        public String id;
        @Nullable
        public Integer index;

        public abstract AbstractToolCall copy();
    }

    public static class ToolOutput {
        public String callId;
        public String output;

        public ToolOutput() {
        }

        public ToolOutput(ToolOutput other) {
            this.callId = other.callId;
            this.output = other.output;
        }
    }

    public static class ChatMessagePart {
        public ChatMessagePartType type = ChatMessagePartType.TEXT;
        @Nullable
        public String text;
        @Nullable
        public String imageMimeType;
        @Nullable
        public String inlineImage;
        @Nullable
        public String imageUrl;

        public ChatMessagePart() {
        }

        public ChatMessagePart(ChatMessagePart other) {
            this.type = other.type;
            this.text = other.text;
            this.imageMimeType = other.imageMimeType;
            this.inlineImage = other.inlineImage;
            this.imageUrl = other.imageUrl;
        }

        public ChatMessagePart withText(String text) {
            this.type = ChatMessagePartType.TEXT;
            this.text = text;
            return this;
        }

        public ChatMessagePart withInlineImageFromExtension(String inlineImage, @Nullable String extension) {
            MimeTypeUtils.MimeType mt = MimeTypeUtils.fromExtension((String)extension);
            String mimeType = Optional.ofNullable(mt).map(obj -> obj.mimeType).orElse(null);
            return this.withInlineImage(inlineImage, mimeType);
        }

        public ChatMessagePart withInlineImage(String inlineImage, @Nullable String mimeType) {
            this.type = ChatMessagePartType.IMAGE_INLINE;
            this.inlineImage = inlineImage;
            this.imageMimeType = mimeType;
            return this;
        }

        public boolean containsImageData() {
            switch (this.type) {
                case IMAGE_INLINE: {
                    return true;
                }
                case IMAGE_URI: {
                    return StringUtils.startsWith((String)this.imageUrl, (String)"data:");
                }
            }
            return false;
        }

        public String getImageData() {
            switch (this.type) {
                case IMAGE_INLINE: {
                    return this.inlineImage;
                }
                case IMAGE_URI: {
                    assert (StringUtils.startsWith((String)this.imageUrl, (String)"data:"));
                    return this.imageUrl.substring("data:".length());
                }
            }
            throw new UnsupportedOperationException("This chat message part contains no image.");
        }
    }

    public static enum ChatMessagePartType {
        TEXT,
        IMAGE_INLINE,
        IMAGE_URI,
        IMAGE_REF;

    }

    public static class FunctionToolDesc {
        public String name;
        @Nullable
        public String description;
        @Nullable
        public Boolean strict;
        @Nullable
        public Boolean compatible;
        @Nullable
        @JsonAdapter(value=GsonNullableJsonElementTypeAdapterFactory.class)
        private JsonObject parameters;

        public JsonObject getParameters() {
            if (this.parameters == null) {
                JsonObject obj = new JsonObject();
                obj.addProperty("type", "object");
                obj.add("properties", (JsonElement)new JsonObject());
                return obj;
            }
            return this.parameters.getAsJsonObject();
        }

        public void setParameters(@Nullable JsonObject parameters) {
            this.parameters = parameters;
        }
    }

    public static class FunctionTool
    extends AbstractTool {
        public FunctionToolDesc function;
    }

    @PolyJSON(value={@Mapping(value=FunctionTool.class, type="function")})
    public static abstract class AbstractTool {
    }

    public static class NamedToolChoice
    extends ToolChoice {
        public String name;
    }

    public static class RequiredToolChoice
    extends ToolChoice {
    }

    public static class NoneToolChoice
    extends ToolChoice {
    }

    public static class AutoToolChoice
    extends ToolChoice {
    }

    @PolyJSON(value={@Mapping(value=AutoToolChoice.class, type="auto"), @Mapping(value=NoneToolChoice.class, type="none"), @Mapping(value=RequiredToolChoice.class, type="required"), @Mapping(value=NamedToolChoice.class, type="tool_name")})
    public static abstract class ToolChoice {
    }

    public static class ResponseFormatJson
    extends ResponseFormat {
        @JsonAdapter(value=GsonNullableJsonElementTypeAdapterFactory.class)
        @Nullable
        public JsonObject schema;
        @Nullable
        public Boolean strict;
        @Nullable
        public Boolean compatible;

        @Override
        public LLMCompletionSettings.ResponseFormat toLegacyResponseFormat() {
            LLMCompletionSettings.ResponseFormatJson responseFormat = new LLMCompletionSettings.ResponseFormatJson();
            responseFormat.schema = this.schema;
            responseFormat.strict = this.strict;
            responseFormat.compatible = this.compatible;
            return responseFormat;
        }
    }

    public static class ResponseFormatText
    extends ResponseFormat {
        @Override
        public LLMCompletionSettings.ResponseFormatText toLegacyResponseFormat() {
            return new LLMCompletionSettings.ResponseFormatText();
        }
    }

    @PolyJSON(value={@Mapping(type="text", value=ResponseFormatText.class), @Mapping(type="json", value=ResponseFormatJson.class)})
    public static abstract class ResponseFormat {
        public abstract LLMCompletionSettings.ResponseFormat toLegacyResponseFormat();
    }

    public static class CompletionSettings {
        @Nullable
        public Double temperature;
        @Nullable
        public Integer topK;
        @Nullable
        public Double topP;
        @Nullable
        public Integer maxOutputTokens;
        @Nullable
        public List<String> stopSequences = new ArrayList<String>();
        @Nullable
        public Double frequencyPenalty;
        @Nullable
        public Double presencePenalty;
        @Nullable
        public Map<Integer, Double> logitBias;
        @Nullable
        public Boolean logProbs;
        @Nullable
        public Integer topLogProbs;
        @Nullable
        public ResponseFormat responseFormat;
        @Nullable
        public ToolChoice toolChoice;
        @Nullable
        public List<AbstractTool> tools;
        @Nullable
        public List<String> classLabels;
        @Nullable
        public String hypothesisTemplate;
        @Nullable
        public Integer summarizationMinTokens;
        @Nullable
        public Integer summarizationMaxTokens;
        @Nullable
        public Integer summarizationSpecialTokensSafetyFactor;
        @Nullable
        public Integer summarizationNumOverlapTokens;
        @Nullable
        public Integer summarizationMaxNumSplitLevels;
        @Nullable
        public ClassificationOutputMode textClassificationOutputMode;

        public static enum ClassificationOutputMode {
            ALL,
            MOST_RELEVANT,
            FIRST;

        }
    }

    public static class SingleCompletionQuery {
        @Nullable
        public JsonObject context;
        public List<ChatMessage> messages = new ArrayList<ChatMessage>();

        public List<ChatMessagePart> getImageParts() {
            return this.messages.stream().filter(messages -> messages.parts != null).flatMap(messages -> messages.parts.stream()).filter(part -> part.type == ChatMessagePartType.IMAGE_INLINE || part.type == ChatMessagePartType.IMAGE_URI).collect(Collectors.toList());
        }
    }

    @RoutinelyUsedInExtensionCode
    public static class CompletionQuery {
        public List<ChatMessage> messages = new ArrayList<ChatMessage>();
        public LLMCompletionSettings settings = new LLMCompletionSettings();
        public List<String> classLabels;
        public String hypothesisTemplate;
        public Integer summarizationMinTokens;
        public Integer summarizationMaxTokens;
        public Integer summarizationSpecialTokensSafetyFactor;
        public Integer summarizationNumOverlapTokens;
        public Integer summarizationMaxNumSplitLevels;
        public ClassificationOutputMode textClassificationOutputMode;

        public static enum ClassificationOutputMode {
            ALL,
            MOST_RELEVANT,
            FIRST;

        }
    }
}

