/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.cohere;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.CohereConnection;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.AbstractLLMClient;
import com.dataiku.dip.llm.online.LLMChatMessageUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMQueryRunner;
import com.dataiku.dip.llm.online.cohere.RawCohereClient;
import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.llm.utils.OnlineLLMUtils;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CohereClient
extends AbstractLLMClient
implements LLMClient {
    private final CohereConnection connection;
    private final LLMQueryRunner queryRunner;
    private final RawCohereClient raw;
    private final CohereConnection.CohereModel model;
    private ComputeResourceUsage.InternalLLMUsageData usageData = new ComputeResourceUsage.LLMUsageData();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.llm.cohere");

    public CohereClient(CohereConnection connection, LLMModelHandle<CohereConnection.CohereModel> modelHandle, String apiKey) {
        super(modelHandle.getEnrichedRef());
        this.connection = connection;
        this.queryRunner = new LLMQueryRunner(this.getProviderId(), modelHandle, connection.params.networkSettings, OnlineLLMUtils::isRetryableException);
        this.raw = new RawCohereClient(apiKey, this.queryRunner.getHttpClientNetworkSettings(), connection.getProxySettings());
        this.model = modelHandle.getModel();
    }

    @Override
    public void close() {
        this.raw.close();
    }

    @Override
    public boolean supportNativeBatch() {
        return false;
    }

    @Override
    public boolean requiresCostLimiting() {
        return true;
    }

    @Override
    public String getProviderId() {
        return "Cohere";
    }

    @Override
    public AbstractLLMConnection getConnection() {
        return this.connection;
    }

    @Override
    public int getMaxParallelism() {
        return this.connection.params.maxParallelism;
    }

    @Override
    public List<LLMClient.ChatMessage> getFormattedPrompt(List<LLMClient.ChatMessage> chatMessages) {
        return CohereClient.formatChatMessages(chatMessages);
    }

    public static List<LLMClient.ChatMessage> formatChatMessages(List<LLMClient.ChatMessage> chatMessages) {
        chatMessages = LLMChatMessageUtils.convertExtraSystemMessageToUser(chatMessages);
        return LLMChatMessageUtils.collapseAdjacentSameRoleMessages(chatMessages);
    }

    @Override
    public List<LLMClient.SimpleCompletionResponse> completeBatch(List<LLMClient.SingleCompletionQuery> queries, LLMClient.CompletionSettings settings) throws Exception {
        ArrayList<LLMClient.SimpleCompletionResponse> ret = new ArrayList<LLMClient.SimpleCompletionResponse>();
        CoreCompletionSettings ccs = this.getCoreCompletionSettings(settings);
        for (LLMClient.SingleCompletionQuery query : queries) {
            long before = System.currentTimeMillis();
            List<LLMClient.ChatMessage> chatMessages = this.getFormattedPrompt(query.messages);
            LLMClient.SimpleCompletionResponse scr = this.queryRunner.run(() -> this.raw.chatComplete(chatMessages, ccs));
            scr.estimatedCost = this.model.getEstimatedCompletionCost(scr.promptTokens, scr.completionTokens);
            this.usageData.incrementTotalComputationTimeMS(Long.valueOf(System.currentTimeMillis() - before));
            this.usageData.incrementTotalPromptTokens(scr.promptTokens);
            this.usageData.incrementTotalCompletionTokens(scr.completionTokens);
            this.usageData.incrementEstimatedCostUSD(scr.estimatedCost);
            ret.add(scr);
        }
        return ret;
    }

    @Override
    public List<LLMClient.SimpleEmbeddingResponse> embedBatch(List<LLMClient.EmbeddingQuery> queries, LLMClient.EmbeddingSettings settings) throws IOException {
        throw new IllegalArgumentException("Embeddings not supported on this LLM");
    }

    @Override
    public ComputeResourceUsage getTotalCRU(ComputeResourceUsage.LLMUsageType usageType, LLMStructuredRef llmRef) {
        ComputeResourceUsage cru = new ComputeResourceUsage();
        cru.setupLLMUsage(usageType, llmRef.connection, llmRef.type.toString(), llmRef.id);
        cru.llmUsage.setFromInternal(this.usageData);
        return cru;
    }
}

