/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai.api;

import com.dataiku.common.stereotype.RoutinelyUsedInExtensionCode;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.FinishReasonResponseAdapter;
import com.dataiku.dip.llm.online.openai.api.OpenAIChatChunkResponse;
import com.dataiku.dip.llm.online.openai.api.OpenAIChatResponseAdapter;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@RoutinelyUsedInExtensionCode
public class OpenAIChatChunkResponseAdapter {
    private OpenAIChatChunkResponseAdapter() {
    }

    @RoutinelyUsedInExtensionCode
    public static LLMClient.StreamedCompletionResponseChunk adapt(OpenAIChatChunkResponse response) {
        if (response.choices == null || response.choices.isEmpty()) {
            throw new IllegalArgumentException("Empty chat chunk response");
        }
        OpenAIChatChunkResponse.Choice choice = response.choices.get(0);
        LLMClient.StreamedCompletionResponseChunk resp = new LLMClient.StreamedCompletionResponseChunk();
        resp.text = choice.delta.content;
        if (choice.logProbs != null && choice.logProbs.content != null) {
            resp.logProbs = choice.logProbs.content.stream().map(OpenAIChatResponseAdapter::adapt).collect(Collectors.toList());
        }
        if (choice.delta.toolCalls != null && !choice.delta.toolCalls.isEmpty()) {
            resp.toolCalls = choice.delta.toolCalls.stream().map(OpenAIChatChunkResponseAdapter::adapt).collect(Collectors.toList());
        }
        return resp;
    }

    @Nullable
    @RoutinelyUsedInExtensionCode
    public static String getRefusal(OpenAIChatChunkResponse response) {
        if (response.choices == null || response.choices.isEmpty()) {
            return null;
        }
        OpenAIChatChunkResponse.Choice choice = response.choices.get(0);
        return choice.delta.refusal;
    }

    private static LLMClient.AbstractToolCall adapt(OpenAIChatChunkResponse.PartialToolCall tc) {
        LLMClient.FunctionToolCallInfo function = new LLMClient.FunctionToolCallInfo();
        function.name = tc.function.name;
        function.arguments = tc.function.arguments;
        LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
        ftc.index = tc.index;
        ftc.id = tc.id;
        ftc.function = function;
        return ftc;
    }

    @Nullable
    @RoutinelyUsedInExtensionCode
    public static LLMClient.FinishReason extractFinishReason(OpenAIChatChunkResponse response) {
        if (response.choices == null || response.choices.isEmpty()) {
            return null;
        }
        OpenAIChatChunkResponse.Choice choice = response.choices.get(0);
        if (choice.finishReason == null) {
            return null;
        }
        return FinishReasonResponseAdapter.adapt(choice.finishReason);
    }
}

