/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai.api;

import com.dataiku.common.stereotype.RoutinelyUsedInExtensionCode;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.FinishReasonResponseAdapter;
import com.dataiku.dip.llm.online.openai.api.OpenAIChatResponse;
import com.dataiku.dip.utils.DKULogger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@RoutinelyUsedInExtensionCode
public class OpenAIChatResponseAdapter {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.openai.api");

    private OpenAIChatResponseAdapter() {
    }

    @Nullable
    @RoutinelyUsedInExtensionCode
    public static String getRefusal(OpenAIChatResponse response) {
        if (response.choices == null || response.choices.isEmpty()) {
            return null;
        }
        OpenAIChatResponse.Choice choice = response.choices.get(0);
        return choice.message.refusal;
    }

    @RoutinelyUsedInExtensionCode
    public static LLMClient.SimpleCompletionResponse adapt(OpenAIChatResponse response) {
        if (response.choices == null || response.choices.isEmpty()) {
            throw new IllegalArgumentException("Empty chat response");
        }
        if (response.choices.size() > 1) {
            logger.warn((Object)String.format("The chat response contains %d choices, only using the first one", response.choices.size()));
        }
        OpenAIChatResponse.Choice choice = response.choices.get(0);
        LLMClient.SimpleCompletionResponse resp = new LLMClient.SimpleCompletionResponse();
        resp.text = choice.message.content;
        resp.finishReason = FinishReasonResponseAdapter.adapt(choice.finishReason);
        resp.promptTokens = response.usage.promptTokens;
        resp.completionTokens = response.usage.completionTokens;
        if (choice.logProbs != null && choice.logProbs.content != null) {
            resp.logProbs = choice.logProbs.content.stream().map(OpenAIChatResponseAdapter::adapt).collect(Collectors.toList());
        }
        if (choice.message.toolCalls != null && !choice.message.toolCalls.isEmpty()) {
            resp.toolCalls = choice.message.toolCalls.stream().map(OpenAIChatResponseAdapter::adapt).collect(Collectors.toList());
        }
        return resp;
    }

    static LLMClient.DetailedLogProb adapt(OpenAIChatResponse.LogProbContent lpc) {
        LLMClient.DetailedLogProb dlp = new LLMClient.DetailedLogProb();
        dlp.token = lpc.token;
        dlp.logProb = lpc.logProb;
        dlp.topLogProbs = lpc.topLogProbs.stream().map(OpenAIChatResponseAdapter::adapt).collect(Collectors.toList());
        return dlp;
    }

    private static LLMClient.SimpleLogProb adapt(OpenAIChatResponse.TopLogProbContent tlpc) {
        LLMClient.SimpleLogProb slp = new LLMClient.SimpleLogProb();
        slp.token = tlpc.token;
        slp.logProb = tlpc.logProb;
        return slp;
    }

    private static LLMClient.AbstractToolCall adapt(OpenAIChatResponse.ToolCall tc) {
        LLMClient.FunctionToolCallInfo function = new LLMClient.FunctionToolCallInfo();
        function.name = tc.function.name;
        function.arguments = tc.function.arguments;
        LLMClient.FunctionToolCall ftc = new LLMClient.FunctionToolCall();
        ftc.id = tc.id;
        ftc.function = function;
        return ftc;
    }
}

