/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.openai.api;

import com.dataiku.dip.llm.online.marshall.CoreCompletionSettings;
import com.dataiku.dip.llm.online.openai.OpenAIMode;
import com.dataiku.dip.llm.online.openai.api.OpenAICompletionQuery;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public class OpenAICompletionQueryAdapter {
    private OpenAICompletionQueryAdapter() {
    }

    public static OpenAICompletionQuery adapt(OpenAIMode mode, String model, String prompt, CoreCompletionSettings ccs) {
        OpenAICompletionQuery query = new OpenAICompletionQuery();
        query.prompt = prompt;
        query.model = OpenAICompletionQueryAdapter.adaptModel(mode, model);
        if (ccs.maxTokens != null) {
            query.maxTokens = ccs.maxTokens;
        }
        if (ccs.maxTokens == null && model.equals("gpt-3.5-turbo-instruct")) {
            query.maxTokens = 1024;
        }
        if (ccs.temperature != null) {
            query.temperature = ccs.temperature;
        }
        if (ccs.topP != null) {
            query.topP = ccs.topP;
        }
        if (ccs.frequencyPenalty != null) {
            query.frequencyPenalty = ccs.frequencyPenalty;
        }
        if (ccs.presencePenalty != null) {
            query.presencePenalty = ccs.presencePenalty;
        }
        if (ccs.logitBias != null && !ccs.logitBias.isEmpty()) {
            query.logitBias = new HashMap<String, Double>();
            ccs.logitBias.forEach((tokenId, bias) -> query.logitBias.put(tokenId.toString(), (Double)bias));
        }
        if (ccs.logProbs == Boolean.TRUE) {
            query.logProbs = Objects.requireNonNullElse(ccs.topLogProbs, 0);
        } else if (ccs.topLogProbs != null) {
            throw new IllegalArgumentException("Setting 'topLogProbs' requires 'logProbs' to be enabled");
        }
        if (ccs.stopSequences != null && !ccs.stopSequences.isEmpty()) {
            query.stop = ccs.stopSequences;
        }
        return query;
    }

    @Nullable
    private static String adaptModel(OpenAIMode mode, String model) {
        switch (mode) {
            case AZURE_OPENAI: 
            case AZURE_LLM: {
                return null;
            }
            case OPENAI: {
                return model;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown mode: %s", mode.name()));
    }
}

