/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.utils;

import com.dataiku.dip.llm.online.utils.QueryProcessor;
import com.dataiku.dip.utils.DKULogger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BlockingQueryProcessor<Q, R>
implements QueryProcessor<Q, R> {
    private final OfferBlockingLinkedBlockingQueue<IncomingTask> incomingQueue;
    private final QueryProcessor<Q, R> innerProcessor;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.online.utils.bqp");

    public BlockingQueryProcessor(QueryProcessor<Q, R> innerProcessor, int incomingQueueSize) {
        this.innerProcessor = innerProcessor;
        this.incomingQueue = new OfferBlockingLinkedBlockingQueue(incomingQueueSize);
    }

    @Override
    public CompletableFuture<R> submit(Q query) {
        IncomingTask incomingTask = new IncomingTask(query);
        logger.trace((Object)"Offering to incoming queue");
        if (!this.incomingQueue.offer(incomingTask)) {
            throw new IllegalStateException("Failed to offer to queue after time-out");
        }
        logger.trace((Object)"Offered to incoming queue");
        incomingTask.future = this.innerProcessor.submit(query).whenComplete((r, e) -> this.incomingQueue.remove(incomingTask));
        return incomingTask.future;
    }

    public static class OfferBlockingLinkedBlockingQueue<E>
    extends LinkedBlockingQueue<E> {
        private static final long serialVersionUID = 1L;

        public OfferBlockingLinkedBlockingQueue(int x) {
            super(x);
        }

        @Override
        public boolean offer(E r) {
            try {
                return this.offer(r, 999L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Failed to offer to queue", (Throwable)e);
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    class IncomingTask {
        final Q query;
        CompletableFuture<R> future;

        IncomingTask(Q query) {
            this.query = query;
        }
    }
}

