/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.promptstudio;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.PromptDef;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.promptstudio.PromptResponse;
import com.dataiku.dip.recipes.nlp.common.LLMCompletionSettings;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class PromptStudio
extends TaggableObjectsService.TaggableObject {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public String name;
    public List<PromptStudioPrompt> prompts = new ArrayList<PromptStudioPrompt>();

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.PROMPT_STUDIO;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    public static class PromptStudioListItem
    extends TaggableObjectsService.TaggableListItem {
        public List<String> promptIds;

        public PromptStudioListItem(PromptStudio promptStudio) {
            super(promptStudio);
            this.promptIds = promptStudio.prompts.stream().map(prompt -> prompt.id).collect(Collectors.toList());
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.PROMPT_STUDIO;
        }
    }

    @Deprecated
    public static class LLMStructuredRef
    extends EnrichedLLMStructuredRef {
        public LLMStructuredRef(com.dataiku.dip.llm.LLMStructuredRef ref) {
            super(ref, null, null, null, null);
        }
    }

    public static class ConversationMessage {
        public final String id;
        public String parentId;
        public int version;
        public LLMClient.ChatMessage message;
        public LLMCompletionSettings completionSettings;
        public String systemMessage;
        public com.dataiku.dip.llm.LLMStructuredRef llmStructuredRef;
        @Nullable
        public List<LLMClient.Source> sources;
        public LLMClient.LLMMeshTraceSpan fullTrace;
        public String runBy;
        public boolean error;
        public String llmError;
        public PromptResponse.ResponseValidationStatus validationStatus = PromptResponse.ResponseValidationStatus.NOT_PERFORMED;
        public String validationMessage;

        public ConversationMessage() {
            this.id = SecretKeyGenerator.generateSmall();
        }
    }

    public static class PromptStudioPrompt {
        public String id;
        public PromptDef prompt;
        public String llmId;
        public ContainerExecSelection containerSelection = new ContainerExecSelection();
        public LLMCompletionSettings llmSettings = new LLMCompletionSettings();
        public String dataset;
        public int nbRows = 8;
        public List<InlinePromptTemplateQuery> inlinePromptTemplateQueries = new ArrayList<InlinePromptTemplateQuery>();
        public String description;
        public List<String> tags = new ArrayList<String>();
        public boolean starred;
    }

    public static class PromptStudioPromptHistory {
        public String promptId;
        public List<PromptStudioPromptHistoryEntry> entries = new ArrayList<PromptStudioPromptHistoryEntry>();
    }

    public static class PromptStudioPromptHistoryEntry {
        String runId;
        PromptStudioPrompt promptStudioPrompt;
        long runOn;
        String runBy;
        PromptResponse.PromptResponseStats responseStats;
    }

    public static class InlinePromptTemplateQuery {
        Map<String, String> data = new HashMap<String, String>();
        String singleInputData;
    }

    public static class ResultValidation {
        ExpectedFormat expectedFormat = ExpectedFormat.NONE;
        List<String> requiredJSONObjectKeys = new ArrayList<String>();
        List<ResultForbiddenTerm> forbiddenTerms = new ArrayList<ResultForbiddenTerm>();

        public boolean hasNoSetRules() {
            return ExpectedFormat.NONE.equals((Object)this.expectedFormat) && this.forbiddenTerms.isEmpty();
        }

        public static enum ExpectedFormat {
            JSON_ARRAY,
            JSON_OBJECT,
            CSV,
            ONE_ITEM_PER_LINE,
            NONE;

        }
    }

    public static class ResultForbiddenTerm {
        String value;
        boolean regexp;
    }

    public static class StructuredPromptTemplateExample {
        public List<String> inputs = new ArrayList<String>();
        public String output;

        public static StructuredPromptTemplateExample newSingleInput(String in, String o) {
            StructuredPromptTemplateExample ret = new StructuredPromptTemplateExample();
            ret.inputs = Collections.singletonList(in);
            ret.output = o;
            return ret;
        }
    }

    public static enum PromptTemplateInputType {
        TEXT,
        IMAGE;

    }

    public static class PromptTemplateInput {
        public String name;
        public String datasetColumnName;
        public PromptTemplateInputType type = PromptTemplateInputType.TEXT;

        public boolean equals(Object other) {
            if (other == null || !(other instanceof PromptTemplateInput)) {
                return false;
            }
            PromptTemplateInput input = (PromptTemplateInput)other;
            return StringUtils.equals((String)this.name, (String)input.name) && StringUtils.equals((String)this.datasetColumnName, (String)input.datasetColumnName) && this.type == input.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.datasetColumnName, this.type});
        }
    }

    public static enum PromptTemplateQueriesSource {
        INLINE,
        DATASET;

    }

    public static enum PromptMode {
        PROMPT_TEMPLATE_TEXT(true),
        PROMPT_TEMPLATE_STRUCTURED(true),
        RAW_PROMPT(false),
        CHAT(false);

        public final boolean canUseDataset;

        private PromptMode(boolean canUseDataset) {
            this.canUseDataset = canUseDataset;
        }
    }
}

