/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.retrieval;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.Set;

public class RetrievableKnowledgeUtils {
    public static final String VERSIONS_FOLDER_NAME = "versions";
    public static final String VERSIONS_FILE_NAME = "versions.json";
    public static final String NOT_VERSIONED = "not-versioned";
    public static final String NOT_BUILT = "not-built";

    public static String getCurrentVersionUnsafe(RetrievableKnowledge kb) throws IOException {
        File kbFolder = RetrievableKnowledgeUtils.getDataFolder(kb.getProjectKey(), kb.getId());
        if (!kbFolder.exists()) {
            return NOT_BUILT;
        }
        File versionsFile = DKUApp.getFile((File)kbFolder, (String[])new String[]{VERSIONS_FILE_NAME});
        if (!versionsFile.exists()) {
            return NOT_VERSIONED;
        }
        RetrievableKnowledge.RetrievableKnowledgeVersions metadata = (RetrievableKnowledge.RetrievableKnowledgeVersions)JSON.parseFile((File)versionsFile, RetrievableKnowledge.RetrievableKnowledgeVersions.class);
        File versionFolder = DKUApp.getFile((File)kbFolder, (String[])new String[]{VERSIONS_FOLDER_NAME, metadata.currentVersion});
        if (!versionFolder.exists()) {
            throw new IOException(String.format("Knowledge bank current version '%s' does not exist", metadata.currentVersion));
        }
        return versionFolder.getName();
    }

    public static File getDataFolder(String projectKey, String id) {
        return DKUApp.getFile((String[])new String[]{"knowledge-banks", projectKey, id});
    }

    public static File getVersionFolder(RetrievableKnowledge kb, String version) {
        File kbFolder = RetrievableKnowledgeUtils.getDataFolder(kb.getProjectKey(), kb.getId());
        return Set.of(NOT_BUILT, NOT_VERSIONED).contains(version) ? kbFolder : DKUApp.getFile((File)kbFolder, (String[])new String[]{VERSIONS_FOLDER_NAME, version});
    }
}

