/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.File;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class CleanDocExtractionTmpDir
implements Job {
    private static DKULogger dkuLogger = DKULogger.getLogger(CleanDocExtractionTmpDir.class);
    public static final long PURGE_AGE_SECONDS = 86400L;

    public CleanDocExtractionTmpDir() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        DKULogger.startCurrentCall();
        long purgeArge = DKUApp.getParams().getLongParam("dku.maintenance.cleanDocextractionTmpFiles.purgeAgeS", 86400L);
        long fromTime = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(purgeArge);
        File baseFolder = DKUApp.getFile((String[])new String[]{"tmp", "docextraction"});
        try {
            dkuLogger.info((Object)("Begin cleaning doc extraction temporary files - outdated since: " + DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(fromTime))));
            if (baseFolder.isDirectory()) {
                for (File tmpFile : DKUFileUtils.recursiveListFiles((File)baseFolder)) {
                    if (!Instant.ofEpochMilli(tmpFile.lastModified()).isBefore(Instant.ofEpochMilli(fromTime))) continue;
                    try {
                        DKUFileUtils.delete((File)tmpFile);
                    }
                    catch (Exception e) {
                        dkuLogger.error((Object)("Error while deleting old doc extraction tmp file: " + tmpFile.getName() + " with error: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    }
                }
            }
        }
        catch (Exception e) {
            dkuLogger.error((Object)"Cleanup failed", (Throwable)e);
            throw new JobExecutionException("Cleanup failed", (Throwable)e);
        }
        finally {
            dkuLogger.info((Object)"Finished cleaning old doc extraction tmp files");
            DKULogger.endCurrentCall();
        }
    }
}

