/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.meanings;

import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.meanings.model.UserDefinedMeaning;
import com.dataiku.dip.shaker.types.BagOfWordsMeaning;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.shaker.types.CountryMeaning;
import com.dataiku.dip.shaker.types.CurrencyAmountMeaning;
import com.dataiku.dip.shaker.types.CurrencyMeaning;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DateSource;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.shaker.types.DeclarativeUDMDetector;
import com.dataiku.dip.shaker.types.DoubleMeaning;
import com.dataiku.dip.shaker.types.Email;
import com.dataiku.dip.shaker.types.FreeText;
import com.dataiku.dip.shaker.types.FrenchDoubleMeaning;
import com.dataiku.dip.shaker.types.Gender;
import com.dataiku.dip.shaker.types.GeoPoint;
import com.dataiku.dip.shaker.types.GeometryMeaning;
import com.dataiku.dip.shaker.types.IPAddress;
import com.dataiku.dip.shaker.types.JSONArrayMeaning;
import com.dataiku.dip.shaker.types.JSONObjectMeaning;
import com.dataiku.dip.shaker.types.Latitude;
import com.dataiku.dip.shaker.types.LongMeaning;
import com.dataiku.dip.shaker.types.Longitude;
import com.dataiku.dip.shaker.types.MeaningDetector;
import com.dataiku.dip.shaker.types.Measure;
import com.dataiku.dip.shaker.types.PatternUDMDetector;
import com.dataiku.dip.shaker.types.QueryString;
import com.dataiku.dip.shaker.types.Temperature;
import com.dataiku.dip.shaker.types.Text;
import com.dataiku.dip.shaker.types.URL;
import com.dataiku.dip.shaker.types.USStateMeaning;
import com.dataiku.dip.shaker.types.UserAgent;
import com.dataiku.dip.shaker.types.ValueListUDMDetector;
import com.dataiku.dip.shaker.types.ValueMappingUDMDetector;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBasicMeaningsService
implements IBasicMeaningsService {
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.meanings.service");

    public UserDefinedMeaning getUDM(String id) throws IOException {
        return this.getUDMs().get(id);
    }

    @Override
    public synchronized MeaningDetector buildSingleDetector(String meaning) throws IOException {
        if (this.getUDMs().containsKey(meaning)) {
            return this.buildUDMDetector(this.getUDMs().get(meaning));
        }
        try {
            String dataTypeName = "com.dataiku.dip.shaker.types." + meaning;
            return (MeaningDetector)Class.forName(dataTypeName).newInstance();
        }
        catch (Exception e) {
            logger.warn((Object)("Unknown meaning: '" + meaning + "'. Falling back to Text."), (Throwable)e);
            return new Text(meaning);
        }
    }

    public boolean hasDetector(String meaning) {
        try {
            if (this.getUDM(meaning) != null) {
                return true;
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to get UDMs", (Throwable)e);
            return false;
        }
        try {
            String dataTypeName = "com.dataiku.dip.shaker.types." + meaning;
            Class.forName(dataTypeName).newInstance();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public synchronized List<MeaningDetector> buildDetectableDetectors() throws IOException {
        ArrayList<MeaningDetector> builtinDetectors = new ArrayList<MeaningDetector>();
        builtinDetectors.add((MeaningDetector)new DoubleMeaning());
        builtinDetectors.add((MeaningDetector)new LongMeaning());
        builtinDetectors.add((MeaningDetector)new FrenchDoubleMeaning());
        builtinDetectors.add((MeaningDetector)new Temperature());
        builtinDetectors.add((MeaningDetector)new Date());
        builtinDetectors.add((MeaningDetector)new DateOnly());
        builtinDetectors.add((MeaningDetector)new DatetimeNoTz());
        builtinDetectors.add((MeaningDetector)new DateSource());
        builtinDetectors.add((MeaningDetector)new Latitude());
        builtinDetectors.add((MeaningDetector)new Longitude());
        builtinDetectors.add((MeaningDetector)new IPAddress());
        builtinDetectors.add((MeaningDetector)new QueryString());
        builtinDetectors.add((MeaningDetector)new URL());
        builtinDetectors.add((MeaningDetector)new JSONObjectMeaning());
        builtinDetectors.add((MeaningDetector)new JSONArrayMeaning());
        builtinDetectors.add((MeaningDetector)new BagOfWordsMeaning());
        builtinDetectors.add((MeaningDetector)new GeoPoint());
        builtinDetectors.add((MeaningDetector)new UserAgent());
        builtinDetectors.add((MeaningDetector)new Boolean());
        builtinDetectors.add((MeaningDetector)new Email());
        builtinDetectors.add((MeaningDetector)new FreeText());
        builtinDetectors.add((MeaningDetector)new Gender());
        builtinDetectors.add((MeaningDetector)new Measure());
        if (BuiltinsLoader.geoToolsAvailable()) {
            builtinDetectors.add((MeaningDetector)new GeometryMeaning());
        }
        builtinDetectors.add((MeaningDetector)new CountryMeaning());
        builtinDetectors.add((MeaningDetector)new USStateMeaning());
        builtinDetectors.add((MeaningDetector)new CurrencyMeaning());
        builtinDetectors.add((MeaningDetector)new CurrencyAmountMeaning());
        for (UserDefinedMeaning udm : this.getUDMs().values()) {
            if (!udm.detectable) continue;
            builtinDetectors.add(this.buildUDMDetector(udm));
        }
        return builtinDetectors;
    }

    protected MeaningDetector buildUDMDetector(UserDefinedMeaning udm) {
        switch (udm.type) {
            case DECLARATIVE: {
                return new DeclarativeUDMDetector(udm);
            }
            case VALUES_LIST: {
                return new ValueListUDMDetector(udm);
            }
            case VALUES_MAPPING: {
                return new ValueMappingUDMDetector(udm);
            }
            case PATTERN: {
                return new PatternUDMDetector(udm);
            }
        }
        throw ErrorContext.iae((String)("No detector implemented for UDM type: " + udm.type.toString()));
    }
}

