/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.engines.MetricsQueryBuilder;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import java.util.List;

public class ColumnMetricsQueryBuilder {
    public QueryBunch buildQuery(AuthCtx authCtx, ColumnMetricsQueryBuilderEngine engine, List<MetricComputation> computations) throws Exception {
        Dataset dataset = engine.getDataset();
        SQLDialect dialect = engine.getDialect();
        QueryBunch queryBunch = new QueryBunch();
        SelectQueryBuilder queryBuilder = MetricsQueryBuilder.getSelectQueryBuilder(authCtx, dataset, dialect, queryBunch);
        String columnName = null;
        for (MetricComputation computation : computations) {
            ColumnMetricsQueryBuilderAggregation computer = (ColumnMetricsQueryBuilderAggregation)((Object)computation.computer);
            computer.addAggregations(engine, computation, dialect, queryBuilder);
            columnName = computer.getColumn(computation);
        }
        ExpressionBuilder partitionFilter = engine.getPartitionFilter();
        if (partitionFilter != null) {
            queryBuilder.where(partitionFilter);
        }
        ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
        queryBuilder.group(ef.col(columnName));
        String alias = "__cnt_for_ordering__";
        queryBuilder.select(ef.expr("COUNT(*)"), alias);
        queryBuilder.order(ef.col(alias), QueryAst.OrderType.DESC);
        queryBuilder.ensureAliasesMaxLength(30);
        queryBunch.query = queryBuilder.toSQL(dialect);
        return queryBunch;
    }

    public static interface ColumnMetricsQueryBuilderEngine {
        public Dataset getDataset();

        public SQLDialect getDialect();

        public ExpressionBuilder getPartitionFilter();
    }

    public static interface ColumnMetricsQueryBuilderAggregation {
        public String getColumn(MetricComputation var1);

        public void addAggregations(ColumnMetricsQueryBuilderEngine var1, MetricComputation var2, SQLDialect var3, SelectQueryBuilder var4) throws Exception;

        public boolean handleResult(List<QueryRunResult.ScriptRunResultColumn> var1, String[] var2, MetricComputation var3) throws Exception;

        public String getAggregate(MetricComputation var1) throws Exception;
    }
}

