/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.io.CustomPythonKernelException;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.PythonMetricKernel;
import com.dataiku.dip.metrics.engines.MetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.probes.MetricBuilder;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PythonProbeEngine
implements MetricsEngine {
    private final Dataset dataset;
    private final Partition partition;
    private final DatasetHandler datasetHandler;
    private final APITicketService.Ticket ticket;
    private final ManagedFolder folder;
    private final ManagedFolderHandler folderHandler;
    private final String projectKey;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.python");

    public PythonProbeEngine(Dataset dataset, DatasetHandler datasetHandler, Partition partition, PythonMetricsEngineConfig config, APITicketService.Ticket ticket) {
        this.dataset = dataset;
        this.datasetHandler = datasetHandler;
        this.folder = null;
        this.folderHandler = null;
        this.partition = partition;
        this.ticket = ticket;
        this.projectKey = dataset.getProjectKey();
    }

    public PythonProbeEngine(ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, PythonMetricsEngineConfig config, APITicketService.Ticket ticket) {
        this.folder = folder;
        this.folderHandler = folderHandler;
        this.dataset = null;
        this.datasetHandler = null;
        this.partition = partition;
        this.ticket = ticket;
        this.projectKey = folder.projectKey;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public DatasetHandler getDatasetHandler() {
        return this.datasetHandler;
    }

    public ManagedFolder getManagedFolder() {
        return this.folder;
    }

    public ManagedFolderHandler getManagedFolderHandler() {
        return this.folderHandler;
    }

    @Override
    public Map<Metric, String> compute(List<MetricComputation> computations, MetricsComputationService.MetricsEngineRunReport report, FutureService futureService, AuthCtx authCtx, Map<String, String> alreadyComputed) throws Exception {
        MetricComputation primerComputation = computations.get(0);
        Probe pythonProbe = primerComputation.probe;
        MetricComputer.PythonEngineComputer computer = (MetricComputer.PythonEngineComputer)primerComputation.computer;
        Map<Object, Object> metricsValues = Maps.newHashMap();
        PythonMetricKernel kernel = null;
        SingleCommandKernelLink link = null;
        try {
            Map<Object, Object> map;
            block25: {
                AutoDelete tmpDir = FlowJobUtils.getTmpFolder("python-probe", "run");
                try {
                    PythonMetricKernel.ComputeMetricRequest req;
                    String partitionId;
                    String secret = SecretKeyGenerator.generate((int)16);
                    PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
                    link = new SingleCommandKernelLink(secret, dssPortRange);
                    String envName = computer.getEnvName(primerComputation.probe, this.projectKey);
                    kernel = new PythonMetricKernel(link, this.ticket, computer.getResourceFolder(), computer.getLibFolder(), (File)tmpDir, this.projectKey, authCtx, envName);
                    kernel.start();
                    String string = partitionId = this.partition != null ? this.partition.id() : "NP";
                    if (this.dataset != null) {
                        fullName = this.dataset.getFullName();
                        resolvedSettings = computer.getPluginConfig(pythonProbe, authCtx, this.dataset.getProjectKey());
                        req = new PythonMetricKernel.ComputeMetricRequest(computer.getCode(pythonProbe), resolvedSettings.config, resolvedSettings.pluginConfig, MetricTargetType.DATASET, (String)fullName, partitionId);
                    } else {
                        fullName = this.folder.projectKey + "." + this.folder.id;
                        resolvedSettings = computer.getPluginConfig(pythonProbe, authCtx, this.folder.getProjectKey());
                        req = new PythonMetricKernel.ComputeMetricRequest(computer.getCode(pythonProbe), resolvedSettings.config, resolvedSettings.pluginConfig, MetricTargetType.MANAGED_FOLDER, (String)fullName, partitionId);
                    }
                    PythonMetricKernel.ComputeMetricResponse resp = (PythonMetricKernel.ComputeMetricResponse)link.execute((Object)req, PythonMetricKernel.ComputeMetricResponse.class, "Failed to compute metric");
                    Map<String, Object> results = resp.result;
                    Map<String, String> types = resp.types;
                    logger.info((Object)("Kernel answered results " + JSON.pretty(results)));
                    logger.info((Object)("Kernel answered types " + JSON.pretty(types)));
                    map = metricsValues = PythonProbeEngine.makeMetricsValuesFromObjectMap(this.dataset, MetricTargetType.DATASET, pythonProbe, results, types);
                    if (tmpDir == null) break block25;
                }
                catch (Throwable throwable) {
                    try {
                        if (tmpDir != null) {
                            try {
                                tmpDir.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SocketBlockLinkException e) {
                        e.withLogTail(kernel);
                        throw kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
                    }
                    catch (SocketBlockLink.SecretKernelTimeoutException e) {
                        logger.error((Object)"Failure during kernel startup", (Throwable)e);
                        throw new CustomPythonKernelException("Failure during kernel startup", (Exception)((Object)e), kernel.getLogTail());
                    }
                    catch (Exception e) {
                        logger.error((Object)"Generic failure during metric computation", (Throwable)e);
                        throw new CustomPythonKernelException("Failure during metric computation", e, kernel.getLogTail());
                    }
                }
                tmpDir.close();
            }
            return map;
        }
        finally {
            if (kernel != null) {
                try {
                    kernel.killWithoutMercy();
                }
                catch (Throwable e) {
                    logger.error((Object)"Failed to kill kernel", e);
                }
            }
            if (link != null) {
                try {
                    link.close();
                }
                catch (Throwable e) {
                    logger.error((Object)"Failed to close link", e);
                }
            }
        }
    }

    public static Map<Metric, String> makeMetricsValuesFromObjectMap(Object object, MetricTargetType objectType, Probe probe, Map<String, Object> results, Map<String, String> types) {
        DateTimeFormatter isoFormatter = ISODateTimeFormat.dateTimeParser();
        ProbeType probeType = ProbeType.getProbeType(probe.getType());
        if (probeType == null) {
            throw new IllegalArgumentException("Probe of unknown type " + probe.getType());
        }
        if (!(probeType instanceof MetricBuilder)) {
            throw new IllegalArgumentException("Probe of type " + probe.getType() + " cannot build metrics.");
        }
        MetricBuilder metricBuilder = (MetricBuilder)((Object)probeType);
        HashMap metricsValues = Maps.newHashMap();
        for (Map.Entry<String, Object> keyValue : results.entrySet()) {
            String valueStr;
            Object value = keyValue.getValue();
            String udfTypeStr = types.get(keyValue.getKey());
            Type udfType = null;
            if (StringUtils.isNotBlank((String)udfTypeStr)) {
                try {
                    udfType = Type.valueOf((String)udfTypeStr);
                }
                catch (Exception e) {
                    logger.warn((Object)("Type specified by user is not valid : " + udfTypeStr));
                }
            }
            Type valueType = Type.STRING;
            if (udfType == null) {
                if (value == null) {
                    valueType = Type.STRING;
                    valueStr = null;
                } else if (value instanceof String) {
                    valueType = Type.STRING;
                    valueStr = (String)value;
                } else if (value instanceof Double || value instanceof Float) {
                    valueType = Type.DOUBLE;
                    valueStr = Double.toString(((Number)value).doubleValue());
                } else if (value instanceof Long || value instanceof Integer) {
                    valueType = Type.BIGINT;
                    valueStr = Long.toString(((Number)value).longValue());
                } else if (value instanceof Boolean) {
                    valueType = Type.BOOLEAN;
                    valueStr = Boolean.toString((Boolean)value);
                } else if (value instanceof List) {
                    valueType = Type.ARRAY;
                    valueStr = JSON.json((Object)value);
                } else {
                    valueType = Type.OBJECT;
                    valueStr = JSON.json((Object)value);
                }
            } else {
                valueType = udfType;
                valueStr = null;
                try {
                    if (value != null) {
                        switch (udfType) {
                            case BIGINT: 
                            case INT: 
                            case SMALLINT: 
                            case TINYINT: {
                                if (value instanceof Number) {
                                    valueStr = Long.toString(((Number)value).longValue());
                                    break;
                                }
                                valueStr = Long.toString(Long.parseLong(value.toString()));
                                break;
                            }
                            case BOOLEAN: {
                                if (value instanceof Boolean) {
                                    valueStr = Boolean.toString((Boolean)value);
                                    break;
                                }
                                valueStr = Boolean.toString(Boolean.parseBoolean(value.toString()));
                                break;
                            }
                            case DATE: {
                                valueStr = DKUtils.isoFormatReadableByDateFormat((long)isoFormatter.parseMillis(value.toString()));
                                break;
                            }
                            case STRING: {
                                valueStr = value.toString();
                                break;
                            }
                            case DOUBLE: 
                            case FLOAT: {
                                if (value instanceof Number) {
                                    valueStr = Double.toString(((Number)value).doubleValue());
                                    break;
                                }
                                valueStr = Double.toString(Double.parseDouble(value.toString()));
                                break;
                            }
                            case ARRAY: {
                                if (value instanceof List) {
                                    valueStr = JSON.json((Object)((List)value));
                                    break;
                                }
                                valueStr = JSON.json((Object)JSON.parse((String)value.toString(), List.class));
                                break;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    logger.warn((Object)("Failed to read the value with the user-specified type " + String.valueOf(udfType)));
                }
            }
            Metric metric = metricBuilder.build(keyValue.getKey(), valueType, probe);
            metricsValues.put(metric, valueStr);
        }
        return metricsValues;
    }

    public static class PythonMetricsEngineConfig {
    }

    public static class PythonProbeEngineRun
    extends MetricsEngineRun {
        public PythonProbeEngineRun() {
            super(MetricsEngineDesc.PythonEngine);
        }

        public PythonProbeEngineRun(double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.PythonEngine, cost, computations, pass);
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new PythonProbeEngineRun(cost, computations, this.pass);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            return false;
        }
    }
}

