/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend;

import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.exceptions.EngineNotAvailableException;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.sql.SQLPivotExecutor;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.pivot.frontend.model.ChartVariant;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.spark.SparkConfigurator;
import com.dataiku.dip.sql.ExasolSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SnowflakeSQLDialect;
import java.util.List;

public class EngineSelector {
    public static void checkEngineOK(AuthCtx authCtx, Dataset dataset, DSSConnection connection, List<ScriptStep> steps, SerializedShakerScript.ChartsEngine engine) throws Exception {
        if (engine == SerializedShakerScript.ChartsEngine.LINO) {
            return;
        }
        if (engine == SerializedShakerScript.ChartsEngine.SQL) {
            if (steps.size() > 0) {
                throw new EngineNotAvailableException("In-database engine not available with preparation");
            }
            SQLDialect dialect = SQLConnectionProvider.getConnectionDialectIfSQLOrNull(authCtx, dataset);
            if (SQLPivotExecutor.canHandleInput(connection, dialect)) {
                return;
            }
            if (dataset.getType().equals("JDBC")) {
                if (dialect instanceof SnowflakeSQLDialect || dialect instanceof ExasolSQLDialect) {
                    return;
                }
                throw new EngineNotAvailableException("In-database engine not available for this dataset kind");
            }
            if (DatasetInspector.isHDFSDatasetOrHiveTableDataset(dataset)) {
                if (ImpalaConfigurator.impalaAvailable(authCtx, dataset.getProjectKey())) {
                    return;
                }
                if (HiveConfigurator.hiveAvailableForCharts(authCtx, dataset.getProjectKey())) {
                    return;
                }
                throw new EngineNotAvailableException("Impala and Hive are not available");
            }
            throw new EngineNotAvailableException("In-database engine not available for this dataset kind");
        }
        if (engine == SerializedShakerScript.ChartsEngine.SPARKSQL) {
            SQLDialect dialect = SQLConnectionProvider.getConnectionDialectIfSQLOrNull(authCtx, dataset);
            if (!steps.isEmpty()) {
                throw new EngineNotAvailableException("Spark engine not available with preparation");
            }
            if (SQLPivotExecutor.canHandleInput(connection, dialect)) {
                throw new EngineNotAvailableException("Spark engine not available on SQL datasets");
            }
            if (!SparkConfigurator.interactiveSparkSQLAvailable(authCtx, dataset.getProjectKey())) {
                throw new EngineNotAvailableException("Spark not available");
            }
        }
    }

    public static void checkEngineOK(AuthCtx authCtx, Dataset dataset, DSSConnection connection, List<ScriptStep> steps, PivotTableRequest request, SerializedShakerScript.ChartsEngine engine) throws Exception {
        EngineSelector.checkEngineOK(authCtx, dataset, connection, steps, engine);
        if (engine == SerializedShakerScript.ChartsEngine.LINO) {
            return;
        }
        if (engine == SerializedShakerScript.ChartsEngine.SQL || engine == SerializedShakerScript.ChartsEngine.SPARKSQL) {
            switch (request.type) {
                case AGGREGATED_ND: {
                    if (!((PivotTableTensorRequest)request).hexbin) break;
                    throw new EngineNotAvailableException("In-database engine not available for hexagonal binning");
                }
                case AGGREGATED_GEO_ADMIN: 
                case AGGREGATED_GEO_GRID: 
                case SCATTER_NON_AGGREGATED: 
                case SCATTER_MULTIPLE_PAIRS_NON_AGGREGATED: 
                case BOXPLOTS: 
                case MAP_SCATTER_NON_AGGREGATED: 
                case DENSITY_2D: 
                case RAW_GEOMETRY: 
                case WEBAPP: {
                    throw new EngineNotAvailableException("In-database engine not available for this chart type");
                }
            }
        }
    }

    public static void checkEngineOK(AuthCtx authCtx, Dataset dataset, DSSConnection connection, List<ScriptStep> steps, ChartDef chartDef, SerializedShakerScript.ChartsEngine engine) throws Exception {
        EngineSelector.checkEngineOK(authCtx, dataset, connection, steps, engine);
        if (engine == SerializedShakerScript.ChartsEngine.LINO) {
            return;
        }
        if (engine == SerializedShakerScript.ChartsEngine.SQL || engine == SerializedShakerScript.ChartsEngine.SPARKSQL) {
            if (chartDef.filters != null) {
                for (ChartFilter filter : chartDef.filters) {
                    if (filter.filterType == ChartFilter.FilterType.EXPLICIT) {
                        throw new EngineNotAvailableException("In-database engine not available with explicit filters");
                    }
                    if (filter.filterType != ChartFilter.FilterType.ALPHANUM_FACET || filter.columnType != AxisDef.Type.NUMERICAL) continue;
                    throw new EngineNotAvailableException("In-database engine not available with 'num as alphanum' filters");
                }
            }
            if (chartDef.variant == ChartVariant.binned_xy_hex) {
                throw new EngineNotAvailableException("In-database engine not available for hexagonal binning");
            }
            switch (chartDef.type) {
                case admin_map: 
                case grid_map: 
                case scatter: 
                case scatter_multiple_pairs: 
                case boxplots: 
                case scatter_map: 
                case density_2d: 
                case geom_map: 
                case webapp: {
                    throw new EngineNotAvailableException("In-database engine not available for this chart type");
                }
            }
        }
    }

    public static class EngineWithReason {
        SerializedShakerScript.ChartsEngine engine;
        public String reason;

        EngineWithReason(SerializedShakerScript.ChartsEngine engine, String reason) {
            this.engine = engine;
            this.reason = reason;
        }
    }
}

