/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.datebinner;

import com.dataiku.dip.pivot.backend.common.automaticbin.TimeInterval;
import com.dataiku.dip.pivot.backend.common.datebinner.BinInterval;
import com.dataiku.dip.pivot.backend.common.datebinner.IDateBinner;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.DateAxisElt;
import com.dataiku.dip.pivot.backend.sql.queries.ColumnMapper;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.DKULogger;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractDateBinner
implements IDateBinner {
    public static final int DYNAMIC_NB_BINS = -1;
    static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.charts.datebinner");

    @Override
    public DateAxisElt buildDateAxisElt(@Nullable Long binId, @Nullable Long timestamp, int index) {
        long computedTimestamp;
        long computedBinId;
        if (binId == null && timestamp == null || binId != null && timestamp != null) {
            throw new IllegalStateException("Specify either 'binId' or 'timestamp'");
        }
        DateAxisElt elt = new DateAxisElt();
        if (binId == null) {
            computedBinId = this.getBinId(timestamp);
            computedTimestamp = timestamp;
        } else {
            computedBinId = binId;
            computedTimestamp = this.getBinStartTimestamp(binId);
        }
        elt.label = this.getLabel(computedBinId);
        elt.tsValue = computedTimestamp;
        elt.sortValue = computedBinId;
        elt.binIndex = index;
        return elt;
    }

    @Override
    public BinInterval getBinIntervalFromBinIds(TLongSet binIds) {
        BinInterval result = new BinInterval();
        int fixedNb = this.getFixedNbBins();
        if (fixedNb != -1) {
            logger.debugV("Fixed number of bins for date binner '%s': %s", new Object[]{this.getClass().getSimpleName(), fixedNb});
            return result.addBinId(0L).addBinId((long)fixedNb - 1L);
        }
        if (!binIds.isEmpty()) {
            result.addBinId(AbstractDateBinner.min(binIds)).addBinId(AbstractDateBinner.max(binIds));
        }
        logger.debugV("Dynamic number of bins for date binner '%s' with minBin %s and maxBin %s: %s", new Object[]{this.getClass().getSimpleName(), result.getMinBin(), result.getMaxBin(), result.getNbBins()});
        return result;
    }

    @Override
    public int getNbBinsFromTimeInterval(TimeInterval timeInterval) {
        return this.getBinIntervalFromBinIds(this.toBinIds(timeInterval.toTLongArrayList())).getNbBins();
    }

    @Override
    public List<AxisElt> getNaturallyOrderedAxisElementsFromBinIdRange(TLongSet binIdRange) {
        ArrayList<AxisElt> ret = new ArrayList<AxisElt>();
        BinInterval binInterval = this.getBinIntervalFromBinIds(binIdRange);
        int index = 0;
        for (long binId = binInterval.getMinBin(); binId <= binInterval.getMaxBin(); ++binId) {
            ret.add(this.buildDateAxisElt(binId, null, index++));
        }
        return ret;
    }

    @Override
    public ColumnMapper.TypedExpr binningSqlExpression(String input, SQLDialect dialect) {
        return new ColumnMapper.TypedExpr(this.buildExpression(input, dialect), ColumnMapper.ExprType.NUMBER);
    }

    String buildExpression(String input, SQLDialect dialect) {
        return dialect.datePartExpression(this.datePartExpression(input, dialect), this.datePart());
    }

    abstract DatePart datePart();

    abstract String datePartExpression(String var1, SQLDialect var2);

    private TLongSet toBinIds(TLongArrayList displayRange) {
        TLongHashSet binIds = new TLongHashSet();
        for (int i = 0; i < displayRange.size(); ++i) {
            binIds.add(this.getBinId(displayRange.get(i)));
        }
        return binIds;
    }

    private static long min(TLongSet set) {
        long minValue = Long.MAX_VALUE;
        TLongIterator iterator = set.iterator();
        while (iterator.hasNext()) {
            minValue = Math.min(minValue, iterator.next());
        }
        return minValue;
    }

    private static long max(TLongSet set) {
        long maxValue = Long.MIN_VALUE;
        TLongIterator iterator = set.iterator();
        while (iterator.hasNext()) {
            maxValue = Math.max(maxValue, iterator.next());
        }
        return maxValue;
    }
}

