/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.datebinner;

import com.dataiku.dip.pivot.backend.common.datebinner.AbstractDateBinner;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dss.shadelib.org.joda.time.Chronology;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeFieldType;
import com.dataiku.dss.shadelib.org.joda.time.chrono.GJChronology;

public abstract class AbstractGroupedBinner
extends AbstractDateBinner {
    abstract DateTimeFieldType timeField();

    abstract int offset();

    @Override
    public long getBinStartTimestamp(long binId) {
        return 0L;
    }

    @Override
    public long getBinEndTimestamp(long binId) {
        return 0L;
    }

    long getUnitValue(long timestamp) {
        return new DateTime(timestamp, (Chronology)GJChronology.getInstanceUTC()).get(this.timeField());
    }

    long getBinIdFromUnitValue(long numberOfUnits) {
        return numberOfUnits - (long)this.offset();
    }

    @Override
    public long getBinIdFromSqlValue(long sqlValue) {
        return this.getBinIdFromUnitValue(sqlValue);
    }

    @Override
    public long getSqlValueFromBinId(long binId) {
        return binId + (long)this.offset();
    }

    @Override
    String datePartExpression(String input, SQLDialect dialect) {
        return input;
    }

    @Override
    public boolean requireMaterializationForSqlEngine(boolean naturallyOrdered) {
        return !naturallyOrdered;
    }

    @Override
    public boolean requireJoinForSqlEngine() {
        return false;
    }
}

