/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.highcardinality;

import com.dataiku.dip.pivot.backend.common.automaticbin.ComputedBinningModes;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.NumericalAxisParams;
import com.dataiku.dip.pivot.backend.model.PivotTableAggregatedRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.backend.model.SecurityAbortedException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import java.util.Optional;
import java.util.stream.IntStream;

public class PostPruneSafetyChecks {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.pivot.dss");

    public static void checkSimple(int actual, int max) throws SecurityAbortedException {
        if (actual > max) {
            throw new SecurityAbortedException("Would need to draw %d objects, limit: %d", actual, max);
        }
    }

    public static void checkTensorResponse(PivotTableTensorRequest request, PivotTableTensorResponse response) throws SecurityAbortedException {
        PostPruneSafetyChecks.postPruneLimitCheck(request, response, null);
    }

    public static void checkComputedBinningModes(PivotTableTensorRequest request, ComputedBinningModes computedBinningModes) throws SecurityAbortedException {
        PostPruneSafetyChecks.postPruneLimitCheck(request, null, computedBinningModes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void postPruneLimitCheck(PivotTableTensorRequest request, PivotTableTensorResponse response, ComputedBinningModes computedBinningModes) {
        logger.info((Object)String.format("Checking post-prune limits %s against %s", JSON.json((Object)request.postPruneLimits), response == null ? "computed binning modes" : "tensor response"));
        for (PivotTableAggregatedRequest.PostPruneLimit ppl : request.postPruneLimits) {
            boolean isAggregationCheck;
            int[] axesToCheck = ppl.axesToCheck;
            boolean bl = isAggregationCheck = axesToCheck == null;
            if (isAggregationCheck) {
                axesToCheck = IntStream.range(0, request.axes.length).toArray();
            }
            long numElems = 1L;
            for (int axisIdx : axesToCheck) {
                int elementCountForAxis;
                if (response != null) {
                    elementCountForAxis = response.axisLabels[axisIdx].size();
                } else if (computedBinningModes != null) {
                    if (computedBinningModes.isEmpty()) return;
                    elementCountForAxis = PostPruneSafetyChecks.getElementCountForAxisForComputedBinningModes(request.axes[axisIdx], computedBinningModes, axisIdx);
                } else {
                    logger.infoV("Could not compute elementCountForAxis, skipping check", new Object[0]);
                    return;
                }
                logger.infoV("Count of drawable elements for axis named '%s' with index %s: %s", new Object[]{request.axes[axisIdx].column, axisIdx, elementCountForAxis});
                if (isAggregationCheck && axisIdx == 0) {
                    elementCountForAxis *= request.aggregations.size();
                }
                numElems *= (long)elementCountForAxis;
            }
            if (numElems <= (long)ppl.limit) continue;
            if (ppl.template == null) throw new SecurityAbortedException("Would need to draw %d objects, limit: %d", numElems, ppl.limit);
            throw new SecurityAbortedException(ppl.template, numElems, ppl.limit);
        }
    }

    public static int getElementCountForAxisForComputedBinningModes(AxisDef axisDef, ComputedBinningModes computedBinningModes, int axisIndex) {
        boolean isAlphanumWithMaxValues;
        boolean isFixedBinNumericalAxis;
        Optional<ComputedBinningModes.AxisComputedBinningMode> axisComputedBinningMode = computedBinningModes.getSafe(axisIndex);
        boolean isAutomaticAxis = axisComputedBinningMode.isPresent();
        if (isAutomaticAxis) {
            return axisComputedBinningMode.get().getNumberOfBin();
        }
        boolean bl = isFixedBinNumericalAxis = AxisDef.Type.NUMERICAL.equals((Object)axisDef.type) && NumericalAxisParams.BinningMode.FIXED_NB.equals((Object)axisDef.numParams.mode);
        if (isFixedBinNumericalAxis) {
            return axisDef.numParams.nbBins;
        }
        boolean bl2 = isAlphanumWithMaxValues = AxisDef.Type.ALPHANUM.equals((Object)axisDef.type) && axisDef.sortPrune.isMaxValuesDefined();
        if (isAlphanumWithMaxValues) {
            return (int)axisDef.sortPrune.maxValues;
        }
        logger.infoV("Could not compute count of element for configuration of axis %s with index %s", new Object[]{axisDef.column, axisIndex});
        return 1;
    }
}

