/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregator;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.set.hash.TDoubleHashSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.TreeMap;

public abstract class FlushableAggregatorImpl<T, U>
extends FlushableAggregator
implements FlushableAggregator.Visitor {
    private static final int DEFAULT_PASS_NUMBER = 250000;
    public final double[] data;
    private final long[] nonNullCounts;
    protected TreeMap<Integer, T> doubleStore;
    protected TreeMap<Integer, U> stringStore;
    protected T doubleValues;
    protected U stringValues;
    public boolean hasNullValues;

    public FlushableAggregatorImpl(double[] data, long[] nonNullCounts, String column, int passNumber) {
        super(column, passNumber, data.length);
        this.visitor = this;
        this.data = data;
        this.nonNullCounts = nonNullCounts;
    }

    public FlushableAggregatorImpl(double[] data, long[] nonNullCounts, String column) {
        this(data, nonNullCounts, column, ApplicationConfigurator.getParams().getIntParam("dku.aggregators.countd.flushPass", Integer.valueOf(250000)));
    }

    public boolean handle(double value, int loc) throws IOException {
        if (!Double.isFinite(value)) {
            this.hasNullValues = true;
            return false;
        }
        if (this.doubleStore == null) {
            this.doubleStore = new TreeMap();
            this.stringStore = null;
        }
        this.incrementNonNull(loc);
        if (this.needFlush()) {
            this.flushDoubleToDisk(this.doubleStore);
        }
        return true;
    }

    public boolean handle(Object value, int loc) throws IOException {
        if (value == null || value.toString().isEmpty()) {
            this.hasNullValues = true;
            return false;
        }
        if (this.stringStore == null) {
            this.stringStore = new TreeMap();
            this.doubleStore = null;
        }
        this.incrementNonNull(loc);
        if (this.needFlush()) {
            this.flushStringToDisk(this.stringStore);
        }
        return true;
    }

    public void onEnd() throws IOException {
        this.onEnd(true);
    }

    public void onEnd(boolean storeLocation) throws IOException {
        ColumnBlock.MemoryType memoryType = this.memType = this.stringStore != null ? ColumnBlock.MemoryType.STRING : ColumnBlock.MemoryType.DOUBLE;
        if (this.hasBeenFlushed()) {
            if (this.stringStore != null) {
                this.flushStringToDisk(this.stringStore);
            } else {
                this.flushDoubleToDisk(this.doubleStore);
            }
            boolean readAsString = this.stringStore != null;
            this.stringStore = null;
            this.doubleStore = null;
            this.readValues(readAsString, storeLocation);
        }
    }

    public double merge(int destination, Object values) throws IOException {
        block4: {
            block5: {
                block3: {
                    if (!(values instanceof TDoubleHashSet)) break block3;
                    TDoubleIterator iterator = ((TDoubleHashSet)values).iterator();
                    while (iterator.hasNext()) {
                        this.handle(iterator.next(), destination);
                    }
                    break block4;
                }
                if (!(values instanceof TDoubleArrayList)) break block5;
                TDoubleIterator iterator = ((TDoubleArrayList)values).iterator();
                while (iterator.hasNext()) {
                    this.handle(iterator.next(), destination);
                }
                break block4;
            }
            if (!(values instanceof HashSet)) break block4;
            for (String value : (HashSet)values) {
                this.handle(value, destination);
            }
        }
        return this.data[destination];
    }

    protected void incrementNonNull(int loc) {
        if (this.nonNullCounts != null) {
            int n = loc;
            this.nonNullCounts[n] = this.nonNullCounts[n] + 1L;
        }
    }

    @Override
    protected boolean isLocationEmpty(int loc) {
        return this.data[loc] == 0.0;
    }

    @Override
    public void beginRead(int location, int length) {
        this.doubleValues = null;
        this.stringValues = null;
    }
}

