/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.apps;

import com.dataiku.common.stereotype.PartOfPublicAPI;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSStartedEvent;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.coremodel.AppHomepageTile;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.git.IProjectCommitModeService;
import com.dataiku.dip.plugins.model.AppTemplateSettings;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.projects.apps.CustomAppTemplatesService;
import com.dataiku.dip.projects.apps.LoadedCustomAppTemplate;
import com.dataiku.dip.projects.importexport.CommonBundleUtils;
import com.dataiku.dip.projects.importexport.ProjectExporter;
import com.dataiku.dip.projects.importexport.ProjectImporter;
import com.dataiku.dip.projects.importexport.ProjectImporterBase;
import com.dataiku.dip.projects.importexport.model.ActiveBundleState;
import com.dataiku.dip.projects.importexport.model.ProjectExportOptions;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.fromapp.AppRecipeMeta;
import com.dataiku.dip.recipes.fromapp.LoadedAppRecipeDesc;
import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.controllers.ProjectImportExportController;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ImageService;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesInternalDB;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.exceptions.TransactionContextError;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Pair;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class AppsService
implements ApplicationListener<DSSStartedEvent> {
    public static final String PROJECT_RANDOM_KEY = "projectRandomKey";
    public static final String APPLICATION_ID_PREFIX = "PROJECT_";
    public static final String PLUGIN_ID_PREFIX = "PLUGIN_";
    private static final String TEST_INSTANCE_SHORT_DESCRIPTION = "Test instance generated from app designer";
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private TimelinesInternalDB timelinesDAO;
    @Autowired
    private FutureService futureService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private ImageService imageService;
    @Autowired
    private CustomAppTemplatesService customAppTemplatesService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private ProjectFoldersService projectFoldersService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private RequestsService requestsService;
    @Autowired
    private ProjectsJGitService projectsGitService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.apps.service");

    public static Privileges.ProjectLevelPrivilegeType minimumPermissionForAppDesigner() {
        return ApplicationConfigurator.getParams().getBoolParam("dku.apps.designer.requireProjectAdmin", true) ? Privileges.ProjectLevelPrivilegeType.ADMIN : Privileges.ProjectLevelPrivilegeType.WRITE_CONF;
    }

    public AppImageInfo getAppImageInfo(AppManifest manifest) throws IOException {
        String appId = manifest.id;
        AppImageInfo appImageInfo = new AppImageInfo();
        appImageInfo.objectImgHash = this.imageService.getOriginalImgHash(null, "APP", appId);
        boolean bl = appImageInfo.isAppImg = appImageInfo.objectImgHash != 0L;
        if (!appImageInfo.isAppImg) {
            appImageInfo.objectImgHash = this.imageService.generateNewImgHash(null, "APP", appId);
        }
        appImageInfo.defaultImgColor = this.imageService.generateProjectColorAsHex(appId);
        appImageInfo.imgColor = manifest.imgColor;
        appImageInfo.imgPattern = manifest.imgPattern != null ? manifest.imgPattern : this.imageService.generateProjectPattern(appId);
        appImageInfo.showInitials = manifest.showInitials;
        return appImageInfo;
    }

    public void onApplicationEvent(DSSStartedEvent dssStartedEvent) {
        try {
            for (AppListItem ali : this.listAppTemplates_NT((AuthCtx)DSSAuthCtx.newNone()).items) {
                try {
                    AppManifest am = this.getAppTemplateManifest_NT(ali.appId);
                    if (ali.origin != AppOrigin.PROJECT || am.useAsRecipeSettings == null) continue;
                    logger.info((Object)("Registering recipe-app " + ali.appId));
                    AppRecipeMeta arm = new AppRecipeMeta(ali.appId, am);
                    RecipeRegistry.register(arm);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to register recipe-app", (Throwable)e);
                }
            }
        }
        catch (DKUSecurityException | IOException e) {
            logger.error((Object)"Failed to init apps service", e);
        }
    }

    public List<LoadedAppRecipeDesc> listAppRecipeDescs(AuthCtx authCtx) throws IOException, DKUSecurityException {
        ArrayList<LoadedAppRecipeDesc> ret = new ArrayList<LoadedAppRecipeDesc>();
        for (AppListItem ali : this.listAppTemplates_T((AuthCtx)DSSAuthCtx.newNone()).items) {
            try {
                AppManifest am = this.getAppTemplateManifestUnsafe_T(ali.appId);
                if (am.useAsRecipeSettings == null) continue;
                logger.info((Object)("Registering recipe-app " + ali.appId));
                LoadedAppRecipeDesc desc = new LoadedAppRecipeDesc();
                desc.label = am.label;
                desc.icon = am.useAsRecipeSettings.icon;
                desc.category = am.useAsRecipeSettings.category;
                desc.variablesEditionTile = am.useAsRecipeSettings.variablesEditionTile != null ? am.useAsRecipeSettings.variablesEditionTile : new AppHomepageTile.ProjectVariablesTile();
                desc.recipeType = "App_" + ali.appId;
                if (AppOrigin.fromAppId(ali.appId) == AppOrigin.PLUGIN) {
                    logger.debugV("App-as-recipe '%s' is defined by a plugin. Ensuring visibility settings are enforced.'", new Object[]{ali.appId});
                    String pluginId = this.customAppTemplatesService.getOwnerPluginId(ali.appId);
                    if (pluginId == null) {
                        logger.debugV("Unable to find the owner plugin id for app-as-recipe '%s'", new Object[]{ali.appId});
                    } else {
                        try {
                            desc.hideComponent = authCtx != null && authCtx.getAuthSource() == AuthCtx.AuthSource.USER_FROM_UI && !this.permissionsService.hasPluginPrivilege(authCtx, pluginId, Privileges.PluginLevelPrivilegeType.COMPONENTS_VIEWER);
                        }
                        catch (DKUSecurityException | Error e) {
                            desc.hideComponent = false;
                        }
                    }
                } else {
                    desc.hideComponent = false;
                }
                ret.add(desc);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to register recipe-app", (Throwable)e);
            }
        }
        return ret;
    }

    public List<AppManifest> listRecipeAppManifests_T() throws TransactionContextError, IOException, DKUSecurityException {
        return this.internalListAppTemplates_T(null, false).toRecipeAppManifests();
    }

    private boolean isActiveAppTemplate(TransactionRef t, SerializedProject sp) throws TransactionContextError, IOException {
        return sp.projectAppType == SerializedProject.ProjectAppType.APP_TEMPLATE && (sp.projectType == SerializedProject.ProjectType.REGULAR || CommonBundleUtils.hasActiveBundleInternal(t, sp.projectKey));
    }

    public AppImageInfo getAppFullImageInfo(AppManifest manifest) throws IOException {
        String appId = manifest.id;
        AppImageInfo appImageInfo = new AppImageInfo();
        appImageInfo.objectImgHash = this.imageService.getOriginalImgHash(null, "APPFULL", appId);
        return appImageInfo;
    }

    public AppsList listAppTemplates_NT(AuthCtx authCtx) throws IOException, DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AppsList appsList = this.listAppTemplates_T(authCtx);
            return appsList;
        }
    }

    private AppManifest getPluginAppManifest(String type) throws IOException {
        File archiveFile = this.customAppTemplatesService.getProjectArchive(type);
        if (!archiveFile.exists()) {
            logger.error((Object)("Project archive for plugin app " + type + " not found : " + String.valueOf(archiveFile)));
            return null;
        }
        try (ZipFile archive = new ZipFile(archiveFile);){
            ZipEntry appManifestEntry = archive.getEntry("project_config/app-manifest.json");
            if (appManifestEntry == null) {
                logger.error((Object)("App manifest missing from plugin app's project archive : " + type));
                AppManifest appManifest = null;
                return appManifest;
            }
            AppManifest appManifest = this.enrichWithPluginInfo(type, (AppManifest)JSON.parse((InputStream)archive.getInputStream(appManifestEntry), AppManifest.class));
            return appManifest;
        }
    }

    private AppManifest enrichWithPluginInfo(String type, AppManifest manifest) {
        LoadedCustomAppTemplate customAppTemplate = (LoadedCustomAppTemplate)this.customAppTemplatesService.getLoadedDescByElementType(type);
        manifest.id = type;
        if (customAppTemplate.desc != null && customAppTemplate.desc.meta != null) {
            if (StringUtils.isNotEmpty((String)customAppTemplate.desc.meta.label)) {
                manifest.label = customAppTemplate.desc.meta.label;
            }
            if (manifest.useAsRecipeSettings != null) {
                if (StringUtils.isNotEmpty((String)customAppTemplate.desc.meta.icon)) {
                    manifest.useAsRecipeSettings.icon = customAppTemplate.desc.meta.icon;
                }
                if (StringUtils.isNotEmpty((String)customAppTemplate.desc.meta.category)) {
                    manifest.useAsRecipeSettings.category = customAppTemplate.desc.meta.category;
                }
            }
        }
        return manifest;
    }

    private AppListItemWithManifest buildAppListItemWithManifest(AppManifest manifest, AppOrigin origin) {
        AppListItem ali = new AppListItem();
        ali.appId = manifest.id;
        ali.appVersion = "N/A";
        ali.label = manifest.label;
        ali.shortDesc = manifest.shortDesc;
        ali.description = manifest.description;
        ali.tags = manifest.tags;
        ali.useAsRecipe = manifest.useAsRecipeSettings != null;
        ali.origin = origin;
        try {
            AppImageInfo imageInfo = this.getAppImageInfo(manifest);
            ali.objectImgHash = imageInfo.objectImgHash;
            ali.isAppImg = imageInfo.isAppImg;
            ali.imgColor = imageInfo.imgColor;
            ali.defaultImgColor = imageInfo.defaultImgColor;
            ali.imgPattern = imageInfo.imgPattern;
            ali.showInitials = imageInfo.showInitials;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get app image hash", (Throwable)e);
        }
        return new AppListItemWithManifest(manifest, ali);
    }

    public List<String> listAppIds_T() throws IOException, DKUSecurityException {
        ArrayList appIds = Lists.newArrayList();
        TransactionRef t = TransactionContext.retrieveRead();
        for (SerializedProject sp : this.projectsService.listAllUnsafe()) {
            if (!this.isActiveAppTemplate(t, sp)) continue;
            appIds.add(AppsService.buildApplicationId(sp.projectKey));
        }
        for (LoadedCustomAppTemplate customAppTemplate : this.customAppTemplatesService.list()) {
            appIds.add(customAppTemplate.getType());
        }
        return appIds;
    }

    public AppsList listAppTemplates_T(AuthCtx authCtx) throws IOException, DKUSecurityException {
        return this.listAppTemplates_T(authCtx, false, true);
    }

    public AppsList listAppTemplates_T(AuthCtx authCtx, boolean includeLimitedVisibility, boolean includeAppsAsRecipe) throws IOException, DKUSecurityException {
        AppsList ret = this.internalListAppTemplates_T(authCtx, includeLimitedVisibility).toAppsList();
        if (!includeAppsAsRecipe) {
            ret.items.removeIf(item -> item.useAsRecipe);
        }
        HashMap instanceCounts = Maps.newHashMap();
        HashMap instanceOwners = Maps.newHashMap();
        HashMap instanceLastInstantiations = Maps.newHashMap();
        for (SerializedProject sp : this.projectsService.listAllUnsafe()) {
            if (sp.projectAppType != SerializedProject.ProjectAppType.APP_INSTANCE || !StringUtils.isNotBlank((String)sp.generatingAppId)) continue;
            String appId = sp.generatingAppId;
            if (instanceCounts.containsKey(appId)) {
                instanceCounts.put(appId, (Integer)instanceCounts.get(appId) + 1);
            } else {
                instanceCounts.put(appId, 1);
            }
            if (!instanceOwners.containsKey(appId)) {
                instanceOwners.put(appId, new HashSet());
            }
            ((Set)instanceOwners.get(appId)).add(sp.owner);
            if (sp.creationTag == null) continue;
            long creationTime = sp.creationTag.getLastModifiedOn();
            if (instanceLastInstantiations.getOrDefault(appId, 0L) >= creationTime) continue;
            instanceLastInstantiations.put(appId, creationTime);
        }
        for (AppListItem app : ret.items) {
            if (app.onlyLimitedVisibility) continue;
            app.instanceCount = instanceCounts.getOrDefault(app.appId, 0);
            app.lastInstantiation = instanceLastInstantiations.getOrDefault(app.appId, 0L);
            Set owners = instanceOwners.getOrDefault(app.appId, new HashSet());
            app.instanceOwners = Lists.newArrayList();
            for (String login : owners) {
                try {
                    app.instanceOwners.add(this.usersService.getPublicUser(login));
                }
                catch (Exception exception) {}
            }
        }
        return ret;
    }

    public AppsList enrichAppListWithHomepageInfo_NT(AuthCtx authCtx, AppsList baseList) throws IOException, DKUSecurityException {
        HashMap<String, List> visibleInstancesMap = new HashMap<String, List>();
        try (Transaction t = this.transactionService.beginRead();){
            for (SerializedProject sp : this.projectsService.listAllUnsafe()) {
                if (sp.projectAppType != SerializedProject.ProjectAppType.APP_INSTANCE || !StringUtils.isNotBlank((String)sp.generatingAppId)) continue;
                String appId = sp.generatingAppId;
                if (!this.permissionsService.hasProjectPrivilege(authCtx, sp, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
                visibleInstancesMap.computeIfAbsent(appId, k -> new ArrayList()).add(sp.projectKey);
            }
        }
        TimelinesService timelinesService = (TimelinesService)SpringUtils.getBean(TimelinesService.class);
        baseList.items = baseList.items.stream().map(item -> {
            if (item.onlyLimitedVisibility) {
                return item;
            }
            List visibleInstances = visibleInstancesMap.getOrDefault(item.appId, Collections.emptyList());
            long lastCommit = -1L;
            long lastCommitByMe = -1L;
            for (String projectKey : visibleInstances) {
                Pair<TimelineItem, TimelineItem> lastCommitInfo = timelinesService.getLatestForProjectAndLatestForProjectAndUser(projectKey, authCtx.getIdentifier());
                lastCommit = Math.max(lastCommit, lastCommitInfo.first == null ? -1L : ((TimelineItem)lastCommitInfo.first).time);
                lastCommitByMe = Math.max(lastCommitByMe, lastCommitInfo.second == null ? -1L : ((TimelineItem)lastCommitInfo.second).time);
            }
            return new AppListItemWithHomepageInfo((AppListItem)item, visibleInstances.size(), lastCommit, lastCommitByMe);
        }).collect(Collectors.toList());
        return baseList;
    }

    private AppListWithManifest internalListAppTemplates_T(@Nullable AuthCtx authCtx, boolean includeLimitedVisibility) throws IOException, DKUSecurityException {
        AppManifest manifest;
        AppListWithManifest ret = new AppListWithManifest();
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        TransactionRef t = TransactionContext.retrieveRead();
        for (SerializedProject sp : this.projectsService.listAllUnsafe()) {
            if (!this.isActiveAppTemplate(t, sp)) continue;
            try {
                manifest = this.getManifestFromProjectUnsafe(t, sp.projectKey);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to load app manifest of " + sp.projectKey), (Throwable)e);
                continue;
            }
            boolean cannotExecuteApp = this.cannotExecuteApp(authCtx, manifest, sp);
            if (cannotExecuteApp && (!includeLimitedVisibility || !this.isVisible(manifest, gs))) continue;
            manifest.id = AppsService.buildApplicationId(sp.projectKey);
            AppListItemWithManifest item = this.buildAppListItemWithManifest(manifest, AppOrigin.PROJECT).withOriginProjectKey(sp.projectKey);
            item.appListItem.onlyLimitedVisibility = cannotExecuteApp;
            item.appListItem.canRequestAccess = this.isAccessRequestsEnabled(manifest, gs);
            ret.add(item);
        }
        for (LoadedCustomAppTemplate customAppTemplate : this.customAppTemplatesService.list()) {
            try {
                manifest = this.getPluginAppManifest(customAppTemplate.getType());
                if (manifest == null) continue;
                ret.add(this.buildAppListItemWithManifest(manifest, AppOrigin.PLUGIN));
            }
            catch (IllegalArgumentException e) {
                logger.warnV((Throwable)e, "Unable to get plugin app manifest for %s, maybe plugin was deleted?", new Object[]{customAppTemplate.getType()});
            }
        }
        return ret;
    }

    public boolean cannotExecuteApp(@Nullable AuthCtx authCtx, AppManifest manifest, SerializedProject sp) throws DKUSecurityException {
        return authCtx != null && authCtx.getAuthSource() != AuthCtx.AuthSource.NONE && manifest.instantiationPermission != AppManifest.AppInstantiationPermission.EVERYBODY && !this.permissionsService.hasProjectPrivilege(authCtx, sp, Privileges.ProjectLevelPrivilegeType.EXECUTE_APP);
    }

    public boolean isAppTemplateVisible(@Nullable AuthCtx authCtx, AppManifest manifest, boolean includeLimitedVisibility, GeneralSettingsDAO.GeneralSettings generalSettings, SerializedProject sp) throws DKUSecurityException {
        return !this.cannotExecuteApp(authCtx, manifest, sp) || includeLimitedVisibility && this.isVisible(manifest, generalSettings);
    }

    public AppsList listAppInstances_T(AuthCtx authCtx) throws IOException, DKUSecurityException {
        AppsList ret = new AppsList();
        TransactionRef t = TransactionContext.retrieveRead();
        for (SerializedProject sp : this.projectsService.listAllUnsafe()) {
            AppManifest manifest;
            if (sp.projectAppType != SerializedProject.ProjectAppType.APP_INSTANCE) continue;
            if (StringUtils.isBlank((String)sp.generatingAppId)) {
                logger.warn((Object)("Project " + sp.projectKey + " is of app type APP_INSTANCE but has no generatingAppId, skipping"));
                continue;
            }
            if (!this.permissionsService.hasAnyProjectAccess(authCtx, sp.projectKey)) continue;
            try {
                manifest = this.getManifestFromProjectUnsafe(t, sp.projectKey);
            }
            catch (Exception e) {
                logger.error((Object)("Unable to load app manifest of " + sp.projectKey), (Throwable)e);
                continue;
            }
            manifest.id = sp.generatingAppId;
            AppListItem ali = new AppListItem();
            ali.appId = sp.generatingAppId;
            ali.appVersion = sp.generatingAppVersion;
            ali.label = manifest.label;
            ali.shortDesc = manifest.shortDesc;
            ali.description = manifest.description;
            ali.tags = manifest.tags;
            ali.origin = AppOrigin.fromAppId(sp.generatingAppId);
            boolean bl = ali.useAsRecipe = manifest.useAsRecipeSettings != null;
            if (ali.origin == AppOrigin.PROJECT) {
                ali.originProjectKey = AppsService.getProjectKey(sp.generatingAppId);
            }
            try {
                AppImageInfo imageInfo = this.getAppImageInfo(manifest);
                ali.objectImgHash = imageInfo.objectImgHash;
                ali.isAppImg = imageInfo.isAppImg;
                ali.imgColor = imageInfo.imgColor;
                ali.defaultImgColor = imageInfo.defaultImgColor;
                ali.imgPattern = imageInfo.imgPattern;
                ali.showInitials = imageInfo.showInitials;
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get app image hash", (Throwable)e);
            }
            ret.items.add(ali);
        }
        return ret;
    }

    public String getTestInstance_T(AuthCtx authCtx, String appId) throws IOException, DKUSecurityException {
        for (SerializedProject sp : this.projectsService.listAllUnsafe()) {
            if (sp.projectAppType != SerializedProject.ProjectAppType.APP_INSTANCE || StringUtils.isBlank((String)sp.generatingAppId) || !StringUtils.equals((String)sp.generatingAppId, (String)appId) || !StringUtils.equals((String)sp.owner, (String)authCtx.getAssociatedDSSUserMand()) || !TEST_INSTANCE_SHORT_DESCRIPTION.equals(sp.shortDesc)) continue;
            return sp.projectKey;
        }
        return "";
    }

    public AppTemplatePageData getAppTemplatePageData_NT(AuthCtx authCtx, String appId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AppTemplatePageData appTemplatePageData = this.getAppTemplatePageData_T(authCtx, appId);
            return appTemplatePageData;
        }
    }

    public AppTemplatePageData getAppTemplatePageData_T(AuthCtx authCtx, String appId) throws Exception {
        AppTemplatePageData ret = new AppTemplatePageData();
        ret.appId = appId;
        ret.appVersion = "N/A";
        ret.manifest = this.getAppTemplateManifest_T(appId);
        ret.useAsRecipe = ret.manifest.useAsRecipeSettings != null;
        this.enrichAppTemplateData(authCtx, appId, ret);
        for (SerializedProject sp : this.projectsService.listAllUnsafe()) {
            ProjectsService.HomepageProjectItem hp;
            if (sp.projectAppType != SerializedProject.ProjectAppType.APP_INSTANCE || !appId.equals(sp.generatingAppId) || (hp = this.projectsService.getProjectItemWithReadPermissionCheckFromProject(authCtx, sp, false, true)) == null) continue;
            ret.instances.add(hp);
        }
        return ret;
    }

    public AppTemplateInstanceData getAppInstanceData_T(AuthCtx authCtx, String projectKey) throws Exception {
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
        AppTemplateInstanceData ret = new AppTemplateInstanceData();
        ret.appId = sp.generatingAppId;
        ret.appVersion = sp.generatingAppVersion;
        ret.manifest = this.getAppInstanceManifestForProject_T(authCtx, projectKey);
        ret.useAsRecipe = ret.manifest.useAsRecipeSettings != null;
        this.enrichAppTemplateData(authCtx, ret.appId, ret);
        AppOrigin origin = AppOrigin.fromAppId(ret.appId);
        if (origin == AppOrigin.PROJECT) {
            String originalProjectKey = AppsService.getProjectKey(ret.appId);
            ret.originExists = this.projectsService.projectExists(originalProjectKey);
            if (ret.originExists) {
                try {
                    AppManifest originManifest = this.getAppTemplateManifestForProject_T(originalProjectKey);
                    if (originManifest != null) {
                        ret.templateVersion = originManifest.version;
                        ret.templateVersionNotes = originManifest.versionNotes;
                        ret.obsolete = !StringUtils.isBlank((String)originManifest.version) && !originManifest.version.equals(ret.manifest.version) && ret.manifest != null && (StringUtils.isBlank((String)ret.manifest.instanceSkippedVersion) || !ret.manifest.instanceSkippedVersion.equals(originManifest.version));
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to retrieve version of the application template", (Throwable)e);
                }
            }
        } else if (origin == AppOrigin.PLUGIN) {
            ret.originExists = this.customAppTemplatesService.getLoadedDescByElementType(ret.appId) != null;
        }
        return ret;
    }

    private void enrichAppTemplateData(AuthCtx authCtx, String appId, AppTemplateData ret) {
        AppImageInfo imageInfo;
        ret.origin = AppOrigin.fromAppId(appId);
        if (ret.origin == AppOrigin.PROJECT) {
            ret.originProjectKey = AppsService.getProjectKey(ret.appId);
            try {
                ret.canAdminOriginProjectKey = this.permissionsService.hasProjectPrivilege(authCtx, ret.originProjectKey, AppsService.minimumPermissionForAppDesigner());
            }
            catch (Exception e) {
                logger.warn((Object)"Cannot check if user can edit app template, project may not exist anymore", (Throwable)e);
            }
        }
        ret.label = ret.manifest.label;
        ret.shortDesc = ret.manifest.shortDesc;
        ret.description = ret.manifest.description;
        ret.tags = ret.manifest.tags;
        try {
            imageInfo = this.getAppImageInfo(ret.manifest);
            ret.objectImgHash = imageInfo.objectImgHash;
            ret.isAppImg = imageInfo.isAppImg;
            ret.imgColor = imageInfo.imgColor;
            ret.defaultImgColor = imageInfo.defaultImgColor;
            ret.imgPattern = imageInfo.imgPattern;
            ret.showInitials = imageInfo.showInitials;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get app image hash", (Throwable)e);
        }
        try {
            imageInfo = this.getAppFullImageInfo(ret.manifest);
            ret.objectFullImgHash = imageInfo.objectImgHash;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get app full image hash", (Throwable)e);
        }
    }

    public boolean isVisible(AppManifest manifest, GeneralSettingsDAO.GeneralSettings generalSettings) {
        return generalSettings.appVisibility.visibilityMode.resolveLocalSetting(manifest.limitedVisibilityEnabled);
    }

    public boolean isAccessRequestsEnabled(AppManifest manifest, GeneralSettingsDAO.GeneralSettings generalSettings) {
        return generalSettings.appVisibility.accessRequestsMode.resolveLocalSetting(manifest.accessRequestsEnabled);
    }

    public void checkEditPerm(AuthCtx authCtx, String appId) throws DKUSecurityException {
        switch (AppOrigin.fromAppId(appId)) {
            case PROJECT: {
                String projectKey = AppsService.getProjectKey(appId);
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                break;
            }
            case PLUGIN: {
                throw new NotImplementedException();
            }
        }
    }

    public boolean hasAppInstantiatePerm_T(AuthCtx authCtx, AppManifest manifest) throws IOException, DKUSecurityException {
        if (manifest.instantiationPermission == AppManifest.AppInstantiationPermission.EVERYBODY) {
            return true;
        }
        switch (AppOrigin.fromAppId(manifest.id)) {
            case PROJECT: {
                String originProjectKey = AppsService.getProjectKey(manifest.id);
                SerializedProject sp = this.projectsService.getMandatoryUnsafe(originProjectKey);
                return this.permissionsService.hasProjectPrivilege(authCtx, sp, Privileges.ProjectLevelPrivilegeType.EXECUTE_APP);
            }
            case PLUGIN: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unable to determine app origin from appId: " + manifest.id);
    }

    public void checkAppInstantiatePerm_T(AuthCtx authCtx, AppManifest manifest) throws IOException, DKUSecurityException {
        if (!this.hasAppInstantiatePerm_T(authCtx, manifest)) {
            throw new DKUSecurityException("User not allowed to instantiate app");
        }
    }

    public void checkAppInstantiatePerm_T(AuthCtx authCtx, String appId) throws IOException, DKUSecurityException {
        AppManifest manifest = this.getAppTemplateManifest_T(appId);
        this.checkAppInstantiatePerm_T(authCtx, manifest);
    }

    public AppManifest getAppTemplateManifest_NT(String appId) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AppManifest appManifest = this.getAppTemplateManifest_T(appId);
            return appManifest;
        }
    }

    public AppManifest getAppTemplateManifest_T(String appId) throws IOException {
        return this.getAppTemplateManifest_T(appId, false);
    }

    public AppManifest getAppTemplateManifestUnsafe_T(String appId) throws IOException {
        return this.getAppTemplateManifest_T(appId, true);
    }

    private AppManifest getAppTemplateManifest_T(String appId, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        switch (AppOrigin.fromAppId(appId)) {
            case PROJECT: {
                String templateProjectKey = AppsService.getProjectKey(appId);
                SerializedProject sp = this.projectsService.getOrNullUnsafe(templateProjectKey);
                if (sp == null) {
                    throw new NotFoundException("The project " + templateProjectKey + " providing the app template doesn't exist");
                }
                if (sp.projectAppType != SerializedProject.ProjectAppType.APP_TEMPLATE) {
                    throw new IllegalArgumentException("The project " + templateProjectKey + " is not an app template");
                }
                RelFile manifestFile = new RelFile(new String[]{"projects", sp.projectKey, "app-manifest.json"});
                AppManifest manifest = unsafe ? (AppManifest)t.readObjectUnsafe(manifestFile, AppManifest.class) : (AppManifest)t.readObject(manifestFile, AppManifest.class);
                manifest.id = appId;
                return manifest;
            }
            case PLUGIN: {
                return this.getPluginAppManifest(appId);
            }
        }
        throw new IllegalStateException("AppId not recognized: " + appId);
    }

    public AppManifest getAppTemplateManifestForProject_NT(String projectKey) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AppManifest appManifest = this.getAppTemplateManifestForProject_T(projectKey);
            return appManifest;
        }
    }

    private boolean hasManifest(SerializedProject sp) {
        return sp.projectAppType == SerializedProject.ProjectAppType.APP_TEMPLATE || sp.hasSetupSection;
    }

    public AppManifest getAppTemplateManifestForProject_T(String projectKey) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
        assert (this.hasManifest(sp));
        AppManifest manifest = (AppManifest)t.readObject(new RelFile(new String[]{"projects", sp.projectKey, "app-manifest.json"}), AppManifest.class);
        manifest.id = AppsService.buildApplicationId(projectKey);
        return manifest;
    }

    public AppManifest getAppTemplateManifestOrNullForProject_T(String projectKey) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        SerializedProject sp = this.projectsService.getOrNullUnsafe(projectKey);
        if (sp == null || !SerializedProject.ProjectAppType.APP_TEMPLATE.equals((Object)sp.projectAppType)) {
            return null;
        }
        AppManifest manifest = (AppManifest)t.readObject(new RelFile(new String[]{"projects", sp.projectKey, "app-manifest.json"}), AppManifest.class);
        manifest.id = AppsService.buildApplicationId(projectKey);
        return manifest;
    }

    public boolean hasAppTemplateManifestFile_T(String projectKey) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile manifestFile = new RelFile(new String[]{"projects", projectKey, "app-manifest.json"});
        return t.isFile(manifestFile);
    }

    public AppManifest getAppInstanceManifestForProject_NT(AuthCtx authCtx, String projectKey) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AppManifest appManifest = this.getAppInstanceManifestForProject_T(authCtx, projectKey);
            return appManifest;
        }
    }

    public AppManifest getAppInstanceManifestForProject_T(AuthCtx authCtx, String projectKey) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
        assert (sp.projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE || sp.hasSetupSection);
        AppManifest manifest = (AppManifest)t.readObject(new RelFile(new String[]{"projects", sp.projectKey, "app-manifest.json"}), AppManifest.class);
        manifest.id = sp.generatingAppId;
        return manifest;
    }

    public void saveAppTemplateManifestForProject(String projectKey, AppManifest appManifest) throws IOException, DKUSecurityException {
        this.saveAppTemplateManifestForProject(projectKey, appManifest, false);
    }

    public void saveAppTemplateManifestForProject(String projectKey, AppManifest appManifest, boolean isFromTrustedSource) throws IOException, DKUSecurityException {
        RWTransactionRef rwt = TransactionContext.retrieveWrite();
        if (!isFromTrustedSource && !((DSSAuthCtx)rwt.getUser()).getPermissions().mayDevelopPlugins()) {
            for (AppManifest.AppHomepageSection section : appManifest.homepageSections) {
                for (AppHomepageTile tile : section.tiles) {
                    if (!(tile instanceof AppHomepageTile.ProjectVariablesTile)) continue;
                    AppHomepageTile.ProjectVariablesTile typedTile = (AppHomepageTile.ProjectVariablesTile)tile;
                    if (!StringUtils.isNotBlank((String)typedTile.js) && !StringUtils.isNotBlank((String)typedTile.python)) continue;
                    throw new DKUSecurityException("Using a custom UI in a 'edit project variables' tile requires at least 'may develop plugins' permission");
                }
            }
        }
        rwt.writeObject(new RelFile(new String[]{"projects", projectKey, "app-manifest.json"}), (Object)appManifest);
        if (AppManifest.AppInstantiationPermission.EVERYBODY == appManifest.instantiationPermission) {
            rwt.onPostCommit(() -> {
                try {
                    this.requestsService.approveRequestsForApplication_NT(projectKey, appManifest.id);
                }
                catch (SQLException e) {
                    logger.warn((Object)("Failed to close related requests for application " + projectKey), (Throwable)e);
                }
            });
        }
        logger.info((Object)("Saving App Template manifest " + JSON.json((Object)appManifest)));
        String appId = AppsService.buildApplicationId(projectKey);
        AppRecipeMeta arm = new AppRecipeMeta(appId, appManifest);
        if (appManifest.useAsRecipeSettings != null) {
            logger.info((Object)("Updating app-recipe " + appId));
            RecipeRegistry.register(arm);
        } else {
            logger.info((Object)("Updating app-recipe " + appId));
            RecipeRegistry.deregister(arm);
        }
    }

    public void appTemplatify_T(SerializedProject sp) throws IOException, DKUSecurityException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        if (!t.exists(new RelFile(new String[]{"projects", sp.projectKey, "app-manifest.json"}))) {
            AppManifest manifest = new AppManifest();
            manifest.label = sp.name;
            manifest.shortDesc = String.format("The template *%s* was created by %s on %s", sp.name.replace("*", ""), this.usersService.getPublicUser((String)t.getUser().getAssociatedDSSUser()).displayName, ProjectsService.getDateForShortDesc());
            this.saveAppTemplateManifestForProject(sp.projectKey, manifest);
        }
    }

    public void appTemplatify_T(SerializedProject sp, ManifestCreationSettings settings) throws IOException, DKUSecurityException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AppManifest manifest = new AppManifest();
        manifest.label = sp.name;
        manifest.shortDesc = String.format("The template *%s* was created by %s on %s", sp.name.replace("*", ""), this.usersService.getPublicUser((String)t.getUser().getAssociatedDSSUser()).displayName, ProjectsService.getDateForShortDesc());
        if (settings.useAsRecipe) {
            manifest.useAsRecipeSettings = new AppManifest.AppUseAsRecipeSettings();
            ParamDesc param1 = new ParamDesc("variable1", ParamDesc.Type.STRING);
            param1.label = "nice label in the form";
            param1.description = "Help text for the variable";
            manifest.useAsRecipeSettings.variablesEditionTile.params.add(param1);
            ParamDesc param2 = new ParamDesc("variable2", ParamDesc.Type.INT);
            param2.label = "another label";
            manifest.useAsRecipeSettings.variablesEditionTile.params.add(param2);
            ParamDesc param3 = new ParamDesc("variable3", ParamDesc.Type.SELECT);
            param3.label = "some selector";
            param3.selectChoices = Lists.newArrayList((Object[])new ParamDesc.SelectChoice[]{new ParamDesc.SelectChoice().withValue("val1").withLabel("First"), new ParamDesc.SelectChoice().withValue("val2").withLabel("Second")});
            manifest.useAsRecipeSettings.variablesEditionTile.params.add(param3);
        }
        this.saveAppTemplateManifestForProject(sp.projectKey, manifest);
    }

    public void unAppTemplatify_T(SerializedProject sp) {
        try {
            TransactionRef t = TransactionContext.retrieveRead();
            AppManifest appManifest = (AppManifest)t.readObjectUnsafe(new RelFile(new String[]{"projects", sp.projectKey, "app-manifest.json"}), AppManifest.class);
            String appId = AppsService.buildApplicationId(sp.projectKey);
            AppRecipeMeta arm = new AppRecipeMeta(appId, appManifest);
            RecipeRegistry.deregister(arm);
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to cleanup state of app_template", (Throwable)e);
        }
    }

    public void createManifestForSetupSection_T(SerializedProject sp) throws IOException, DKUSecurityException {
        AppManifest manifest = new AppManifest();
        this.saveAppTemplateManifestForProject(sp.projectKey, manifest);
    }

    public AppManifest getManifestFromProjectUnsafe(TransactionRef t, String projectKey) throws IOException {
        return (AppManifest)t.readObjectUnsafe(new RelFile(new String[]{"projects", projectKey, "app-manifest.json"}), AppManifest.class);
    }

    public void skipInstanceUpdate_T(String projectKey, String versionToSkip) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile appManifestFile = new RelFile(new String[]{"projects", projectKey, "app-manifest.json"});
        AppManifest manifest = (AppManifest)t.readObject(appManifestFile, AppManifest.class);
        manifest.instanceSkippedVersion = versionToSkip;
        t.writeObject(appManifestFile, (Object)manifest);
    }

    public FutureResponse<AppInstantiationResult> startInstantiate_NT(AuthCtx authCtx, String appId, @Nonnull AppInstantiationParams appInstantiationParams, boolean deleteExisting, boolean testInstance) throws Exception {
        AppInstantiationFutureThread aift = new AppInstantiationFutureThread(authCtx, appId, appInstantiationParams, deleteExisting, testInstance);
        return this.futureService.runFuture(aift, 0L, new TypeToken<FutureResponse<AppInstantiationResult>>(){});
    }

    private AppInstantiationResult doInstantiate(AuthCtx authCtx, AppTemplatePageData appPageData, @Nonnull AppInstantiationParams appInstantiationParams, boolean testInstance) throws Exception {
        AppInstantiationResult result = new AppInstantiationResult();
        result.targetProjectKey = appInstantiationParams.targetProjectKey;
        assert (appPageData.appId != null);
        String instantiationImportId = SecretKeyGenerator.generate((int)12);
        int numberOfSteps = appPageData.origin == AppOrigin.PROJECT ? 19 : 2;
        try (FutureProgress.AutocloseableFutureProgressState fut = FutureProgress.pushAutoCloseableState((String)"Building export", (double)numberOfSteps, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            File appArchive = null;
            ProjectRemappingSettings remapping = null;
            switch (appPageData.origin) {
                case PROJECT: {
                    result.projectKey = appPageData.originProjectKey;
                    appArchive = DSSTempUtils.getTempFileWithSpecificName((String)"app-instantiate", (String)instantiationImportId, (String)"zip");
                    DKUFileUtils.mkdirsParent((File)appArchive);
                    if (appPageData.manifest != null && appInstantiationParams.isTemporaryAppInstance) {
                        appPageData.manifest.projectExportManifest.exportGitRepository = false;
                    }
                    ProjectImportExportController.ProjectExportResult exportResult = this.exportProjectAccordingToManifest(authCtx, appPageData.originProjectKey, appPageData.manifest, instantiationImportId, appArchive);
                    logger.info((Object)("Export returned : " + JSON.pretty((Object)((Object)exportResult))));
                    try (Transaction t = this.transactionService.beginRead();){
                        SerializedProject sp = this.projectsService.getMandatoryUnsafe(appPageData.originProjectKey);
                        if (sp.bundleContainerSettings == null || ApplicationConfigurator.getNodeType() != ApplicationConfigurator.DSSNodeType.DESIGN) break;
                        remapping = (ProjectRemappingSettings)JSON.deepCopy((Object)sp.bundleContainerSettings.remapping);
                        break;
                    }
                }
                case PLUGIN: {
                    LoadedCustomAppTemplate loadedDesc = (LoadedCustomAppTemplate)this.customAppTemplatesService.getLoadedDescByElementType(appPageData.appId);
                    appArchive = this.customAppTemplatesService.getProjectArchive(appPageData.appId);
                    if (!appArchive.exists()) {
                        logger.error((Object)("Project archive for plugin app " + appPageData.appId + " not found : " + String.valueOf(appArchive)));
                        AppInstantiationResult t = null;
                        return t;
                    }
                    PluginSettings pluginSettings = new PluginSettingsResolver(authCtx, null).getAndMergePluginSettings(loadedDesc.ownerPluginId);
                    for (AppTemplateSettings appTemplateSettings : pluginSettings.appTemplates) {
                        if (!appTemplateSettings.name.equals(loadedDesc.id)) continue;
                        remapping = (ProjectRemappingSettings)JSON.deepCopy((Object)appTemplateSettings.remapping);
                    }
                    break;
                }
            }
            boolean cleanupArchive = appPageData.origin == AppOrigin.PROJECT;
            this.importAppProject(authCtx, appPageData, remapping, appInstantiationParams, result, appArchive, cleanupArchive, testInstance);
            FutureProgress.incrementState((double)1.0);
            this.timelinesDAO.clearForProject(appInstantiationParams.targetProjectKey);
        }
        return result;
    }

    public ProjectImportExportController.ProjectExportResult exportProjectAccordingToManifest(AuthCtx authCtx, String originProjectKey, AppManifest manifest, String instantiationImportId, File appArchive) throws IOException, Exception {
        ProjectExportOptions exportOptions = this.makeExportOptions(manifest);
        logger.infoV("Starting export: %s", new Object[]{JSON.pretty((Object)exportOptions)});
        ProjectExporter peo = new ProjectExporter(authCtx, exportOptions, originProjectKey, appArchive);
        ProjectImportExportController.ProjectExportResult per = peo.export(false);
        per.projectKey = originProjectKey;
        per.exportId = instantiationImportId;
        per.summarize();
        return per;
    }

    private void importAppProject(AuthCtx authCtx, final AppTemplatePageData appPageData, ProjectRemappingSettings remapping, final @Nonnull AppInstantiationParams appInstantiationParams, AppInstantiationResult result, File appArchive, boolean cleanupArchive, final boolean testInstance) throws Exception {
        ProjectImporter.ProjectImportSettings projectImportSettings = new ProjectImporter.ProjectImportSettings();
        projectImportSettings.targetProjectKey = appInstantiationParams.targetProjectKey;
        projectImportSettings.importType = TaggingService.DEFAULT_TAG.APP_INSTANTIATION.name;
        projectImportSettings.remapping = remapping == null ? new ProjectRemappingSettings() : remapping;
        projectImportSettings.targetProjectFolderId = this.projectFoldersService.ensureAppInstancesFolder(authCtx);
        logger.infoV("Starting import: %s", new Object[]{JSON.pretty((Object)projectImportSettings)});
        ProjectImporter pi = new ProjectImporter(authCtx, appArchive, projectImportSettings){

            @Override
            protected void fixupUnzippedProject(File importSourceDirectory) throws IOException {
                if (ApplicationConfigurator.isAutomation() && appPageData.origin == AppOrigin.PLUGIN) {
                    File activeBundleFile = new File(new File(importSourceDirectory, "project_config"), "active-bundle.json");
                    ActiveBundleState abs = new ActiveBundleState();
                    abs.activatedOn = DKUDateUtils.isoFormatLocalNow();
                    abs.bundleId = "plugin";
                    JSON.prettyToFile((Object)abs, (File)activeBundleFile);
                }
            }

            @Override
            protected void adjustRunAsUsers() throws IOException {
                super.adjustRunAsUsers(new ProjectImporterBase.StashedLocalConfig(), true, true, true);
            }

            @Override
            protected void preSaveHook(SerializedProject sp) throws IOException {
                this.switchProjectTypeToAppInstance(sp, appPageData, appInstantiationParams.targetProjectName, appInstantiationParams.targetProjectDescription, appInstantiationParams.creatorFullId, testInstance);
                super.preSaveHook(sp);
            }

            @Override
            protected void postSaveHook() throws IOException {
                RWTransactionRef t = TransactionContext.retrieveWrite();
                this.enrichAppInstanceVariables(appInstantiationParams.variables, appPageData.manifest, t);
                super.postSaveHook();
            }

            private void switchProjectTypeToAppInstance(SerializedProject sp, AppTemplatePageData appPageData2, String targetProjectLabel, @Nullable String targetProjectDescription, @Nullable String appInstanceCreatorFullId, boolean testInstance2) throws IOException {
                sp.name = targetProjectLabel;
                sp.projectAppType = SerializedProject.ProjectAppType.APP_INSTANCE;
                sp.generatingAppId = appPageData2.appId;
                sp.generatingAppVersion = appPageData2.appVersion;
                sp.appInstanceCreatorFullId = Optional.ofNullable(appInstanceCreatorFullId).orElse(appPageData2.appId);
                sp.shortDesc = StringUtils.isNotBlank((String)targetProjectDescription) ? targetProjectDescription : (testInstance2 ? AppsService.TEST_INSTANCE_SHORT_DESCRIPTION : String.format("This is an instance of application *%s* which was created by %s on %s", appPageData2.manifest.label.replace("*", ""), AppsService.this.usersService.getPublicUser((String)this.authCtx.getAssociatedDSSUser()).displayName, ProjectsService.getDateForShortDesc()));
                if (appInstantiationParams.isTemporaryAppInstance) {
                    sp.isTemporaryAppInstance = true;
                    sp.settings.gitCommitMode = IProjectCommitModeService.ProjectCommitMode.ALL_EXPLICIT;
                }
            }

            private void enrichAppInstanceVariables(JsonObject variables, AppManifest manifest, RWTransactionRef t) throws IOException {
                RelFile rf = new RelFile(new String[]{"projects", this.targetProjectKey, "localvariables.json"});
                JsonObject localVariables = (JsonObject)t.readObjectDefault(rf, JsonObject.class);
                for (String k : variables.keySet()) {
                    localVariables.add(k, variables.get(k));
                }
                if (!variables.has(AppsService.PROJECT_RANDOM_KEY) && !localVariables.has(AppsService.PROJECT_RANDOM_KEY)) {
                    localVariables.addProperty(AppsService.PROJECT_RANDOM_KEY, SecretKeyGenerator.generate((int)8));
                }
                Gson gson = new Gson();
                for (AppManifest.AppHomepageSection section : manifest.homepageSections) {
                    for (AppHomepageTile tile : section.tiles) {
                        if (!(tile instanceof AppHomepageTile.ProjectVariablesTile)) continue;
                        AppHomepageTile.ProjectVariablesTile typedTile = (AppHomepageTile.ProjectVariablesTile)tile;
                        for (ParamDesc param : typedTile.params) {
                            if (param.defaultValue == null) continue;
                            localVariables.add(param.name, gson.toJsonTree(param.defaultValue));
                        }
                    }
                }
                t.writeStringUTF8(rf, JSON.prettyUnescapeHtml((Object)localVariables));
            }
        };
        ProjectImporter.ProjectImportResult importResult = pi.importProject(authCtx);
        if (cleanupArchive) {
            DKUFileUtils.forceDelete((File)appArchive);
        }
        if (!importResult.success) {
            result.mergeFrom(importResult);
            result.done = false;
            logger.error((Object)("Project instantiation failed: " + JSON.json((Object)((Object)importResult))));
            return;
        }
        result.done = true;
        this.graphService.invalidateCache();
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, appInstantiationParams.targetProjectKey, appInstantiationParams.targetProjectKey, authCtx, TaggableObjectChangedEvent.ActionType.PROJECT_CREATE));
    }

    public FutureResponse<AppInstantiationResult> createOrUpdateTestInstance_NT(AuthCtx authCtx, String appId) throws Exception {
        Object testInstanceProjectKey;
        try (Transaction ignored = this.transactionService.beginRead();){
            testInstanceProjectKey = this.getTestInstance_T(authCtx, appId);
        }
        if (StringUtils.isBlank((String)testInstanceProjectKey)) {
            String templateProjectKey = AppsService.getProjectKey(appId);
            String randomness = SecretKeyGenerator.generate((int)8);
            testInstanceProjectKey = templateProjectKey + "_" + randomness;
            AppInstantiationParams appInstantiationParams = new AppInstantiationParams((String)testInstanceProjectKey, "Test instance for " + templateProjectKey, null, appId);
            appInstantiationParams.variables.addProperty(PROJECT_RANDOM_KEY, randomness);
            return this.startInstantiate_NT(authCtx, appId, appInstantiationParams, false, true);
        }
        FutureResponse response = new FutureResponse();
        AppManifest newAppManifest = this.getAppTemplateManifest_NT(appId);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.saveAppTemplateManifestForProject((String)testInstanceProjectKey, newAppManifest);
            t.commit("Updated test instance app manifest");
        }
        response.hasResult = true;
        response.result = new AppInstantiationResult();
        ((AppInstantiationResult)((Object)response.result)).targetProjectKey = testInstanceProjectKey;
        ((AppInstantiationResult)((Object)response.result)).done = true;
        return response;
    }

    private ProjectExportOptions makeExportOptions(AppManifest appManifest) {
        ProjectExportOptions exportOptions = new ProjectExportOptions();
        exportOptions.exportUploads = appManifest.projectExportManifest.exportUploads;
        exportOptions.exportAllInputDatasets = appManifest.projectExportManifest.exportAllInputDatasets;
        exportOptions.exportAllDatasets = appManifest.projectExportManifest.exportAllDatasets;
        exportOptions.exportAnalysisModels = appManifest.projectExportManifest.exportAnalysisModels;
        exportOptions.exportSavedModels = appManifest.projectExportManifest.exportSavedModels;
        exportOptions.exportModelEvaluationStores = appManifest.projectExportManifest.exportModelEvaluationStores;
        exportOptions.exportLabelingTasks = appManifest.projectExportManifest.exportLabelingTasks;
        exportOptions.exportProjectResources = appManifest.projectExportManifest.exportProjectResources;
        exportOptions.exportAllInputManagedFolders = appManifest.projectExportManifest.exportAllInputManagedFolders;
        exportOptions.exportManagedFolders = appManifest.projectExportManifest.exportManagedFolders;
        exportOptions.exportKnowledgeBanks = appManifest.projectExportManifest.exportKnowledgeBank;
        exportOptions.exportPromptStudioHistories = appManifest.projectExportManifest.exportPromptStudioHistories;
        exportOptions.exportInsightsData = appManifest.projectExportManifest.exportInsightsData;
        exportOptions.useManualPluginsInfo = false;
        exportOptions.includedDatasetsData = appManifest.projectExportManifest.includedDatasetsData;
        exportOptions.includedManagedFolders = appManifest.projectExportManifest.includedManagedFolders;
        exportOptions.includedSavedModels = appManifest.projectExportManifest.includedSavedModels;
        exportOptions.includedModelEvaluationStores = appManifest.projectExportManifest.includedModelEvaluationStores;
        exportOptions.includedCodeStudios = appManifest.projectExportManifest.includedCodeStudios;
        exportOptions.includedKnowledgeBanks = appManifest.projectExportManifest.includedKnowledgeBanks;
        exportOptions.includedLabelingTasks = appManifest.projectExportManifest.includedLabelingTasks;
        exportOptions.includedPromptStudiosHistories = appManifest.projectExportManifest.includedPromptStudiosHistories;
        exportOptions.exportGitRepository = appManifest.projectExportManifest.exportGitRepository;
        return exportOptions;
    }

    public void handleProjectImported_NT(String projectKey) {
        try {
            AppManifest appManifest = this.getAppTemplateManifestForProject_NT(projectKey);
            String appId = AppsService.buildApplicationId(projectKey);
            AppRecipeMeta arm = new AppRecipeMeta(appId, appManifest);
            if (appManifest.useAsRecipeSettings != null) {
                logger.info((Object)("Updating app-recipe " + appId));
                RecipeRegistry.register(arm);
            } else {
                logger.info((Object)("Updating app-recipe " + appId));
                RecipeRegistry.deregister(arm);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to handle addition of app manifest from " + projectKey), (Throwable)e);
        }
    }

    public static void handleProjectDeleted(String projectKey) {
        String appId = AppsService.buildApplicationId(projectKey);
        AppRecipeMeta arm = new AppRecipeMeta(appId, new AppManifest());
        RecipeRegistry.deregister(arm);
    }

    public static String getProjectKey(String applicationId) {
        if (!applicationId.startsWith(APPLICATION_ID_PREFIX)) {
            throw new IllegalArgumentException("Cannot retrieve original project key, application " + applicationId + " was not created from a project");
        }
        return applicationId.substring(APPLICATION_ID_PREFIX.length());
    }

    public static String buildApplicationId(String projectKey) {
        return APPLICATION_ID_PREFIX + projectKey;
    }

    public static class AppImageInfo {
        public long objectImgHash;
        public boolean isAppImg;
        public String defaultImgColor;
        public String imgColor;
        public Integer imgPattern;
        public Boolean showInitials;
    }

    public static class AppsList {
        public List<AppListItem> items = new ArrayList<AppListItem>();
    }

    @UIModel
    public static class AppListItem {
        public boolean onlyLimitedVisibility;
        public boolean canRequestAccess;
        public String appId;
        public String appVersion;
        public String label;
        public String shortDesc;
        public String description;
        public List<String> tags = Lists.newArrayList();
        public long objectImgHash;
        public boolean isAppImg;
        public String imgColor;
        public String defaultImgColor;
        public Integer imgPattern;
        public Boolean showInitials;
        public AppOrigin origin;
        public String originProjectKey;
        public int instanceCount;
        public List<PublicUser> instanceOwners;
        public long lastInstantiation;
        public boolean useAsRecipe;

        public AppListItem() {
        }

        public AppListItem(AppManifest manifest, AppImageInfo imageInfo) {
            this.appId = manifest.id;
            this.label = manifest.label;
            this.shortDesc = manifest.shortDesc;
            this.description = manifest.description;
            this.tags = manifest.tags;
            this.objectImgHash = imageInfo.objectImgHash;
            this.imgColor = imageInfo.imgColor;
            this.imgPattern = imageInfo.imgPattern;
            this.showInitials = imageInfo.showInitials;
            this.isAppImg = imageInfo.isAppImg;
            this.defaultImgColor = imageInfo.defaultImgColor;
        }

        public AppListItem(AppListItem app) {
            this.appId = app.appId;
            this.appVersion = app.appVersion;
            this.label = app.label;
            this.shortDesc = app.shortDesc;
            this.description = app.description;
            this.tags = app.tags;
            this.objectImgHash = app.objectImgHash;
            this.isAppImg = app.isAppImg;
            this.imgColor = app.imgColor;
            this.defaultImgColor = app.defaultImgColor;
            this.imgPattern = app.imgPattern;
            this.showInitials = app.showInitials;
            this.origin = app.origin;
            this.originProjectKey = app.originProjectKey;
            this.instanceCount = app.instanceCount;
            this.instanceOwners = app.instanceOwners;
            this.lastInstantiation = app.lastInstantiation;
            this.useAsRecipe = app.useAsRecipe;
            this.onlyLimitedVisibility = app.onlyLimitedVisibility;
            this.canRequestAccess = app.canRequestAccess;
        }
    }

    public static enum AppOrigin {
        PROJECT,
        PLUGIN;


        public static AppOrigin fromAppId(String appId) {
            if (appId.startsWith(AppsService.APPLICATION_ID_PREFIX)) {
                return PROJECT;
            }
            if (appId.startsWith(AppsService.PLUGIN_ID_PREFIX)) {
                return PLUGIN;
            }
            throw new IllegalArgumentException("Unable to determine app origin from appId: " + appId);
        }
    }

    private static class AppListWithManifest {
        private final List<AppListItemWithManifest> items = new ArrayList<AppListItemWithManifest>();

        private AppListWithManifest() {
        }

        private List<AppManifest> toRecipeAppManifests() {
            return this.items.stream().filter(listItem -> listItem.manifest.useAsRecipeSettings != null).map(listItem -> listItem.manifest).collect(Collectors.toList());
        }

        private AppsList toAppsList() {
            AppsList result = new AppsList();
            for (AppListItemWithManifest item : this.items) {
                result.items.add(item.appListItem);
            }
            return result;
        }

        void add(AppListItemWithManifest item) {
            this.items.add(item);
        }
    }

    private static class AppListItemWithManifest {
        private final AppManifest manifest;
        private final AppListItem appListItem;

        private AppListItemWithManifest(AppManifest manifest, AppListItem appListItem) {
            this.manifest = manifest;
            this.appListItem = appListItem;
        }

        private AppListItemWithManifest withOriginProjectKey(String projectKey) {
            this.appListItem.originProjectKey = projectKey;
            return this;
        }
    }

    public static class AppTemplatePageData
    extends AppTemplateData {
    }

    public static class AppTemplateData
    extends AppListItem {
        public AppManifest manifest;
        public long objectFullImgHash;
        public List<ProjectsService.HomepageProjectItem> instances = new ArrayList<ProjectsService.HomepageProjectItem>();
        public boolean canAdminOriginProjectKey;
    }

    public static class AppTemplateInstanceData
    extends AppTemplateData {
        public boolean originExists;
        public boolean obsolete;
        public String templateVersion;
        public String templateVersionNotes;
    }

    public static class ManifestCreationSettings {
        public boolean useAsRecipe;
    }

    private class AppInstantiationFutureThread
    extends SimpleFutureThread<AppInstantiationResult> {
        private final String appId;
        private final String targetProjectKey;
        @Nonnull
        private final AppInstantiationParams appInstantiationParams;
        private final boolean deleteExisting;
        private final boolean testInstance;

        public AppInstantiationFutureThread(AuthCtx user, String appId, AppInstantiationParams appInstantiationParams, boolean deleteExisting, boolean testInstance) {
            super(user);
            this.appId = appId;
            this.appInstantiationParams = appInstantiationParams;
            this.targetProjectKey = appInstantiationParams.targetProjectKey;
            this.deleteExisting = deleteExisting;
            this.testInstance = testInstance;
        }

        public FuturePayload getPayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "instantiate-app";
            fp.displayName = "Instantiate app " + this.appId + " to project " + this.targetProjectKey;
            return fp;
        }

        @Override
        public AppInstantiationResult compute() throws Exception {
            if (this.deleteExisting) {
                try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)"Deleting existing instance");){
                    logger.infoV("Recreating application instance %s. Step 1/2: delete existing instance", new Object[]{this.targetProjectKey});
                    InfoMessage.InfoMessages deleteResult = AppsService.this.projectsService.projectDeletionAttempt(this.getOwner(), this.targetProjectKey, true, true, false, this.testInstance);
                    if (deleteResult.anyFatal()) {
                        AppInstantiationResult result = new AppInstantiationResult();
                        result.mergeFrom(deleteResult);
                        AppInstantiationResult appInstantiationResult = result;
                        return appInstantiationResult;
                    }
                }
                logger.infoV("Recreating application instance %s. Step 2/2: instantiate new instance", new Object[]{this.targetProjectKey});
            }
            AppTemplatePageData apd = AppsService.this.getAppTemplatePageData_NT(this.owner, this.appId);
            return AppsService.this.doInstantiate(this.owner, apd, this.appInstantiationParams, this.testInstance);
        }
    }

    public static class AppInstantiationParams {
        @Nonnull
        public final String targetProjectKey;
        @Nullable
        public final String targetProjectName;
        @Nullable
        public final String targetProjectDescription;
        @Nullable
        public final String creatorFullId;
        @Nonnull
        public final JsonObject variables;
        public boolean isTemporaryAppInstance;

        public AppInstantiationParams(@Nonnull String targetProjectKey, @Nullable String targetProjectName, @Nullable String targetProjectDescription, @Nullable String creatorFullId) {
            this(targetProjectKey, targetProjectName, targetProjectDescription, creatorFullId, new JsonObject(), false);
        }

        public AppInstantiationParams(@Nonnull String targetProjectKey, @Nullable String targetProjectName, @Nullable String targetProjectDescription, @Nullable String creatorFullId, @Nonnull JsonObject variables) {
            this(targetProjectKey, targetProjectName, targetProjectDescription, creatorFullId, variables, false);
        }

        public AppInstantiationParams(@Nonnull String targetProjectKey, @Nullable String targetProjectName, @Nullable String targetProjectDescription, @Nullable String creatorFullId, @Nonnull JsonObject variables, boolean isTemporaryAppInstance) {
            this.targetProjectKey = targetProjectKey;
            this.targetProjectName = targetProjectName;
            this.targetProjectDescription = targetProjectDescription;
            this.creatorFullId = creatorFullId;
            this.variables = variables;
            this.isTemporaryAppInstance = isTemporaryAppInstance;
        }
    }

    @PartOfPublicAPI
    public static class AppInstantiationResult
    extends InfoMessage.InfoMessages {
        public String projectKey;
        public String targetProjectKey;
        public boolean done;
    }

    @UIModel
    public static class AppListItemWithHomepageInfo
    extends AppListItem {
        public int visibleInstanceCount;
        public long lastUsed;
        public long lastUsedByCurrentUser;

        public AppListItemWithHomepageInfo(AppListItem item, int visibleInstanceCount, long lastUsed, long lastUsedByCurrentUser) {
            super(item);
            this.visibleInstanceCount = visibleInstanceCount;
            this.lastUsed = lastUsed;
            this.lastUsedByCurrentUser = lastUsedByCurrentUser;
        }
    }

    @PartOfPublicAPI
    public static class AppInstantiationRequest {
        @Nullable
        public String targetProjectKey;
        @Nullable
        public String targetProjectName;
        @Nullable
        public String appInstanceCreatorFullId;
        @Nullable
        public JsonObject variables;
        public boolean isTemporaryAppInstance;
    }

    public static enum AppCodes implements InfoMessage.MessageCode
    {
        ERR_APP_BACKING_APPLICATION_RECIPE_NOT_INSTALLED("App backing application-as-recipe not installed or removed", InfoMessage.FixabilityCategory.MISSING_APP);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private AppCodes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

