/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ProjectScopePublicAPIKey;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

class ProjectImportExportUtils {
    private static final String APIKEYS_FILE_PATH = "apikeys.json";
    private static final String LAMBDA_SERVICES_PATH = "lambda_services";
    private static final String WEB_APPS_PATH = "web_apps";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.bundles.importexport");

    private ProjectImportExportUtils() {
    }

    static void regenerateAPIKeys(ReadWriteFS projectConfig, boolean dummy) throws IOException {
        if (projectConfig.isFile(APIKEYS_FILE_PATH)) {
            logger.info((Object)"Update api keys");
            ProjectScopePublicAPIKey.KeyList apiKeys = (ProjectScopePublicAPIKey.KeyList)projectConfig.readObject(APIKEYS_FILE_PATH, ProjectScopePublicAPIKey.KeyList.class);
            HashMap<String, String> apiKeyMigrationMap = new HashMap<String, String>();
            for (ProjectScopePublicAPIKey apiKey : apiKeys) {
                Object newSecret = ApiKeyUtils.generateApiKeySecret();
                if (dummy) {
                    newSecret = "dummyKey_" + (String)newSecret;
                }
                logger.info((Object)("  " + apiKey.label + " (id: " + apiKey.id + ") => new secret generated"));
                apiKeyMigrationMap.put(apiKey.key, (String)newSecret);
                apiKey.key = dummy ? newSecret : ApiKeyUtils.hashIfNecessary((String)newSecret);
            }
            projectConfig.writeObject(APIKEYS_FILE_PATH, (Object)apiKeys);
            try {
                for (RelFile relFile : projectConfig.listFiles(WEB_APPS_PATH)) {
                    ProjectImportExportUtils.updateWebApp(projectConfig, relFile, apiKeyMigrationMap, dummy);
                }
            }
            catch (Exception e) {
                logger.info((Object)"Failed to list webapps ", (Throwable)e);
            }
        } else {
            logger.info((Object)"No API keys file");
        }
    }

    @VisibleForTesting
    static void updateWebApp(ReadWriteFS projectConfig, RelFile relFile, Map<String, String> apiKeyMigrationMap, boolean dummy) {
        if (!relFile.getLeafName().endsWith("json")) {
            return;
        }
        logger.info((Object)("Update webapp: " + relFile.getFullPath()));
        try {
            WebApp app = (WebApp)projectConfig.readObject(relFile, WebApp.class);
            if (app.apiKey == null) {
                return;
            }
            PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
            try {
                String decryptedApiKey = passwordEncryptionService.decryptIfEncrypted(app.apiKey);
                apiKeyMigrationMap.keySet().parallelStream().filter(key -> key.equals(decryptedApiKey) || ApiKeyUtils.compareKeySecret((String)decryptedApiKey, (String)key)).findFirst().ifPresent(key -> {
                    String secret = (String)apiKeyMigrationMap.get(key);
                    app.apiKey = dummy ? secret : passwordEncryptionService.encryptIfNotEncryptedOrEmpty(secret);
                    try {
                        projectConfig.writeObject(relFile, (Object)app);
                    }
                    catch (Exception e) {
                        logger.info((Object)("Failed to update webapp apiKey in " + relFile.getFullPath()), (Throwable)e);
                    }
                });
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)"Failed to decrypt webapp API key, removing API key from webapp config", (Throwable)e);
                app.apiKey = null;
                projectConfig.writeObject(relFile, (Object)app);
            }
        }
        catch (Exception e) {
            logger.info((Object)("Failed to update webapp apiKey in " + relFile.getFullPath()), (Throwable)e);
        }
    }

    static void decryptApiServiceApiKeys(ReadWriteFS projectConfig) throws IOException {
        ProjectImportExportUtils.updateApiServiceApiKeys(projectConfig, false);
    }

    static void encryptApiServiceApiKeys(ReadWriteFS projectConfig) throws IOException {
        ProjectImportExportUtils.updateApiServiceApiKeys(projectConfig, true);
    }

    private static void updateApiServiceApiKeys(ReadWriteFS projectConfig, boolean encrypt) throws IOException {
        if (projectConfig.isDirectory(LAMBDA_SERVICES_PATH)) {
            PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
            logger.infoV("%s any API service API keys", new Object[]{encrypt ? "Encrypting" : "Decrypting"});
            for (RelFile serviceFile : projectConfig.listFiles(LAMBDA_SERVICES_PATH)) {
                logger.infoV("%s API keys in: " + serviceFile.getFullPath(), new Object[]{encrypt ? "Encrypt" : "Decrypt"});
                try {
                    LambdaService serviceConfig = (LambdaService)projectConfig.readObject(serviceFile, LambdaService.class);
                    if (serviceConfig.authRealm != null) {
                        if (encrypt) {
                            serviceConfig.authRealm.encryptKeysIfNotEncrypted(passwordEncryptionService);
                        } else {
                            serviceConfig.authRealm.decryptKeysIfEncrypted(passwordEncryptionService);
                        }
                    }
                    projectConfig.writeObject(serviceFile, (Object)serviceConfig);
                }
                catch (Exception e) {
                    logger.info((Object)("Failed to parse or update API service config in " + serviceFile.getFullPath()), (Throwable)e);
                }
            }
        } else {
            logger.info((Object)"No API services found");
        }
    }

    public static void hashApiKeys(ReadWriteFS projectConfig) throws IOException {
        if (!ApiKeyUtils.useHashedApiKeys()) {
            return;
        }
        if (projectConfig.isFile(APIKEYS_FILE_PATH)) {
            logger.info((Object)"Hash project API keys");
            ProjectScopePublicAPIKey.KeyList apiKeys = (ProjectScopePublicAPIKey.KeyList)projectConfig.readObject(APIKEYS_FILE_PATH, ProjectScopePublicAPIKey.KeyList.class);
            for (ProjectScopePublicAPIKey apiKey : apiKeys) {
                if (!StringUtils.isNotBlank((String)apiKey.key) || apiKey.key.startsWith("sha256:")) continue;
                apiKey.key = ApiKeyUtils.hashIfNecessary((String)apiKey.key);
            }
            projectConfig.writeObject(APIKEYS_FILE_PATH, (Object)apiKeys);
        } else {
            logger.info((Object)"No API keys file");
        }
    }

    public static void encryptWebAppKeys(ReadWriteFS projectConfig) throws IOException {
        if (!projectConfig.isDirectory(WEB_APPS_PATH)) {
            logger.info((Object)"No webapps found");
            return;
        }
        try {
            PasswordEncryptionService passwordEncryptionService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
            for (RelFile relFile : projectConfig.listFiles(WEB_APPS_PATH)) {
                if (!relFile.getLeafName().endsWith("json")) continue;
                logger.info((Object)("Encrypt webapp API key: " + relFile.getFullPath()));
                try {
                    WebApp app = (WebApp)projectConfig.readObject(relFile, WebApp.class);
                    if (app.apiKey == null) continue;
                    try {
                        passwordEncryptionService.decryptIfEncrypted(app.apiKey);
                    }
                    catch (IllegalArgumentException e) {
                        logger.warn((Object)"Failed to decrypt webapp API key, removing API key from webapp config", (Throwable)e);
                        app.apiKey = null;
                    }
                    app.apiKey = passwordEncryptionService.encryptIfNotEncryptedOrEmpty(app.apiKey);
                    projectConfig.writeObject(relFile, (Object)app);
                }
                catch (Exception e) {
                    logger.info((Object)("Failed to parse webapp in " + relFile.getFullPath()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to list webapps ", (Throwable)e);
        }
    }
}

