/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projectstandards;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.projectstandards.ProjectStandardsCheck;
import com.dataiku.dip.projectstandards.ProjectStandardsGeneralParameters;
import com.dataiku.dip.projectstandards.ProjectStandardsScope;
import com.dataiku.dip.utils.ErrorContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ProjectStandardsConfiguration {
    @Nonnull
    public List<ProjectStandardsCheck> checks = new ArrayList<ProjectStandardsCheck>();
    @Nonnull
    public List<ProjectStandardsScope> nonDefaultScopes = new ArrayList<ProjectStandardsScope>();
    @Nonnull
    public ProjectStandardsScope defaultScope = ProjectStandardsScope.createDefaultScope();
    @Nonnull
    public ProjectStandardsGeneralParameters generalParameters = new ProjectStandardsGeneralParameters();

    @Nonnull
    public List<ProjectStandardsScope> getScopes() {
        ArrayList<ProjectStandardsScope> newList = new ArrayList<ProjectStandardsScope>(this.nonDefaultScopes);
        newList.add(this.defaultScope);
        return newList;
    }

    public void validate() {
        ProjectStandardsConfiguration.validateChecks(this.checks, this.getScopes());
    }

    private static void validateChecks(List<ProjectStandardsCheck> checks, List<ProjectStandardsScope> scopes) {
        HashMap<String, Set> missingChecksWithParentScopes = new HashMap<String, Set>();
        List<String> checkIds = checks.stream().map(c2 -> c2.id).toList();
        checkIds.stream().collect(Collectors.groupingBy(s -> s, Collectors.counting())).forEach((id, count) -> {
            if (count > 1L) {
                throw ErrorContext.iaef((String)"At least two checks have the same id '%s'", (Object)id, (Object[])new Object[0]);
            }
        });
        for (ProjectStandardsScope scope : scopes) {
            for (String checkId : scope.checks) {
                if (checkIds.contains(checkId)) continue;
                Set associatedScopes = missingChecksWithParentScopes.getOrDefault(checkId, new HashSet());
                associatedScopes.add(scope.name);
                missingChecksWithParentScopes.put(checkId, associatedScopes);
            }
        }
        if (!missingChecksWithParentScopes.isEmpty()) {
            List<String> messages = missingChecksWithParentScopes.entrySet().stream().map(e -> String.format("check %s in scopes %s", e.getKey(), e.getValue())).toList();
            throw ErrorContext.iaef((String)"Some checks referenced in scopes do not exist: %s.", (Object)String.join((CharSequence)", ", messages), (Object[])new Object[0]);
        }
    }

    @Nonnull
    public ProjectStandardsScope getFittingScope(SerializedProject serializedProject, List<String> projectFolderIds) {
        for (ProjectStandardsScope scope : this.nonDefaultScopes) {
            if (!scope.projectFitsScope(serializedProject, projectFolderIds)) continue;
            return scope;
        }
        return this.defaultScope;
    }
}

