/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projectstandards;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.containers.exec.ContainerExecConfigSelector;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ProjectStandardsConfigurationDAO;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.license.LicenseRestrictionException;
import com.dataiku.dip.plugins.PluginConfigUtils;
import com.dataiku.dip.plugins.model.PluginSettings;
import com.dataiku.dip.projects.importexport.AbstractBundleService;
import com.dataiku.dip.projects.importexport.AutomationBundlesService;
import com.dataiku.dip.projects.importexport.DesignBundlesService;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.ProjectBundleExporter;
import com.dataiku.dip.projects.importexport.model.BundleContainerSettings;
import com.dataiku.dip.projects.importexport.model.BundleExporterSettings;
import com.dataiku.dip.projectstandards.ProjectStandardsCheck;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckRunInfo;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckRunRequest;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckRunResult;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckSpecInfo;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckSpecMeta;
import com.dataiku.dip.projectstandards.ProjectStandardsConfigurableCheckRegistry;
import com.dataiku.dip.projectstandards.ProjectStandardsConfiguration;
import com.dataiku.dip.projectstandards.ProjectStandardsGeneralParameters;
import com.dataiku.dip.projectstandards.ProjectStandardsKernelPool;
import com.dataiku.dip.projectstandards.ProjectStandardsReportPaths;
import com.dataiku.dip.projectstandards.ProjectStandardsRunReport;
import com.dataiku.dip.projectstandards.ProjectStandardsScope;
import com.dataiku.dip.projectstandards.ProjectStandardsTemporaryProject;
import com.dataiku.dip.projectstandards.component.LoadedPythonPluginProjectStandardsCheckSpec;
import com.dataiku.dip.projectstandards.component.PythonPluginProjectStandardsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dip.utils.ZipUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectStandardsService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projectStandards.service");
    private static final String GENERATED_BUNDLE_ID = "__project_standards__";
    public static final String MAX_EXECUTION_TIMEOUT_MINUTES_CONFIG_KEY = "dku.projectstandards.maxExecutionTimeoutMinutes";
    public static final int DEFAULT_MAX_EXECUTION_TIMEOUT_MINUTES = 120;
    private static final String CREATE_TEMP_PROJECT_FOR_BUNDLING_CONFIG_KEY = "dku.projectstandards.run.createTempProjectForBundling";
    private static final String ALLOW_RUNNING_ON_BUNDLES_CONFIG_KEY = "dku.projectstandards.run.allowRunningOnBundles";
    private static final String DONT_CREATE_TEMP_PROJECT_FOR_PROJECT_KEYS_CONFIG_KEY = "dku.projectstandards.run.dontCreateTempProjectForProjectKeys";
    private final TransactionService transactionService;
    private final ProjectStandardsConfigurationDAO projectStandardsConfigurationDAO;
    private final ProjectsService projectsService;
    private final ProjectFoldersService projectFoldersService;
    private final FutureService futureService;
    private final PythonPluginProjectStandardsService pythonPluginProjectStandardsService;
    private final ProjectStandardsKernelPool kernelPool;
    private final LicenseEnforcementService licenseEnforcementService;
    private final UsersService usersService;
    private static final ConcurrentHashMap<String, String> temporaryToOriginalProjectKeyMapping = new ConcurrentHashMap();

    @Autowired
    public ProjectStandardsService(TransactionService transactionService, ProjectStandardsConfigurationDAO projectStandardsConfigurationDAO, ProjectsService projectsService, ProjectFoldersService projectFoldersService, FutureService futureService, PythonPluginProjectStandardsService pythonPluginProjectStandardsService, ProjectStandardsKernelPool kernelPool, LicenseEnforcementService licenseEnforcementService, UsersService usersService) {
        this.transactionService = transactionService;
        this.projectStandardsConfigurationDAO = projectStandardsConfigurationDAO;
        this.projectsService = projectsService;
        this.projectFoldersService = projectFoldersService;
        this.futureService = futureService;
        this.pythonPluginProjectStandardsService = pythonPluginProjectStandardsService;
        this.kernelPool = kernelPool;
        this.licenseEnforcementService = licenseEnforcementService;
        this.usersService = usersService;
    }

    public List<ProjectStandardsCheckSpecInfo> listSpecsInfo() {
        ArrayList projectStandardsCheckSpecInfos = Lists.newArrayList();
        for (ProjectStandardsCheckSpecMeta meta : ProjectStandardsConfigurableCheckRegistry.getAllMeta()) {
            projectStandardsCheckSpecInfos.add(meta.getSpecInfo());
        }
        return projectStandardsCheckSpecInfos;
    }

    private ProjectStandardsConfiguration get() throws IOException {
        try (Transaction ignored = this.transactionService.retrieveOrBeginRead();){
            ProjectStandardsConfiguration projectStandardsConfiguration = this.projectStandardsConfigurationDAO.read();
            return projectStandardsConfiguration;
        }
    }

    private ProjectStandardsConfiguration getUnsafe() throws IOException {
        try (Transaction ignored = this.transactionService.retrieveOrBeginRead();){
            ProjectStandardsConfiguration projectStandardsConfiguration = this.projectStandardsConfigurationDAO.getUnsafe();
            return projectStandardsConfiguration;
        }
    }

    public List<ProjectStandardsCheck> getChecksUnsafe() throws IOException {
        return this.getUnsafe().checks;
    }

    public void saveCheck(ProjectStandardsCheck bundleCheck, boolean validate) throws IOException, LicenseRestrictionException {
        ProjectStandardsConfiguration projectStandardsConfiguration = this.get();
        ArrayList<ProjectStandardsCheck> allChecks = new ArrayList<ProjectStandardsCheck>(projectStandardsConfiguration.checks);
        int index = Iterables.indexOf(allChecks, c2 -> c2.id.equals(bundleCheck.id));
        if (index == -1) {
            throw new NotFoundException(String.format("Check '%s' not found", bundleCheck.id));
        }
        allChecks.remove(index);
        bundleCheck.lastModified = Instant.now().toEpochMilli();
        allChecks.add(index, bundleCheck);
        projectStandardsConfiguration.checks = allChecks;
        this.save(projectStandardsConfiguration, validate);
    }

    public ProjectStandardsScope getDefaultScopeUnsafe() throws IOException {
        return this.getUnsafe().defaultScope;
    }

    public List<ProjectStandardsScope> getScopesUnsafe() throws IOException {
        return this.getUnsafe().getScopes();
    }

    public ProjectStandardsGeneralParameters getGeneralParametersUnsafe() throws IOException {
        return this.getUnsafe().generalParameters;
    }

    public void setGeneralParameters(ProjectStandardsGeneralParameters generalParameters) throws IOException, LicenseRestrictionException {
        ProjectStandardsConfiguration projectStandardsConfiguration = this.get();
        projectStandardsConfiguration.generalParameters = generalParameters;
        this.save(projectStandardsConfiguration, false);
    }

    private ProjectStandardsScope saveDefaultScope(ProjectStandardsScope defaultScope, boolean validate) throws IOException, LicenseRestrictionException {
        defaultScope.name = "Default";
        defaultScope.description = "Project Standards will run these checks only if the project matches no other scope.";
        defaultScope.selectionMethod = ProjectStandardsScope.SelectionMethod.ALL;
        ProjectStandardsConfiguration projectStandardsConfiguration = this.get();
        projectStandardsConfiguration.defaultScope = defaultScope;
        this.save(projectStandardsConfiguration, validate);
        return defaultScope;
    }

    public ProjectStandardsScope getScopeUnsafe(String scopeName) throws IOException {
        ProjectStandardsConfiguration projectStandardsConfiguration = this.getUnsafe();
        return projectStandardsConfiguration.getScopes().stream().filter(s -> Objects.equals(s.name, scopeName)).findFirst().orElseThrow(() -> new NotFoundException(String.format("Scope '%s' not found", scopeName)));
    }

    public ProjectStandardsCheck getCheckUnsafe(String checkId) throws IOException {
        ProjectStandardsConfiguration projectStandardsConfiguration = this.getUnsafe();
        return projectStandardsConfiguration.checks.stream().filter(s -> Objects.equals(s.id, checkId)).findFirst().orElseThrow(() -> new NotFoundException(String.format("Check '%s' not found", checkId)));
    }

    public void createScope(ProjectStandardsScope newScope, boolean validate) throws IOException, LicenseRestrictionException {
        this.checkNameValidity(newScope.name);
        if (newScope.selectionMethod == ProjectStandardsScope.SelectionMethod.ALL) {
            throw ErrorContext.iae((String)"You can't create a scope with selectionMethod=ALL. Update the default scope instead.");
        }
        ProjectStandardsConfiguration projectStandardsConfiguration = this.get();
        if (projectStandardsConfiguration.getScopes().stream().anyMatch(s -> Objects.equals(s.name, newScope.name))) {
            throw ErrorContext.iaef((String)"A scope named %s already exists", (Object)newScope.name, (Object[])new Object[0]);
        }
        ArrayList<ProjectStandardsScope> nonDefaultScopes = new ArrayList<ProjectStandardsScope>(projectStandardsConfiguration.nonDefaultScopes);
        nonDefaultScopes.add(newScope);
        projectStandardsConfiguration.nonDefaultScopes = nonDefaultScopes;
        this.save(projectStandardsConfiguration, validate);
    }

    private void checkNameValidity(String scopeName) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)scopeName)) {
            throw ErrorContext.iae((String)"Scope name cannot be empty");
        }
        if (!scopeName.matches("^[a-zA-Z0-9_-]+$")) {
            throw ErrorContext.iaef((String)"Scope name is invalid: %s", (Object)scopeName, (Object[])new Object[0]);
        }
    }

    public void reorderScope(String scopeName, int index, boolean validate) throws IOException, LicenseRestrictionException {
        ProjectStandardsConfiguration projectStandardsConfiguration = this.get();
        ArrayList<ProjectStandardsScope> nonDefaultScopes = new ArrayList<ProjectStandardsScope>(projectStandardsConfiguration.nonDefaultScopes);
        ProjectStandardsScope scope = nonDefaultScopes.stream().filter(s -> Objects.equals(s.name, scopeName)).findFirst().orElseThrow(() -> new NotFoundException(String.format("Scope '%s' not found", scopeName)));
        nonDefaultScopes.remove(scope);
        nonDefaultScopes.add(index, scope);
        projectStandardsConfiguration.nonDefaultScopes = nonDefaultScopes;
        this.save(projectStandardsConfiguration, validate);
    }

    public ProjectStandardsScope saveScope(ProjectStandardsScope newScope, boolean validate) throws IOException, LicenseRestrictionException {
        if ("Default".equals(newScope.name)) {
            return this.saveDefaultScope(newScope, validate);
        }
        return this.saveCustomScope(newScope, validate);
    }

    private ProjectStandardsScope saveCustomScope(ProjectStandardsScope newScope, boolean validate) throws IOException, LicenseRestrictionException {
        if (newScope.selectionMethod == ProjectStandardsScope.SelectionMethod.ALL) {
            throw ErrorContext.iae((String)"You can't set selectionMethod=ALL to a scope. Update the default scope instead.");
        }
        ProjectStandardsConfiguration projectStandardsConfiguration = this.get();
        ArrayList<ProjectStandardsScope> nonDefaultScopes = new ArrayList<ProjectStandardsScope>(projectStandardsConfiguration.nonDefaultScopes);
        int index = Iterables.indexOf(nonDefaultScopes, s -> Objects.equals(s.name, newScope.name));
        if (index == -1) {
            throw new NotFoundException(String.format("Scope '%s' not found", newScope.name));
        }
        nonDefaultScopes.remove(index);
        nonDefaultScopes.add(index, newScope);
        projectStandardsConfiguration.nonDefaultScopes = nonDefaultScopes;
        this.save(projectStandardsConfiguration, validate);
        return newScope;
    }

    public void deleteCheck(String checkId, boolean validate) throws IOException, LicenseRestrictionException {
        ProjectStandardsConfiguration projectStandardsConfiguration = this.get();
        ArrayList<ProjectStandardsCheck> allChecks = new ArrayList<ProjectStandardsCheck>(projectStandardsConfiguration.checks);
        boolean removed = allChecks.removeIf(s -> Objects.equals(s.id, checkId));
        if (!removed) {
            throw new NotFoundException(String.format("Check '%s' not found", checkId));
        }
        projectStandardsConfiguration.checks = allChecks;
        this.save(projectStandardsConfiguration, validate);
    }

    public void deleteChecks(Set<String> checkIds, boolean validate) throws IOException, LicenseRestrictionException {
        ProjectStandardsConfiguration projectStandardsConfiguration = this.get();
        ArrayList<ProjectStandardsCheck> allChecks = new ArrayList<ProjectStandardsCheck>(projectStandardsConfiguration.checks);
        int originalSize = allChecks.size();
        allChecks.removeIf(s -> checkIds.contains(s.id));
        int removedCount = originalSize - allChecks.size();
        if (removedCount != checkIds.size()) {
            Set existingIds = projectStandardsConfiguration.checks.stream().map(c2 -> c2.id).collect(Collectors.toSet());
            List<String> notFound = checkIds.stream().filter(id -> !existingIds.contains(id)).toList();
            throw new NotFoundException(String.format("Check(s) not found: %s", notFound));
        }
        projectStandardsConfiguration.checks = allChecks;
        this.save(projectStandardsConfiguration, validate);
    }

    public void deleteScope(String scopeName, boolean validate) throws IOException, LicenseRestrictionException {
        ProjectStandardsConfiguration projectStandardsConfiguration = this.get();
        ArrayList<ProjectStandardsScope> nonDefaultScopes = new ArrayList<ProjectStandardsScope>(projectStandardsConfiguration.nonDefaultScopes);
        boolean removed = nonDefaultScopes.removeIf(s -> Objects.equals(s.name, scopeName));
        if (!removed) {
            throw new NotFoundException(String.format("Scope '%s' not found", scopeName));
        }
        projectStandardsConfiguration.nonDefaultScopes = nonDefaultScopes;
        this.save(projectStandardsConfiguration, validate);
    }

    public List<ProjectStandardsCheck> importChecksFromCheckSpecs(List<String> checkSpecElementTypes, boolean validate) throws IOException, LicenseRestrictionException {
        List<ProjectStandardsCheck> newChecks = this.createChecks(checkSpecElementTypes);
        ProjectStandardsConfiguration projectStandardsConfiguration = this.get();
        ArrayList<ProjectStandardsCheck> allChecks = new ArrayList<ProjectStandardsCheck>(projectStandardsConfiguration.checks);
        allChecks.addAll(newChecks);
        projectStandardsConfiguration.checks = allChecks;
        this.save(projectStandardsConfiguration, validate);
        return newChecks;
    }

    private List<ProjectStandardsCheck> createChecks(List<String> checkSpecElementTypes) throws IOException {
        ArrayList<ProjectStandardsCheck> existingChecks = new ArrayList<ProjectStandardsCheck>(this.get().checks);
        ArrayList<ProjectStandardsCheck> newChecks = new ArrayList<ProjectStandardsCheck>();
        for (ProjectStandardsCheckSpecInfo spec : this.listSpecsInfo()) {
            if (!checkSpecElementTypes.contains(spec.elementType)) continue;
            String id = this.generateNewId(spec, existingChecks);
            JsonObject checkParams = new JsonObject();
            LoadedPythonPluginProjectStandardsCheckSpec loadedDesc = (LoadedPythonPluginProjectStandardsCheckSpec)this.pythonPluginProjectStandardsService.getLoadedDescByElementType(spec.elementType);
            PluginConfigUtils.setDefaultValues(loadedDesc.desc.params, checkParams);
            ProjectStandardsCheck newCheck = new ProjectStandardsCheck(id, spec.label, spec.description, spec.elementType, checkParams, new HashSet<String>(spec.tags));
            newChecks.add(newCheck);
            existingChecks.add(newCheck);
        }
        return newChecks;
    }

    private String generateNewId(ProjectStandardsCheckSpecInfo checkSpec, List<ProjectStandardsCheck> existingChecks) {
        if (StringUtils.isEmpty((CharSequence)checkSpec.label)) {
            return UUID.randomUUID().toString();
        }
        String sanitizedLabel = checkSpec.label.replaceAll("[^\\w-]", "");
        StringTransmogrifier transmogrifier = new StringTransmogrifier();
        transmogrifier.addAllAlreadyTransmogrifiedAcceptDupes(existingChecks.stream().map(c2 -> c2.id).toList());
        return transmogrifier.transmogrify(sanitizedLabel);
    }

    private void save(ProjectStandardsConfiguration projectStandardsConfiguration, boolean validate) throws IOException, LicenseRestrictionException {
        TransactionContext.assertAttachedRWTransaction();
        if (!this.licenseEnforcementService.getFeaturesStatus().projectStandardsAllowed) {
            throw new LicenseRestrictionException("Project standards is not available in your license.");
        }
        if (validate) {
            projectStandardsConfiguration.validate();
        }
        this.projectStandardsConfigurationDAO.save(projectStandardsConfiguration);
    }

    @Nonnull
    public ProjectStandardsScope getScopeForProject(String projectKey) throws IOException {
        List<String> projectFolders;
        SerializedProject serializedProject;
        ProjectStandardsConfiguration projectStandardsConfiguration;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction ignored = this.transactionService.retrieveOrBeginRead();){
            projectStandardsConfiguration = this.getUnsafe();
            serializedProject = this.projectsService.getMandatory(projectKey);
            projectFolders = this.projectFoldersService.getProjectLocation_Uncheck(projectKey).stream().map(f -> f.id).toList();
        }
        return projectStandardsConfiguration.getFittingScope(serializedProject, projectFolders);
    }

    public Set<String> listAllTags() throws IOException {
        return this.getChecksUnsafe().stream().flatMap(c2 -> c2.tags.stream()).collect(Collectors.toSet());
    }

    public static String getOriginalProjectKey(String projectKey) {
        return temporaryToOriginalProjectKeyMapping.getOrDefault(projectKey, projectKey);
    }

    public FutureResponse<ProjectStandardsRunReport> run_NT(AuthCtx authCtx, String projectKey, @Nullable List<String> checkIds, @Nullable String bundleId, boolean currentlyBundling) throws Exception {
        File bundleArchive = null;
        if (StringUtils.isNotBlank((CharSequence)bundleId)) {
            bundleArchive = ApplicationConfigurator.isAutomation() ? ((AutomationBundlesService)SpringUtils.getBean(AutomationBundlesService.class)).getBundleArchive(projectKey, bundleId) : ((DesignBundlesService)SpringUtils.getBean(DesignBundlesService.class)).getBundleArchive(projectKey, bundleId);
        }
        return this.run_NT(authCtx, projectKey, checkIds, bundleArchive, currentlyBundling);
    }

    private FutureResponse<ProjectStandardsRunReport> run_NT(final AuthCtx authCtx, final String projectKey, final @Nullable List<String> requestedCheckIds, final @Nullable File fromBundleArchive, final boolean currentlyBundling) throws Exception {
        if (!this.licenseEnforcementService.getFeaturesStatus().projectStandardsAllowed) {
            throw new LicenseRestrictionException("Project standards is not available in your license.");
        }
        final DKUtils.SmartLogTailBuilder logTailBuilder = new DKUtils.SmartLogTailBuilder();
        return this.futureService.runFuture(new SimpleFutureThread<ProjectStandardsRunReport>(authCtx){

            @Override
            protected ProjectStandardsRunReport compute() throws Exception {
                List<String> checkIds;
                ProjectStandardsScope scope;
                Stopwatch totalStopWatch = Stopwatch.createStarted();
                DSSAuthCtx internalAdminAuth = DSSAuthCtx.internalAdminAuth();
                logger.infoV("Requesting execution of checks for project %s%s", new Object[]{projectKey, fromBundleArchive != null ? " based on bundle " + fromBundleArchive.getAbsolutePath() : ""});
                if (requestedCheckIds == null) {
                    scope = ProjectStandardsService.this.getScopeForProject(projectKey);
                    logger.infoV("No explicit check ids passed in the request. The associated scope '%s' will be used to get the checks list.", new Object[]{scope.name});
                    checkIds = scope.checks;
                } else {
                    scope = null;
                    logger.info((Object)"An explicit list of check ids have been passed in the request.");
                    checkIds = requestedCheckIds;
                }
                ProjectStandardsRunReport projectStandardsRunReport = new ProjectStandardsRunReport(projectKey);
                projectStandardsRunReport.startTime = Instant.now().truncatedTo(ChronoUnit.MILLIS).toString();
                projectStandardsRunReport.scope = scope == null ? null : scope.name;
                projectStandardsRunReport.requester = authCtx.getAssociatedDSSUserOrIdentifier();
                projectStandardsRunReport.bundleChecksRunInfo = ProjectStandardsService.this.createTempProjectIfNeededAndRunChecks(internalAdminAuth, checkIds, projectKey, fromBundleArchive, currentlyBundling, logTailBuilder);
                projectStandardsRunReport.totalDurationMs = totalStopWatch.elapsed(TimeUnit.MILLISECONDS);
                if (fromBundleArchive == null && scope != null) {
                    logger.infoV("Saving last report of project %s", new Object[]{projectKey});
                    ProjectStandardsService.this.saveLastReport(projectStandardsRunReport);
                    ProjectStandardsService.this.fillRequesterDisplayName(projectStandardsRunReport);
                }
                return projectStandardsRunReport;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"project-standards-checks-run", (String)"Run project standards checks");
            }

            public SmartLogTail getLog() {
                return logTailBuilder.get();
            }
        }, 0L, new TypeToken<FutureResponse<ProjectStandardsRunReport>>(){});
    }

    /*
     * Exception decompiling
     */
    private Map<String, ProjectStandardsCheckRunInfo> createTempProjectIfNeededAndRunChecks(DSSAuthCtx internalAdminAuth, List<String> checkIds, String projectKey, @Nullable File fromBundleArchive, boolean currentlyBundling, DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean shouldCreateTemporaryProject(String projectKey, @Nullable File fromBundleArchive, boolean currentlyBundling) {
        if (fromBundleArchive == null) {
            return false;
        }
        List noTempProjects = DKUApp.getParams().getCSVParamAsList(DONT_CREATE_TEMP_PROJECT_FOR_PROJECT_KEYS_CONFIG_KEY);
        if (currentlyBundling) {
            if (noTempProjects.contains(projectKey)) {
                return false;
            }
            return DKUApp.getParams().getBoolParam(CREATE_TEMP_PROJECT_FOR_BUNDLING_CONFIG_KEY, true);
        }
        if (noTempProjects.contains(projectKey)) {
            throw ErrorContext.iaef((String)"Running Project Standards on bundles of the project %s is currently not allowed. Contact your administrator.", (Object)projectKey, (Object[])new Object[0]);
        }
        if (!DKUApp.getParams().getBoolParam(ALLOW_RUNNING_ON_BUNDLES_CONFIG_KEY, true)) {
            throw ErrorContext.iae((String)"Running Project Standards on bundles is currently not allowed. Contact your administrator.");
        }
        return true;
    }

    private int getExecutionTimeoutMinutes() throws IOException {
        int executionTimeoutMinutes = this.getGeneralParametersUnsafe().executionTimeoutMinutes;
        int maxExecutionTimeoutMinutes = DKUApp.getParams().getIntParam(MAX_EXECUTION_TIMEOUT_MINUTES_CONFIG_KEY, Integer.valueOf(120));
        if (executionTimeoutMinutes > maxExecutionTimeoutMinutes) {
            logger.warnV("The configured execution timeout (%s min) is above the maximum allowed execution timeout (%s min), capping it to the max", new Object[]{executionTimeoutMinutes, maxExecutionTimeoutMinutes});
            return maxExecutionTimeoutMinutes;
        }
        return executionTimeoutMinutes;
    }

    public FutureResponse<ProjectStandardsRunReport> runAndWait_NT(AuthCtx authCtx, String projectKey, @Nullable List<String> checkIds, @Nullable File fromBundleArchive, boolean currentlyBundling) throws Exception {
        return this.futureService.waitForFinalResponse(this.run_NT(authCtx, projectKey, checkIds, fromBundleArchive, currentlyBundling));
    }

    @Nonnull
    private Map<String, List<ProjectStandardsCheckRunRequest>> getChecksRunRequestsByPlugin(String originalProjectKey, ProjectStandardsCheckRunRequest.ProjectParams projectParams, @Nonnull List<String> checkIds) throws IOException {
        DSSAuthCtx internalAdminUser = DSSAuthCtx.internalAdminAuth();
        String clusterId = new ClusterSelector().getBuiltinOrDefaultClusterId(Cluster.ClusterArchitecture.KUBERNETES);
        String containerConfName = new ContainerExecConfigSelector().selectName_autoTXN(null, this.getGeneralParametersUnsafe().containerSelection, WorkloadType.USER_CODE);
        logger.infoV("Requesting execution of checks %s", new Object[]{String.join((CharSequence)", ", checkIds)});
        List<ProjectStandardsCheck> bundleChecks = this.getChecksUnsafe();
        ArrayList unknownChecks = new ArrayList();
        HashMap pluginParamsMap = new HashMap();
        Map<String, List<ProjectStandardsCheckRunRequest>> checkRunsByPlugin = checkIds.stream().flatMap(checkId -> {
            Optional<ProjectStandardsCheck> checkOptional = bundleChecks.stream().filter(bundleCheck -> Objects.equals(bundleCheck.id, checkId)).findFirst();
            if (checkOptional.isEmpty()) {
                unknownChecks.add(checkId);
            }
            return checkOptional.stream().map(check -> this.toProjectStandardsCheckRunRequest(originalProjectKey, (ProjectStandardsCheck)check, projectParams, pluginParamsMap, internalAdminUser, containerConfName, clusterId));
        }).collect(Collectors.groupingBy(ProjectStandardsCheckRunRequest::getPluginId));
        if (!unknownChecks.isEmpty()) {
            logger.warnV("The following checks could not be found in project standards library: %s", new Object[]{String.join((CharSequence)", ", unknownChecks)});
        }
        return checkRunsByPlugin;
    }

    @Nonnull
    private ProjectStandardsCheckRunRequest toProjectStandardsCheckRunRequest(String projectKey, ProjectStandardsCheck check, ProjectStandardsCheckRunRequest.ProjectParams projectParams, Map<String, ProjectStandardsCheckRunRequest.PluginParams> pluginParamsMap, DSSAuthCtx internalAdminUser, String containerConfName, String clusterId) {
        ProjectStandardsCheckRunRequest runRequest = new ProjectStandardsCheckRunRequest(projectParams, check, containerConfName, clusterId);
        try {
            LoadedPythonPluginProjectStandardsCheckSpec desc = (LoadedPythonPluginProjectStandardsCheckSpec)this.pythonPluginProjectStandardsService.getLoadedDescByElementType(check.checkElementType);
            if (desc == null) {
                throw new NotFoundException(String.format("Check %s (%s) refers to a plugin component with id '%s' that is not installed.", check.name, check.id, check.checkElementType));
            }
            String pluginId = desc.getOwnerPluginId();
            ProjectStandardsCheckRunRequest.PluginParams pluginParams = pluginParamsMap.get(pluginId);
            if (pluginParams == null) {
                PluginSettings settings = new PluginSettingsResolver(internalAdminUser, projectKey).getAndMergePluginSettings(pluginId);
                pluginParams = new ProjectStandardsCheckRunRequest.PluginParams(pluginId, settings);
                pluginParamsMap.put(pluginId, pluginParams);
            }
            runRequest.pluginParams = pluginParams;
            PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.pythonPluginProjectStandardsService.getExpandedPluginSettings(check.checkElementType, internalAdminUser, projectKey, check.checkParams);
            runRequest.checkParams = expandedPluginSettings.config;
            runRequest.codeFileRelativePath = this.pythonPluginProjectStandardsService.getCodeFileRelativePathInPluginFolder(check.checkElementType);
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Error while retrieving run request configuration for %s", new Object[]{check.checkParams});
            runRequest.error = e;
        }
        return runRequest;
    }

    private Map<String, ProjectStandardsCheckRunInfo> runChecks(Map<String, List<ProjectStandardsCheckRunRequest>> checkRunRequestsByPlugin, DKUtils.SmartLogTailBuilder logTailBuilder, long executionTimeoutMinutes) throws InterruptedException {
        logger.infoV("Starting checks run", new Object[0]);
        HashMap<String, ProjectStandardsCheckRunInfo> checksRunInfo = new HashMap<String, ProjectStandardsCheckRunInfo>();
        for (Map.Entry<String, List<ProjectStandardsCheckRunRequest>> entry : checkRunRequestsByPlugin.entrySet()) {
            List<ProjectStandardsCheckRunRequest> checkRunRequestsForAPlugin = entry.getValue();
            logger.infoV("Loading %d checks from plugin %s", new Object[]{checkRunRequestsForAPlugin.size(), entry.getKey()});
            for (ProjectStandardsCheckRunRequest checkRunRequest : checkRunRequestsForAPlugin) {
                Stopwatch checkStopWatch = Stopwatch.createStarted();
                ProjectStandardsCheckRunResult runResult = this.executeCheck(checkRunRequest, logTailBuilder, executionTimeoutMinutes);
                ProjectStandardsCheckRunInfo runInfo = new ProjectStandardsCheckRunInfo();
                runInfo.check = checkRunRequest.check;
                runInfo.result = runResult;
                runInfo.expandedCheckParams = checkRunRequest.checkParams;
                runInfo.durationMs = checkStopWatch.elapsed(TimeUnit.MILLISECONDS);
                checksRunInfo.put(checkRunRequest.check.id, runInfo);
                FutureProgress.incrementState((double)1.0);
            }
        }
        return checksRunInfo;
    }

    private void instantiateTemporaryProjectForRun_NT(String sourceProjectKey, ProjectStandardsTemporaryProject temporaryProject, @Nullable File fromBundleArchive, AutoDelete workDir, DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        File bundleArchive = this.bundleProjectIfNeeded(sourceProjectKey, temporaryProject, fromBundleArchive, workDir);
        this.createTemporaryProjectFromBundle_NT(temporaryProject, bundleArchive);
        FutureProgress.incrementState((double)1.0);
        this.activateBundleInTemporaryProject_NT(temporaryProject, bundleArchive, logTailBuilder);
        FutureProgress.incrementState((double)1.0);
    }

    private File bundleProjectIfNeeded(String sourceProjectKey, ProjectStandardsTemporaryProject temporaryProject, @Nullable File fromBundleArchive, AutoDelete workDir) throws Exception {
        File bundleArchive = DKUFileUtils.getWithin((File)workDir, (String[])new String[]{"bundle.zip"});
        if (fromBundleArchive != null) {
            logger.infoV("Copying existing bundle located at %s to %s", new Object[]{fromBundleArchive.getAbsolutePath(), bundleArchive.getAbsolutePath()});
            FileUtils.copyFile((File)fromBundleArchive, (File)bundleArchive);
        } else {
            try (FutureProgress.AutocloseableFutureProgressState f = FutureProgress.pushAutoCloseableState((String)"Bundling current project", (double)15.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                logger.infoV("Bundling current project to archive %s", new Object[]{bundleArchive.getAbsolutePath()});
                ProjectBundleExporter peo = new ProjectBundleExporter(temporaryProject.owner, new BundleExporterSettings(), null, new ExportedProject.ExportUserInfo(), sourceProjectKey, GENERATED_BUNDLE_ID, null, null, null, bundleArchive, false);
                peo.export();
            }
            FutureProgress.incrementState((double)1.0);
        }
        return bundleArchive;
    }

    private void createTemporaryProjectFromBundle_NT(ProjectStandardsTemporaryProject temporaryProject, File bundleArchive) throws Exception {
        SerializedProject projectToCreate = ZipUtils.readFileContentJSON(bundleArchive, "project_config/params.json", SerializedProject.class);
        if (projectToCreate == null) {
            throw new IllegalArgumentException("Could not read project config file in bundle archive");
        }
        projectToCreate.projectKey = temporaryProject.projectKey;
        projectToCreate.projectType = SerializedProject.ProjectType.PROJECT_STANDARDS;
        projectToCreate.bundleContainerSettings = new BundleContainerSettings();
        projectToCreate.bundleExporterSettings = null;
        projectToCreate.owner = temporaryProject.owner.getIdentifier();
        projectToCreate.settings.useRemoteGit = null;
        projectToCreate.permissions = new ArrayList<SerializedProject.PermissionItem>();
        projectToCreate.settings.limitedVisibilityEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.DISABLED;
        projectToCreate.settings.accessRequestsEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.DISABLED;
        projectToCreate.settings.sharingRequestsEnabled = GeneralSettingsDAO.InheritableEnabledSetting.LocalValue.DISABLED;
        String targetProjectFolderId = this.projectFoldersService.ensureProjectStandardsFolder_NT(temporaryProject.owner);
        try (RWTransaction rwt = this.transactionService.beginWriteAsLoggedInUser((AuthCtx)temporaryProject.owner);){
            logger.infoV("Creating temporary project %s", new Object[]{temporaryProject.projectKey});
            this.projectsService.create(projectToCreate, TaggableObjectChangedEvent.ProjectEditSubtype.UNKNOWN, targetProjectFolderId);
            rwt.commit("Imported project " + projectToCreate.projectKey + " from bundle");
        }
        temporaryProject.projectCreated = true;
    }

    private void activateBundleInTemporaryProject_NT(ProjectStandardsTemporaryProject temporaryProject, File bundleArchive, DKUtils.SmartLogTailBuilder logTailBuilder) throws Exception {
        logger.infoV("Activating bundle located at %s in temporary project %s", new Object[]{bundleArchive.getAbsolutePath(), temporaryProject.projectKey});
        if (ApplicationConfigurator.isAutomation()) {
            ((AutomationBundlesService)SpringUtils.getBean(AutomationBundlesService.class)).activateBundle_NT(temporaryProject.owner, temporaryProject.projectKey, bundleArchive, new AbstractBundleService.BundleActivationOptions(), logTailBuilder);
        } else {
            ((DesignBundlesService)SpringUtils.getBean(DesignBundlesService.class)).activateBundle_NT(temporaryProject.owner, temporaryProject.projectKey, bundleArchive, new AbstractBundleService.BundleActivationOptions(), logTailBuilder);
        }
    }

    @Nonnull
    private ProjectStandardsCheckRunResult executeCheck(ProjectStandardsCheckRunRequest checkRunRequest, DKUtils.SmartLogTailBuilder logTailBuilder, long executionTimeoutMinutes) throws InterruptedException {
        ProjectStandardsKernelPool.CheckResultResponse checkResultResponse;
        if (checkRunRequest.error != null) {
            String errorMessage = checkRunRequest.error.getMessage();
            logger.errorV("Loading of check %s (%s) failed with error: %s", new Object[]{checkRunRequest.check.name, checkRunRequest.check.id, errorMessage});
            ProjectStandardsCheckRunResult errorResult = ProjectStandardsCheckRunResult.createErrorResult(errorMessage, null);
            logTailBuilder.appendLine(String.format("Loading of check %s (%s) failed with error: %s", checkRunRequest.check.name, checkRunRequest.check.id, errorMessage));
            return errorResult;
        }
        try {
            logger.infoV("Requesting execution of check %s (%s)", new Object[]{checkRunRequest.check.name, checkRunRequest.check.id});
            checkResultResponse = this.kernelPool.runCheck(checkRunRequest, executionTimeoutMinutes);
        }
        catch (TimeoutException e) {
            logger.errorV("Execution of check %s (%s) timed out, exceeded %d minutes", new Object[]{checkRunRequest.check.name, checkRunRequest.check.id, executionTimeoutMinutes});
            ProjectStandardsCheckRunResult errorResult = ProjectStandardsCheckRunResult.createErrorResult("Execution timed out", null);
            logTailBuilder.appendLine(String.format("Check %s (%s) timed out, exceeded %d minutes", checkRunRequest.check.name, checkRunRequest.check.id, executionTimeoutMinutes));
            return errorResult;
        }
        catch (InterruptedException e) {
            logger.errorV("Execution of check %s (%s) interrupted. Interrupting the whole run", new Object[]{checkRunRequest.check.name, checkRunRequest.check.id});
            throw e;
        }
        catch (Exception e) {
            String errorMessage = e.getMessage();
            logger.errorV((Throwable)e, "Execution of check %s (%s) failed with Java exception. %s", new Object[]{checkRunRequest.check.name, checkRunRequest.check.id, errorMessage});
            ProjectStandardsCheckRunResult errorResult = ProjectStandardsCheckRunResult.createErrorResult(errorMessage, null);
            logTailBuilder.appendLine(String.format("Check %s (%s) returned Java error: %s", checkRunRequest.check.name, checkRunRequest.check.id, errorMessage));
            return errorResult;
        }
        ProjectStandardsCheckRunResult checkRunResult = checkResultResponse.checkRunResult;
        if (checkRunResult == null) {
            String errorMessage = checkResultResponse.error;
            logger.errorV("Execution of check %s (%s) failed with python exception. %s", new Object[]{checkRunRequest.check.name, checkRunRequest.check.id, errorMessage});
            ProjectStandardsCheckRunResult errorResult = ProjectStandardsCheckRunResult.createErrorResult(errorMessage, null);
            logTailBuilder.appendLine(String.format("Check %s (%s) returned python error: %s", checkRunRequest.check.name, checkRunRequest.check.id, errorMessage));
            return errorResult;
        }
        if (checkRunResult.hasInvalidSeverity()) {
            String errorMessage = String.format("Check %s (%s) returned invalid severity: %s. Check marked as error.", checkRunRequest.check.name, checkRunRequest.check.id, checkRunResult.severity);
            logger.errorV(errorMessage, new Object[0]);
            ProjectStandardsCheckRunResult errorResult = ProjectStandardsCheckRunResult.createErrorResult(String.format("Check returned invalid severity: %s", checkRunResult.severity), null);
            logTailBuilder.appendLine(errorMessage);
            return errorResult;
        }
        logger.infoV("Result of check %s (%s) is %s", new Object[]{checkRunRequest.check.name, checkRunRequest.check.id, checkRunResult});
        logTailBuilder.appendLine(String.format("Check %s (%s) returned result: %s", checkRunRequest.check.name, checkRunRequest.check.id, checkRunResult));
        return checkRunResult;
    }

    @Nullable
    public ProjectStandardsRunReport getLastReport(String projectKey) throws IOException {
        File reportFile = ProjectStandardsReportPaths.lastReportFile(projectKey);
        if (reportFile.exists()) {
            ProjectStandardsRunReport report = (ProjectStandardsRunReport)JSON.parseFile((File)reportFile, ProjectStandardsRunReport.class);
            this.fillRequesterDisplayName(report);
            return report;
        }
        return null;
    }

    private void fillRequesterDisplayName(ProjectStandardsRunReport report) {
        try {
            report.requesterDisplayName = this.usersService.getPublicUser((String)report.requester).displayName;
        }
        catch (IOException e) {
            logger.warnV((Throwable)e, "Failed to get public user for login %s, setting %s as requesterDisplayName", new Object[]{report.requester, report.requester});
            report.requesterDisplayName = report.requester;
        }
    }

    private void saveLastReport(ProjectStandardsRunReport newReport) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)newReport.projectKey), (Object)"Project key is not specified");
        Preconditions.checkNotNull((Object)newReport.scope, (Object)"You can only save a report associated to a scope");
        JSON.prettyToFile((Object)newReport, (File)ProjectStandardsReportPaths.lastReportFile(newReport.projectKey));
    }
}

