/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.queries;

import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SQLServerConnection;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryResultSet;
import com.dataiku.dip.connections.bigquery.builtin.BigQueryStatement;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.hive.HiveServer2ConnectionPoolService;
import com.dataiku.dip.hive.HiveValidationTools;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.hive.HiveRecipeTester;
import com.dataiku.dip.recipes.code.impala.ImpalaExecutor;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.Splitter;
import com.dataiku.dip.sqlnotebooks.SQLNotebookQuery;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DKUNumberUtils;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.google.cloud.bigquery.JobStatistics;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExecutionPlanService {
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private HiveServer2ConnectionPoolService hiveServer2ConnectionPoolService;
    @Autowired
    private GenericRecipesValidationService validationService;
    @Autowired
    private VariablesService variablesService;
    static Logger logger = Logger.getLogger((String)"dku.queries.executionplan");

    public ExecutionPlanService() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public Callable<ExecutionPlan> getSqlExecutionPlan(final SerializedRecipe sa, final String query, final AuthCtx authCtx) throws Exception {
        final Dataset source = this.getExecutionPlanSourceDataset(sa, false);
        return new Callable<ExecutionPlan>(){

            @Override
            public ExecutionPlan call() throws Exception {
                SQLConnectionProvider.SQLConnectionData connData = DatasetInspector.getSQLConnectionForSQLAbleDatasetOrHive(authCtx, source);
                try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connData, authCtx, sa.getProjectKey());){
                    ExecutionPlan executionPlan = ExecutionPlanService.this.getExecutionPlan(conn, connData, query);
                    return executionPlan;
                }
            }
        };
    }

    public Callable<ExecutionPlan> getSqlExecutionPlan(final SQLNotebookQuery query, final String projectKey, final AuthCtx authCtx) throws Exception {
        VariablesContext vc = this.variablesService.getContext(projectKey);
        final String sql = query.getExpandedSql(vc);
        return new Callable<ExecutionPlan>(){

            @Override
            public ExecutionPlan call() throws Exception {
                SQLConnectionProvider.SQLConnectionData connData = SQLConnectionProvider.getConnectionData_NT(authCtx, projectKey, query.connection);
                try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connData, authCtx, projectKey);){
                    ExecutionPlan executionPlan = ExecutionPlanService.this.getExecutionPlan(conn, connData, sql);
                    return executionPlan;
                }
            }
        };
    }

    public ExecutionPlan getImpalaExecutionPlan(SerializedRecipe sa, String query, AuthCtx authCtx) throws Exception {
        return this.getImpalaExecutionPlan(sa, query, authCtx, null);
    }

    public ExecutionPlan getHiveExecutionPlan(SerializedRecipe sa, String query, AuthCtx authCtx, HiveRecipeMeta.HiveRecipeParams hive) throws Exception {
        if (hive.executionEngine == HiveRecipeMeta.HiveExecutionEngine.HIVECLI_LOCAL) {
            HiveRecipeTester.HiveCheckContext ctx;
            SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> subgraphCallable;
            HiveRecipeTester tester = new HiveRecipeTester();
            try (Transaction t = this.transactionService.beginRead();){
                FlowGraph graph = new FlowGraph();
                FlowRecipe frecipe = graph.buildSingleRecipe(sa);
                subgraphCallable = this.validationService.getValidationRunnableSubgraph(authCtx, frecipe, null);
            }
            RecipeRunnableSubgraph subgraph = subgraphCallable.call_NT();
            try (Transaction t = this.transactionService.beginRead();){
                sa.params = hive;
                ctx = tester.startCheckHive(authCtx, sa, hive, true, "explain " + query, subgraph);
            }
            if (ctx.proceed) {
                tester.doCheckHive_NT(ctx);
                if (ctx.proceed) {
                    HiveValidationTools.removeIrrelevantMessages(ctx.rawHiveResponse, ctx.preprocessor);
                    HiveValidationTools.copyMessagesToEnriched(ctx.rawHiveResponse, ctx.status.topLevelMessages);
                    if (ctx.rawHiveResponse.ok) {
                        return ExecutionPlanService.formatTextPlan(ctx.rawHiveResponse.plan);
                    }
                }
            }
            throw new Exception("Failed to get Hive execution plan (" + String.valueOf(ctx.status.gatherAllMessages().firstFatal()));
        }
        Dataset source = this.getExecutionPlanSourceDataset(sa, true);
        String dbName = HiveSchemaHandler.getResolvedHiveDatabaseFromDataset(source);
        return this.getHiveExecutionPlan(sa.projectKey, dbName, query, hive, authCtx);
    }

    public ExecutionPlan getImpalaExecutionPlan(SerializedRecipe sa, String query, AuthCtx authCtx, ImpalaExecutor.ImpalaExecutorParams impala) throws Exception {
        Dataset source = this.getExecutionPlanSourceDataset(sa, true);
        String hiveDatabase = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(source).getSchemaNullIfBlank();
        ImpalaConnection connection = ImpalaConfigurator.configureConnectionForDatabase(authCtx, hiveDatabase);
        SQLConnectionProvider.SQLConnectionData connData = connection.getConnectionData_NT(authCtx, sa.getProjectKey());
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connData, authCtx, sa.getProjectKey());){
            ExecutionPlan executionPlan = this.getExecutionPlan(conn, connData, query);
            return executionPlan;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionPlan getExecutionPlan(SQLConnectionProvider.SQLConnectionWrapper conn, SQLConnectionProvider.SQLConnectionData connData, String script) throws SQLException {
        Splitter splitter;
        String[] statementSqls;
        int selectStatementIndex;
        if (connData.getType() == ConnectionUtils.SQLConnectionType.JDBC) {
            logger.warn((Object)("Execution plan not implemented for " + String.valueOf((Object)connData.getType())));
            return null;
        }
        logger.info((Object)"Compute execution plan");
        if (TransactionContext.hasAttachedTransaction()) {
            logger.warn((Object)"Computing execution plan inside a transaction");
        }
        if ((selectStatementIndex = SQLUtils.findLastSelectStatement(statementSqls = (splitter = new Splitter(connData.getDialect().getSemicolonExclusionPortionFinders())).split(script), splitter)) < 0) {
            logger.info((Object)"SELECT statement not found, assuming it's the last one");
            selectStatementIndex = statementSqls.length - 1;
        }
        String query = statementSqls[selectStatementIndex];
        for (int i = 0; i < selectStatementIndex; ++i) {
            String statementSql = statementSqls[i];
            if (SQLUtils.isDMLStatement(statementSql = splitter.stripComments(statementSql).trim())) continue;
            try (Statement stmt = conn.createStatement();){
                logger.info((Object)("Executing pre-query statement : " + statementSql));
                stmt.execute(statementSql);
                continue;
            }
        }
        try {
            ExecutionPlan plan = null;
            switch (connData.getType()) {
                case DATABRICKSLAKEBASE: 
                case POSTGRESQL: 
                case ALLOYDB: 
                case GREENPLUM: 
                case REDSHIFT: 
                case VERTICA: 
                case H2: 
                case IMPALA: 
                case HIVESERVER2: 
                case DATABRICKS: 
                case TREASUREDATA: 
                case TERADATA: {
                    plan = ExecutionPlanService.getGenericExecutionPlan(conn, connData, query);
                    break;
                }
                case MYSQL: {
                    plan = ExecutionPlanService.getMySQLExecutionPlan(conn, connData, query);
                    break;
                }
                case ORACLE: {
                    plan = ExecutionPlanService.getOracleExecutionPlan(conn, connData, query);
                    break;
                }
                case SNOWFLAKE: {
                    plan = ExecutionPlanService.getSnowflakeExecutionPlan(conn, connData, query);
                    break;
                }
                case SQLSERVER: {
                    if (((SQLServerConnection)connData.getConnection()).params.azureDWH) {
                        plan = ExecutionPlanService.getSynapseExecutionPlan(conn, connData, query);
                        break;
                    }
                    plan = ExecutionPlanService.getSQLServerExecutionPlan(conn, query);
                    break;
                }
                case SYNAPSE: {
                    plan = ExecutionPlanService.getSynapseExecutionPlan(conn, connData, query);
                    break;
                }
                case NETEZZA: {
                    plan = ExecutionPlanService.getNetezzaExecutionPlan(conn, connData, query);
                    break;
                }
                case SAPHANA: {
                    plan = ExecutionPlanService.getSAPHANAExecutionPlan(conn, connData, query);
                    break;
                }
                case BIGQUERY: {
                    plan = ExecutionPlanService.getBigQueryExecutionPlan(conn, query);
                    break;
                }
                case SPARK_SQL_DATABRICKS: 
                case SPARKLIVY: 
                case ATHENA: 
                case TRINO: 
                case DENODO: 
                case KDBPLUS: 
                case JDBC: 
                case FABRIC_WAREHOUSE: {
                    logger.info((Object)("No execution plan available for connection type " + String.valueOf((Object)connData.getType())));
                }
            }
            if (plan != null) {
                plan.setDbType(connData.getType().toString());
                plan.setQuery(query);
            }
            TextPlan textPlan = plan;
            return textPlan;
        }
        finally {
            for (int i = selectStatementIndex + 1; i < statementSqls.length; ++i) {
                String statementSql = statementSqls[i];
                if (SQLUtils.isDMLStatement(statementSql = splitter.stripComments(statementSql).trim())) continue;
                try (Statement stmt = conn.createStatement();){
                    logger.info((Object)("Executing post-query statement : " + statementSql));
                    stmt.execute(statementSql);
                    continue;
                }
            }
        }
    }

    private Dataset getExecutionPlanSourceDataset(SerializedRecipe sa, boolean useHive) throws IOException {
        if (sa.getInputsForRole("main").size() == 0) {
            throw ErrorContext.iaef((String)"Recipe '%s' has no inputs", (Object)sa.name, (Object[])new Object[0]);
        }
        Dataset source = this.getFirstInput(sa);
        if (DatasetInspector.canHive(source)) {
            if (!useHive) {
                throw ErrorContext.iaef((String)"Recipe '%s' cannot handle HDFS/Hive input", (Object)sa.name, (Object[])new Object[0]);
            }
        } else if (useHive) {
            throw ErrorContext.iaef((String)"Recipe '%s' cannot handle non-HDFS/Hive input", (Object)sa.name, (Object[])new Object[0]);
        }
        return source;
    }

    private Dataset getFirstInput(SerializedRecipe sa) throws IOException {
        DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(sa.projectKey, sa.getInputsForRole((String)"main").get((int)0).ref);
        if (TransactionContext.hasAttachedTransaction()) {
            return this.datasetAccessService.getMandatory(loc);
        }
        try (Transaction t = this.transactionService.beginRead();){
            Dataset dataset = this.datasetAccessService.getMandatory(loc);
            return dataset;
        }
    }

    private ExecutionPlan getHiveExecutionPlan(String projectKey, String dbname, String query, HiveRecipeMeta.HiveRecipeParams hive, AuthCtx authCtx) throws Exception {
        List<SimpleKeyValue> resolvedHiveConf = new HiveConfHelper().getResolvedConf(authCtx, projectKey, hive);
        HiveConnection connection = HiveConfigurator.configureConnectionForDatabase(authCtx, dbname, resolvedHiveConf, this.hiveServer2ConnectionPoolService);
        SQLConnectionProvider.SQLConnectionData connData = connection.getConnectionData_NT(authCtx, projectKey);
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connData, authCtx, projectKey);){
            ExecutionPlan executionPlan = this.getExecutionPlan(conn, connData, query);
            return executionPlan;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized TabularPlan getSQLServerExecutionPlan(SQLConnectionProvider.SQLConnectionWrapper conn, String query) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            TabularPlan tabularPlan;
            String option = "SHOWPLAN_ALL";
            stmt.execute("SET " + option + " ON");
            try {
                ResultSet rs2 = stmt.executeQuery(query);
                tabularPlan = ExecutionPlanService.formatTabularPlan(rs2);
            }
            catch (Throwable throwable) {
                stmt.execute("SET " + option + " OFF");
                throw throwable;
            }
            stmt.execute("SET " + option + " OFF");
            return tabularPlan;
        }
    }

    private static TextPlan getSynapseExecutionPlan(SQLConnectionProvider.SQLConnectionWrapper conn, SQLConnectionProvider.SQLConnectionData connData, String query) throws SQLException {
        boolean autocommitMode;
        boolean bl = autocommitMode = "Synapse".equals(connData.getConnection().type) || connData.getConnection().getParams().autocommitMode;
        if (!autocommitMode) {
            conn.setAutoCommit(true);
        }
        try {
            TextPlan textPlan;
            block14: {
                try {
                    if (!autocommitMode) {
                        SQLUtils.safeExec(conn, "ROLLBACK TRANSACTION");
                    }
                }
                catch (SQLException e) {
                    logger.info((Object)("Rollback failed pre-execution plan, ignoring: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                }
                Statement stmt = conn.createStatement();
                try {
                    ResultSet rs2 = stmt.executeQuery("EXPLAIN " + query);
                    textPlan = ExecutionPlanService.formatSynapsePlan(rs2);
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return textPlan;
        }
        finally {
            if (!autocommitMode) {
                conn.setAutoCommit(false);
            }
        }
    }

    private static synchronized TextPlan getOracleExecutionPlan(SQLConnectionProvider.SQLConnectionWrapper conn, SQLConnectionProvider.SQLConnectionData connData, String query) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            String explainQuery = "EXPLAIN PLAN FOR " + query;
            stmt.execute(explainQuery);
            ResultSet rs2 = stmt.executeQuery("SELECT * FROM table(DBMS_XPLAN.DISPLAY)");
            TextPlan textPlan = ExecutionPlanService.formatTextPlan(rs2);
            return textPlan;
        }
    }

    private static synchronized ExecutionPlan getSAPHANAExecutionPlan(SQLConnectionProvider.SQLConnectionWrapper conn, SQLConnectionProvider.SQLConnectionData connData, String query) throws SQLException {
        String stmtName = "dku_xpln_" + DKUDateUtils.isoFormatFileFriendlyLocalNow() + "_" + SecretKeyGenerator.generate((int)8);
        try (Statement stmt = conn.createStatement();){
            String explainQuery = "EXPLAIN PLAN SET STATEMENT_NAME='" + stmtName + "' FOR " + query;
            stmt.execute(explainQuery);
            ResultSet rs2 = stmt.executeQuery("SELECT * FROM explain_plan_table WHERE statement_name = '" + stmtName + "'");
            TabularPlan tabularPlan = ExecutionPlanService.formatTabularPlan(rs2);
            return tabularPlan;
        }
    }

    private static TextPlan getGenericExecutionPlan(SQLConnectionProvider.SQLConnectionWrapper conn, SQLConnectionProvider.SQLConnectionData connData, String query) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            TextPlan textPlan;
            block12: {
                String explainQuery = "EXPLAIN " + query;
                logger.info((Object)("Execution plan query: \n" + explainQuery));
                ResultSet rs2 = stmt.executeQuery(explainQuery);
                try {
                    textPlan = ExecutionPlanService.formatTextPlan(rs2);
                    if (rs2 == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs2 != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs2.close();
            }
            return textPlan;
        }
    }

    private static TabularPlan getMySQLExecutionPlan(SQLConnectionProvider.SQLConnectionWrapper conn, SQLConnectionProvider.SQLConnectionData connData, String query) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            String explainQuery = "EXPLAIN " + query;
            ResultSet rs2 = stmt.executeQuery(explainQuery);
            TabularPlan tabularPlan = ExecutionPlanService.formatTabularPlan(rs2);
            return tabularPlan;
        }
    }

    private static TextPlan getSnowflakeExecutionPlan(SQLConnectionProvider.SQLConnectionWrapper conn, SQLConnectionProvider.SQLConnectionData connData, String query) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            String explainQuery = "EXPLAIN USING TEXT " + query;
            ResultSet rs2 = stmt.executeQuery(explainQuery);
            TextPlan textPlan = ExecutionPlanService.formatTextPlan(rs2);
            return textPlan;
        }
    }

    private static TextPlan getBigQueryExecutionPlan(SQLConnectionProvider.SQLConnectionWrapper conn, String query) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            if (stmt instanceof BigQueryStatement) {
                BigQueryStatement bqSmtm = (BigQueryStatement)stmt;
                BigQueryResultSet resultSet = (BigQueryResultSet)bqSmtm.executeQuery(query, true);
                TextPlan textPlan = ExecutionPlanService.formatBigQueryTextPlan(resultSet.getQueryStatistics());
                return textPlan;
            }
            logger.warn((Object)"Execution plan not implemented for BigQuery using User-supplied driver");
            TextPlan textPlan = null;
            return textPlan;
        }
    }

    private static TextPlan formatBigQueryTextPlan(JobStatistics.QueryStatistics queryStatistics) {
        if (queryStatistics == null) {
            return null;
        }
        TextPlan result = new TextPlan();
        if (queryStatistics.getTotalBytesProcessed() != null || queryStatistics.getTotalPartitionsProcessed() != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("This query will process ");
            if (queryStatistics.getTotalBytesProcessed() != null) {
                sb.append(DKUNumberUtils.printSmartBytesSize(queryStatistics.getTotalBytesProcessed()));
            }
            if (queryStatistics.getTotalBytesProcessed() != null && queryStatistics.getTotalPartitionsProcessed() != null) {
                sb.append(" and ");
            }
            if (queryStatistics.getTotalPartitionsProcessed() != null) {
                sb.append(queryStatistics.getTotalPartitionsProcessed());
                sb.append(" partition");
                if (queryStatistics.getTotalPartitionsProcessed() != 1L) {
                    sb.append("s");
                }
            }
            sb.append(" when run.");
            result.addStep(sb.toString(), WarningLevel.CLEAR);
        }
        return result;
    }

    private static TextPlan getNetezzaExecutionPlan(SQLConnectionProvider.SQLConnectionWrapper conn, SQLConnectionProvider.SQLConnectionData connData, String query) throws SQLException {
        TextPlan tp = new TextPlan();
        try (Statement stmt = conn.createStatement();){
            String explainQuery = "EXPLAIN PLANTEXT " + query;
            logger.info((Object)("Execution plan query: \n" + explainQuery));
            stmt.execute(explainQuery);
            SQLWarning warning = stmt.getWarnings();
            if (warning == null) {
                tp.addStep("No plan returned", WarningLevel.CLEAR);
            } else {
                for (String line : StringUtils.split((String)warning.getMessage(), (String)"\n")) {
                    tp.addStep(line, WarningLevel.CLEAR);
                }
            }
            TextPlan textPlan = tp;
            return textPlan;
        }
    }

    private static TextPlan formatTextPlan(ResultSet rs2) throws SQLException {
        TextPlan plan = new TextPlan();
        while (rs2.next()) {
            assert (rs2.getMetaData().getColumnCount() == 1);
            WarningLevel warn = null;
            String line = rs2.getString(1);
            if (StringUtils.isNotBlank((String)line)) {
                if (line.toLowerCase().contains("nested loop")) {
                    warn = WarningLevel.WARNING;
                } else if (line.contains("Hash") || line.contains("HASH")) {
                    warn = WarningLevel.CLEAR;
                }
            }
            plan.addStep(line, warn);
        }
        plan.db = "HIVE";
        return plan;
    }

    /*
     * WARNING - void declaration
     */
    private static TextPlan formatSynapsePlan(ResultSet rs2) throws SQLException {
        TextPlan plan = new TextPlan();
        while (rs2.next()) {
            assert (rs2.getMetaData().getColumnCount() == 1);
            String data = rs2.getString(1);
            if (!StringUtils.isNotBlank((String)data)) continue;
            for (String string : StringUtils.split((String)data, (String)"\r\n")) {
                void var6_6;
                WarningLevel warn = null;
                if (StringUtils.isBlank((String)string)) continue;
                if (string.toLowerCase().contains("nested loop")) {
                    warn = WarningLevel.WARNING;
                } else if (string.contains("Hash") || string.contains("HASH")) {
                    warn = WarningLevel.CLEAR;
                } else if (string.contains("sql_operation")) {
                    warn = WarningLevel.WARNING;
                }
                if (!string.endsWith("\n") && !string.endsWith("\r")) {
                    String string2 = string + "\n";
                }
                logger.info((Object)("Add step: " + (String)var6_6));
                plan.addStep((String)var6_6, warn);
            }
        }
        return plan;
    }

    private static TextPlan formatTextPlan(List<String> rs2) throws SQLException {
        TextPlan plan = new TextPlan();
        for (String line : rs2) {
            WarningLevel warn = null;
            if (StringUtils.isNotBlank((String)line)) {
                if (line.toLowerCase().contains("nested loop")) {
                    warn = WarningLevel.WARNING;
                } else if (line.contains("Hash") || line.contains("HASH")) {
                    warn = WarningLevel.CLEAR;
                }
            }
            plan.addStep(line, warn);
        }
        plan.db = "HIVE";
        return plan;
    }

    private static TabularPlan formatTabularPlan(ResultSet rs2) throws SQLException {
        TabularPlan plan = new TabularPlan();
        ResultSetMetaData meta = rs2.getMetaData();
        plan.columns = new ArrayList<String>(meta.getColumnCount());
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            plan.columns.add(meta.getColumnName(i));
        }
        while (rs2.next()) {
            WarningLevel warn = null;
            String stepName = rs2.getString(1);
            if (stepName != null) {
                if (stepName.toLowerCase().contains("nested loop")) {
                    warn = WarningLevel.WARNING;
                } else if (stepName.contains("Hash") || stepName.contains("HASH")) {
                    warn = WarningLevel.CLEAR;
                }
            }
            ArrayList<String> step = new ArrayList<String>();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                step.add(rs2.getString(i));
            }
            plan.addStep(step, warn);
        }
        return plan;
    }

    public static interface ExecutionPlan {
        public void setDbType(String var1);

        public void setQuery(String var1);
    }

    static class TextPlan
    implements ExecutionPlan {
        PlanType type = PlanType.TEXT;
        List<GenericPlanStep> steps = new ArrayList<GenericPlanStep>();
        String db;
        String query;

        TextPlan() {
        }

        void addStep(String content, WarningLevel warningLevel) {
            GenericPlanStep step = new GenericPlanStep();
            step.content = content;
            step.warningLevel = warningLevel;
            this.steps.add(step);
        }

        @Override
        public void setDbType(String type) {
            this.db = type;
        }

        @Override
        public void setQuery(String query) {
            this.query = query;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (GenericPlanStep step : this.steps) {
                sb.append(step.content);
                if (step.content.endsWith("\n")) continue;
                sb.append('\n');
            }
            return sb.toString();
        }
    }

    static class TabularPlan
    implements ExecutionPlan {
        PlanType type = PlanType.TABULAR;
        List<TabularPlanStep> steps = new ArrayList<TabularPlanStep>();
        List<String> columns = new ArrayList<String>();
        String db;
        String query;

        TabularPlan() {
        }

        void addStep(List<String> content, WarningLevel warningLevel) {
            TabularPlanStep step = new TabularPlanStep();
            step.content = content;
            step.warningLevel = warningLevel;
            this.steps.add(step);
        }

        @Override
        public void setDbType(String type) {
            this.db = type;
        }

        @Override
        public void setQuery(String query) {
            this.query = query;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (TabularPlanStep step : this.steps) {
                sb.append(StringUtils.join(step.content, (String)"  ;  ")).append('\n');
            }
            return sb.toString();
        }
    }

    static enum WarningLevel {
        WARNING,
        CLEAR;

    }

    static class GenericPlanStep {
        String content;
        WarningLevel warningLevel;

        GenericPlanStep() {
        }
    }

    static class TabularPlanStep {
        List<String> content;
        WarningLevel warningLevel;

        TabularPlanStep() {
        }
    }

    static enum PlanType {
        TEXT,
        TABULAR;

    }

    public static class HiveTableNotFound
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public HiveTableNotFound(String msg) {
            super(msg);
        }
    }
}

