/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.shell;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ShellRecipeHelper {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private TransactionService transactionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.exec.shell.helper");

    public ShellRecipeHelper() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    private Map<String, String> getVariablesForFlow_NT(AuthCtx authCtx, String varPrefix, FlowComputable item) throws IOException, CodedException, DKUSecurityException, InterruptedException {
        HashMap vars = Maps.newHashMap();
        if (item instanceof FlowDataset) {
            Dataset dataset;
            try (Transaction t = this.transactionService.beginRead();){
                dataset = ((FlowDataset)item).getMandatory(this.datasetsDAO);
            }
            vars.put(varPrefix + "_DATASET_ID", dataset.getName());
            CodeBasedRecipeDatasetInfoHelper.LocationInfo info = new CodeBasedRecipeDatasetInfoHelper().getDatasetLocationInfo_NT(authCtx, dataset, false);
            if (info.info.containsKey("path") && info.info.get("path") instanceof String) {
                if (info.locationInfoType == CodeBasedRecipeDatasetInfoHelper.LocationInfoType.FS) {
                    vars.put(varPrefix + "_DATASET_FS_PATH", (String)info.info.get("path"));
                }
                if (info.locationInfoType == CodeBasedRecipeDatasetInfoHelper.LocationInfoType.HDFS) {
                    vars.put(varPrefix + "_DATASET_HDFS_PATH", (String)info.info.get("path"));
                }
                if (info.locationInfoType == CodeBasedRecipeDatasetInfoHelper.LocationInfoType.UPLOADED) {
                    vars.put(varPrefix + "_DATASET_UPLOADED_PATH", (String)info.info.get("path"));
                }
            }
        } else if (item instanceof FlowManagedFolder) {
            ManagedFolder odb = ((FlowManagedFolder)item).getManagedFolder();
            vars.put(varPrefix + "_FOLDER_ID", odb.id);
            CodeBasedRecipeDatasetInfoHelper.LocationInfo info = CodeBasedRecipeDatasetInfoHelper.getManagedFolderLocationInfo_NT(authCtx, odb, false);
            if (info.info.containsKey("path") && info.info.get("path") instanceof String) {
                if ("Filesystem".equals(odb.getType())) {
                    vars.put(varPrefix + "_FOLDER_PATH", (String)info.info.get("path"));
                } else if ("HDFS".equals(odb.getType())) {
                    vars.put(varPrefix + "_FOLDER_HDFS_PATH", (String)info.info.get("path"));
                }
            }
        } else if (item instanceof FlowSavedModel) {
            SavedModel savedModel = ((FlowSavedModel)item).getSavedModel();
            vars.put(varPrefix + "_SAVEDMODEL_ID", savedModel.id);
        } else if (item instanceof FlowModelEvaluationStore) {
            ModelEvaluationStore modelEvaluationStore = ((FlowModelEvaluationStore)item).getModelEvaluationStore();
            vars.put(varPrefix + "_MODELEVALUATIONSTORE_ID", modelEvaluationStore.id);
        } else if (item instanceof FlowStreamingEndpoint) {
            StreamingEndpoint se = ((FlowStreamingEndpoint)item).getStreamingEndpoint();
            vars.put(varPrefix + "_STREAMINGENDPOINT_ID", se.id);
        }
        return vars;
    }

    public Map<String, String> getVariablesForFlow_NT(AuthCtx authCtx, RecipeRunnableSubgraph subgraph, SerializedRecipe recipe) throws IOException, CodedException, DKUSecurityException, InterruptedException {
        Map<String, FlowComputable> inputToComputable = this.buildRecipeInputToComputableMap(subgraph, recipe);
        Map<String, FlowComputable> outputToComputable = this.buildRecipeOutputToComputableMap(subgraph, recipe);
        HashMap vars = Maps.newHashMap();
        List<SerializedRecipe.RecipeInput> inputs = recipe.getInputsForRole("main");
        for (int index = 0; index < inputs.size(); ++index) {
            String varPrefix = "DKU_INPUT_" + index;
            SerializedRecipe.RecipeInput input = inputs.get(index);
            FlowComputable source = inputToComputable.get(input.getLoc(recipe.projectKey).getFullName());
            if (source != null) {
                vars.putAll(this.getVariablesForFlow_NT(authCtx, varPrefix, source));
                continue;
            }
            logger.info((Object)("The input " + input.ref + " is not computable."));
        }
        List<SerializedRecipe.RecipeOutput> outputs = recipe.getOutputsForRole("main");
        for (int index = 0; index < outputs.size(); ++index) {
            String varPrefix = "DKU_OUTPUT_" + index;
            SerializedRecipe.RecipeOutput output = outputs.get(index);
            FlowComputable target = outputToComputable.get(output.getLoc(recipe.projectKey).getFullName());
            if (target != null) {
                vars.putAll(this.getVariablesForFlow_NT(authCtx, varPrefix, target));
                continue;
            }
            logger.info((Object)("The output " + output.ref + " is not computable."));
        }
        return vars;
    }

    public Map<String, FlowComputable> buildRecipeInputToComputableMap(RecipeRunnableSubgraph subgraph, SerializedRecipe recipe) {
        HashMap computables = Maps.newHashMap();
        List<SerializedRecipe.RecipeInput> inputs = recipe.getInputsForRole("main");
        for (int index = 0; index < inputs.size(); ++index) {
            SerializedRecipe.RecipeInput input = inputs.get(index);
            String fullName = input.getLoc(recipe.projectKey).getFullName();
            FlowComputable source = null;
            for (FlowComputable flowComputable : subgraph.getSources()) {
                if (!flowComputable.getFullId().equals(fullName)) continue;
                source = flowComputable;
            }
            if (source != null) {
                computables.put(fullName, source);
                continue;
            }
            logger.info((Object)("The input " + fullName + " is not computable."));
        }
        return computables;
    }

    public Map<String, FlowComputable> buildRecipeOutputToComputableMap(RecipeRunnableSubgraph subgraph, SerializedRecipe recipe) {
        HashMap computables = Maps.newHashMap();
        List<SerializedRecipe.RecipeOutput> outputs = recipe.getOutputsForRole("main");
        for (int index = 0; index < outputs.size(); ++index) {
            SerializedRecipe.RecipeOutput output = outputs.get(index);
            String fullName = output.getLoc(recipe.projectKey).getFullName();
            FlowComputable source = null;
            for (FlowComputable flowComputable : subgraph.getTargets()) {
                if (!flowComputable.getFullId().equals(fullName)) continue;
                source = flowComputable;
            }
            if (source != null) {
                computables.put(fullName, source);
                continue;
            }
            logger.info((Object)("The output " + fullName + " is not computable."));
        }
        return computables;
    }
}

