/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.customcode;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.pipeline.CustomCodeRecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipeCreator;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipeParams;
import com.dataiku.dip.recipes.customcode.CustomJavaRecipeRunner;
import com.dataiku.dip.recipes.customcode.CustomPysparkRecipeRunner;
import com.dataiku.dip.recipes.customcode.CustomPythonRecipeRunner;
import com.dataiku.dip.recipes.customcode.CustomRRecipeRunner;
import com.dataiku.dip.recipes.customcode.CustomSparkScalaRecipeRunner;
import com.dataiku.dip.recipes.customcode.LoadedCustomCodeRecipeDesc;
import com.dataiku.dip.recipes.customcode.SparkCustomCodeRecipeParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKULogger;

public class CustomCodeRecipeMeta
extends RecipeMeta
implements IPluginifiedMeta {
    private LoadedCustomCodeRecipeDesc desc;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.plugins");

    public CustomCodeRecipeMeta(LoadedCustomCodeRecipeDesc desc) {
        this.desc = desc;
    }

    @Override
    public IElementLoadedDesc getLoadedDesc() {
        return this.desc;
    }

    @Override
    public String getType() {
        return this.desc.recipeType;
    }

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        switch (this.desc.desc.kind) {
            case JAVA: 
            case PYTHON: 
            case R: {
                return CustomCodeRecipeParams.class;
            }
            case PYSPARK: 
            case SPARK_SCALA: {
                return SparkCustomCodeRecipeParams.class;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        switch (this.desc.desc.kind) {
            case JAVA: {
                JobContext.getCurrentActivitySummary().engineType = "DSS";
                return new CustomJavaRecipeRunner(activity);
            }
            case PYTHON: {
                JobContext.getCurrentActivitySummary().engineType = "DSS";
                return new CustomPythonRecipeRunner(activity);
            }
            case R: {
                JobContext.getCurrentActivitySummary().engineType = "DSS";
                return new CustomRRecipeRunner(activity);
            }
            case PYSPARK: {
                JobContext.getCurrentActivitySummary().engineType = "SPARK";
                return new CustomPysparkRecipeRunner(activity);
            }
            case SPARK_SCALA: {
                JobContext.getCurrentActivitySummary().engineType = "SPARK";
                return new CustomSparkScalaRecipeRunner(activity);
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        if (this.desc == null || this.desc.desc == null || this.desc.desc.kind == null) {
            return null;
        }
        switch (this.desc.desc.kind) {
            case SPARK_SCALA: {
                return RecipeMeta.defaultStatusComputer("SPARK", "Spark", "SPARK_SCALA", "Spark Scala", "Spark");
            }
            case PYSPARK: {
                return RecipeMeta.defaultStatusComputer("SPARK", "Spark", "PY_SPARK", "PySpark", "Spark");
            }
            case PYTHON: {
                return RecipeMeta.defaultStatusComputer("PLUGIN_CODE", "Plugin", "PYTHON", "Python", "Python (plugin code)");
            }
            case R: {
                return RecipeMeta.defaultStatusComputer("PLUGIN_CODE", "Plugin", "R", "R", "R (plugin code)");
            }
            case JULIA: {
                return RecipeMeta.defaultStatusComputer("PLUGIN_CODE", "Plugin", "JULIA", "Julia", "Julia (plugin code)");
            }
            case JAVA: {
                return RecipeMeta.defaultStatusComputer("PLUGIN_CODE", "Plugin", "STREAM", "Java", "Java (plugin code)");
            }
        }
        return null;
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        logger.info((Object)"Creating creator for custom recipe");
        return new CustomCodeRecipeCreator(authCtx, this);
    }

    public LoadedCustomCodeRecipeDesc getPluginDesc() {
        return this.desc;
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        return this.desc.desc;
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        switch (this.desc.desc.kind) {
            case PYSPARK: 
            case SPARK_SCALA: {
                return new RecipeMeta.RecipeCategoryFlags().withPlugin().withSpark();
            }
            case JAVA: 
            case PYTHON: 
            case R: {
                return new RecipeMeta.RecipeCategoryFlags().withPlugin();
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public boolean hasJsonPayload() {
        return false;
    }

    @Override
    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        switch (this.desc.desc.kind) {
            case JAVA: 
            case PYTHON: 
            case R: {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_USE_ENGINE, "Spark is not a valid engine for recipe type " + sr.type);
            }
            case PYSPARK: 
            case SPARK_SCALA: {
                return sr.getParamsAs(SparkCustomCodeRecipeParams.class).sparkConfig;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        switch (this.desc.desc.kind) {
            case JAVA: 
            case PYTHON: 
            case R: {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_USE_ENGINE, "Spark is not a valid engine for recipe type " + sr.type);
            }
            case PYSPARK: 
            case SPARK_SCALA: {
                sr.getParamsAs(SparkCustomCodeRecipeParams.class).sparkConfig = config;
                return payload;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public AbstractSparkRecipeParams.SparkExecutionEngine getSparkEngine(SerializedRecipe sr, String payload) {
        switch (this.desc.desc.kind) {
            case JAVA: 
            case PYTHON: 
            case R: {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_USE_ENGINE, "Spark is not a valid engine for recipe type " + sr.type);
            }
            case PYSPARK: 
            case SPARK_SCALA: {
                return sr.getParamsAs(SparkCustomCodeRecipeParams.class).executionEngine;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        switch (this.desc.desc.kind) {
            case JAVA: 
            case PYTHON: 
            case R: {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_CANNOT_USE_ENGINE, "Spark is not a valid engine for recipe type " + sr.type);
            }
            case PYSPARK: 
            case SPARK_SCALA: {
                sr.getParamsAs(SparkCustomCodeRecipeParams.class).executionEngine = executionEngine;
                return payload;
            }
        }
        throw new Error("unreachable");
    }

    @Override
    public RecipePipelineHelper buildPipelineHelper(SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx, JobActivity jobActivity) {
        return new CustomCodeRecipePipelineHelper(authCtx, recipe, payload, pipelineType, jobActivity);
    }
}

