/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.eda.compute.stats.VarianceAssumption;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.Chi2IndTestCard;
import com.dataiku.dip.eda.worksheets.cards.KsTest2SampCard;
import com.dataiku.dip.eda.worksheets.cards.MoodTest2SampCard;
import com.dataiku.dip.eda.worksheets.cards.MoodTestNSampCard;
import com.dataiku.dip.eda.worksheets.cards.OneWayANOVACard;
import com.dataiku.dip.eda.worksheets.cards.PairwiseMoodTestCard;
import com.dataiku.dip.eda.worksheets.cards.PairwiseTTestCard;
import com.dataiku.dip.eda.worksheets.cards.ShapiroNormalityTestCard;
import com.dataiku.dip.eda.worksheets.cards.SignTest1SampCard;
import com.dataiku.dip.eda.worksheets.cards.TTest2SampCard;
import com.dataiku.dip.eda.worksheets.cards.TZTest1SampCard;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.common.SISORecipeCreator;
import com.dataiku.dip.recipes.eda.EDARecipeParams;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.StatsTestRecipeSchemaComputer;
import com.dataiku.dip.recipes.eda.stats.Chi2IndependenceTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.Chi2IndependenceTestStat;
import com.dataiku.dip.recipes.eda.stats.NSampleMoodTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.NSampleMoodTestStat;
import com.dataiku.dip.recipes.eda.stats.OneSampleShapiroTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.OneSampleShapiroTestStat;
import com.dataiku.dip.recipes.eda.stats.OneSampleSignTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.OneSampleSignTestStat;
import com.dataiku.dip.recipes.eda.stats.OneSampleTTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.OneSampleTTestStat;
import com.dataiku.dip.recipes.eda.stats.OneWayAnovaTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.OneWayAnovaTestStat;
import com.dataiku.dip.recipes.eda.stats.PairwiseMoodTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.PairwiseMoodTestStat;
import com.dataiku.dip.recipes.eda.stats.PairwiseTTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.PairwiseTTestStat;
import com.dataiku.dip.recipes.eda.stats.TwoSampleKSTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.TwoSampleKSTestStat;
import com.dataiku.dip.recipes.eda.stats.TwoSampleMoodTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.TwoSampleMoodTestStat;
import com.dataiku.dip.recipes.eda.stats.TwoSampleTTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.TwoSampleTTestStat;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NullChecker;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;

public class StatsTestRecipeCreator
extends SISORecipeCreator {
    public StatsTestRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected RecipeParams makeInitialParams(SerializedRecipe sr, JsonObject creationData) throws Exception {
        String originWorksheetId = null;
        if (creationData.has("originWorksheetId")) {
            JsonElement originWorksheetIdJson = creationData.get("originWorksheetId");
            originWorksheetId = originWorksheetIdJson.getAsString();
        }
        StreamableDatasetSelection datasetSelection = StreamableDatasetSelection.full();
        if (creationData.has("datasetSelection")) {
            JsonObject selectionJson = creationData.getAsJsonObject("datasetSelection");
            datasetSelection = (StreamableDatasetSelection)((Object)JSON.parse((JsonElement)selectionJson, StreamableDatasetSelection.class));
        }
        ContainerExecSelection containerSelection = new ContainerExecSelection();
        if (creationData.has("containerSelection")) {
            JsonObject selectionJson = creationData.getAsJsonObject("containerSelection");
            containerSelection = (ContainerExecSelection)JSON.parse((JsonElement)selectionJson, ContainerExecSelection.class);
        }
        EDARecipeParams params = new EDARecipeParams(originWorksheetId, datasetSelection, containerSelection);
        NullChecker.checkObject((Object)params);
        return params;
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, Dataset outputDataset, JsonObject data) {
        boolean useDefaultParameters;
        if (!data.has("card")) {
            throw new IllegalArgumentException("The recipe creation payload must contain the card object");
        }
        JsonObject cardJson = data.getAsJsonObject("card");
        JsonElement flag = data.get("useDefaultParameters");
        boolean bl = useDefaultParameters = flag != null && flag.getAsBoolean();
        if (useDefaultParameters) {
            String cardType = cardJson.get("type").getAsString();
            StatsTestRecipePayloadParams<?> initialPayload = this.createDefaultPayloadParams(cardType);
            return JSON.json(initialPayload);
        }
        Card card = (Card)((Object)JSON.parse((JsonElement)cardJson, Card.class));
        NullChecker.checkObject((Object)((Object)card));
        StatsTestRecipePayloadParams<?> initialPayload = this.createPayloadParams(card);
        NullChecker.checkObject(initialPayload);
        return JSON.json(initialPayload);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        FlowRecipe fr = new FlowRecipe(recipe);
        RecipeRunnableSubgraph subgraph = this.recipesValidationService.getSampleSubgraph(fr);
        JobActivity activity = new JobActivity(subgraph);
        StatsTestRecipeSchemaComputer schemaComputer = new StatsTestRecipeSchemaComputer(this.authCtx, activity);
        schemaComputer.setPayload(payload);
        Schema schema = schemaComputer.getOutputSchema();
        outputDataset.setSchema(schema);
    }

    private StatsTestRecipePayloadParams<?> createPayloadParams(Card card) {
        if (card instanceof TZTest1SampCard) {
            TZTest1SampCard testCard = (TZTest1SampCard)card;
            return new OneSampleTTestRecipePayloadParams(new OneSampleTTestStat(testCard.column.name, testCard.hypothesizedMean, testCard.knownStdDev), testCard.alternative, testCard.confidenceLevel, testCard.splitBy);
        }
        if (card instanceof SignTest1SampCard) {
            SignTest1SampCard testCard = (SignTest1SampCard)card;
            return new OneSampleSignTestRecipePayloadParams(new OneSampleSignTestStat(testCard.column.name, testCard.hypothesizedMedian), testCard.confidenceLevel, testCard.splitBy);
        }
        if (card instanceof ShapiroNormalityTestCard) {
            ShapiroNormalityTestCard testCard = (ShapiroNormalityTestCard)card;
            return new OneSampleShapiroTestRecipePayloadParams(new OneSampleShapiroTestStat(testCard.column.name), testCard.confidenceLevel, testCard.splitBy);
        }
        if (card instanceof TTest2SampCard) {
            TTest2SampCard testCard = (TTest2SampCard)card;
            return new TwoSampleTTestRecipePayloadParams(new TwoSampleTTestStat(testCard.xColumn.name, testCard.yColumn.name, testCard.value1, testCard.value2, testCard.varianceAssumption), testCard.alternative, testCard.confidenceLevel, testCard.splitBy);
        }
        if (card instanceof MoodTest2SampCard) {
            MoodTest2SampCard testCard = (MoodTest2SampCard)card;
            return new TwoSampleMoodTestRecipePayloadParams(new TwoSampleMoodTestStat(testCard.xColumn.name, testCard.yColumn.name, testCard.value1, testCard.value2), testCard.confidenceLevel, testCard.splitBy);
        }
        if (card instanceof KsTest2SampCard) {
            KsTest2SampCard testCard = (KsTest2SampCard)card;
            return new TwoSampleKSTestRecipePayloadParams(new TwoSampleKSTestStat(testCard.xColumn.name, testCard.yColumn.name, testCard.value1, testCard.value2), testCard.confidenceLevel, testCard.splitBy);
        }
        if (card instanceof OneWayANOVACard) {
            OneWayANOVACard testCard = (OneWayANOVACard)card;
            return new OneWayAnovaTestRecipePayloadParams(new OneWayAnovaTestStat(testCard.xColumn.name, testCard.yColumn.name, testCard.yValues, testCard.maxGroups), testCard.confidenceLevel, testCard.splitBy);
        }
        if (card instanceof MoodTestNSampCard) {
            MoodTestNSampCard testCard = (MoodTestNSampCard)card;
            return new NSampleMoodTestRecipePayloadParams(new NSampleMoodTestStat(testCard.xColumn.name, testCard.yColumn.name, testCard.yValues, testCard.maxGroups), testCard.confidenceLevel, testCard.splitBy);
        }
        if (card instanceof PairwiseTTestCard) {
            PairwiseTTestCard testCard = (PairwiseTTestCard)card;
            return new PairwiseTTestRecipePayloadParams(new PairwiseTTestStat(testCard.xColumn.name, testCard.yColumn.name, testCard.yValues, testCard.maxGroups, testCard.referenceGroup, testCard.varianceAssumption, testCard.adjustmentMethod), testCard.alternative, testCard.confidenceLevel, testCard.splitBy);
        }
        if (card instanceof PairwiseMoodTestCard) {
            PairwiseMoodTestCard testCard = (PairwiseMoodTestCard)card;
            return new PairwiseMoodTestRecipePayloadParams(new PairwiseMoodTestStat(testCard.xColumn.name, testCard.yColumn.name, testCard.yValues, testCard.maxGroups, testCard.referenceGroup, testCard.adjustmentMethod), testCard.confidenceLevel, testCard.splitBy);
        }
        if (card instanceof Chi2IndTestCard) {
            Chi2IndTestCard testCard = (Chi2IndTestCard)card;
            return new Chi2IndependenceTestRecipePayloadParams(new Chi2IndependenceTestStat(testCard.xColumn.name, testCard.yColumn.name), testCard.confidenceLevel, testCard.splitBy);
        }
        throw new IllegalArgumentException(String.format("Cannot export a statistics card, unsupported type: %s", ((Object)((Object)card)).getClass().getSimpleName()));
    }

    private StatsTestRecipePayloadParams<?> createDefaultPayloadParams(String cardType) {
        if (Objects.equals(cardType, "ttest_ztest_1samp")) {
            OneSampleTTestRecipePayloadParams params = new OneSampleTTestRecipePayloadParams();
            params.stats.add(new OneSampleTTestStat());
            return params;
        }
        if (Objects.equals(cardType, "sign_test_1samp")) {
            OneSampleSignTestRecipePayloadParams params = new OneSampleSignTestRecipePayloadParams();
            params.stats.add(new OneSampleSignTestStat());
            return params;
        }
        if (Objects.equals(cardType, "shapiro")) {
            OneSampleShapiroTestRecipePayloadParams params = new OneSampleShapiroTestRecipePayloadParams();
            params.stats.add(new OneSampleShapiroTestStat());
            return params;
        }
        if (Objects.equals(cardType, "ttest_2samp")) {
            TwoSampleTTestRecipePayloadParams params = new TwoSampleTTestRecipePayloadParams();
            TwoSampleTTestStat stat = new TwoSampleTTestStat();
            stat.varianceAssumption = VarianceAssumption.UNEQUAL;
            params.stats.add(stat);
            return params;
        }
        if (Objects.equals(cardType, "mood_test_2samp")) {
            TwoSampleMoodTestRecipePayloadParams params = new TwoSampleMoodTestRecipePayloadParams();
            params.stats.add(new TwoSampleMoodTestStat());
            return params;
        }
        if (Objects.equals(cardType, "ks_test_2samp")) {
            TwoSampleKSTestRecipePayloadParams params = new TwoSampleKSTestRecipePayloadParams();
            params.stats.add(new TwoSampleKSTestStat());
            return params;
        }
        if (Objects.equals(cardType, "oneway_anova")) {
            OneWayAnovaTestRecipePayloadParams params = new OneWayAnovaTestRecipePayloadParams();
            params.stats.add(new OneWayAnovaTestStat());
            return params;
        }
        if (Objects.equals(cardType, "mood_nsamp")) {
            NSampleMoodTestRecipePayloadParams params = new NSampleMoodTestRecipePayloadParams();
            params.stats.add(new NSampleMoodTestStat());
            return params;
        }
        if (Objects.equals(cardType, "pairwise_ttest")) {
            PairwiseTTestRecipePayloadParams params = new PairwiseTTestRecipePayloadParams();
            PairwiseTTestStat stat = new PairwiseTTestStat();
            stat.varianceAssumption = VarianceAssumption.UNEQUAL;
            params.stats.add(stat);
            return params;
        }
        if (Objects.equals(cardType, "pairwise_mood")) {
            PairwiseMoodTestRecipePayloadParams params = new PairwiseMoodTestRecipePayloadParams();
            params.stats.add(new PairwiseMoodTestStat());
            return params;
        }
        if (Objects.equals(cardType, "chi2_independence_test")) {
            Chi2IndependenceTestRecipePayloadParams params = new Chi2IndependenceTestRecipePayloadParams();
            params.stats.add(new Chi2IndependenceTestStat());
            return params;
        }
        throw new IllegalArgumentException(String.format("Cannot create statistics recipe default parameters, unsupported type: %s", cardType));
    }
}

