/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.grouping.AnumGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.recipes.eda.stats.AbstractMultiSampleTestStat;
import com.dataiku.dip.recipes.eda.stats.PopulationBoxPlot;
import com.dataiku.dip.utils.JSON;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class AbstractNSampleTestStat
extends AbstractMultiSampleTestStat {
    @Nullable
    public List<String> groupValues = null;
    public int maxPopulations = 10;

    protected AbstractNSampleTestStat(String testColumn, String groupByColumn, @Nullable List<String> groupValues, int maxPopulations) {
        super(testColumn, groupByColumn);
        this.groupValues = groupValues;
        this.maxPopulations = maxPopulations;
    }

    protected AbstractNSampleTestStat() {
    }

    @Override
    protected Grouping getPopulationGrouping() {
        if (this.groupValues == null) {
            return new AnumGrouping(this.groupByColumn, this.maxPopulations, false);
        }
        List<Grouping> subsets = this.groupValues.stream().map(v -> AnumFilter.single(this.groupByColumn, v)).map(SubsetGrouping::new).collect(Collectors.toList());
        return new UnionGrouping(subsets);
    }

    @Override
    protected void fillPopulations(List<PopulationBoxPlot> populationBoxPlots, @Nullable BoxPlotFragment mergedBoxPlot, Row row, ColumnFactory cf) {
        LinkedHashMap<String, BoxPlotFragment> statistics = new LinkedHashMap<String, BoxPlotFragment>();
        for (PopulationBoxPlot pbp : populationBoxPlots) {
            String modality = pbp.getSingleValue();
            statistics.put(modality, pbp.boxPlot);
        }
        if (!statistics.isEmpty()) {
            row.put(cf.column("all_populations"), JSON.json(statistics.keySet()));
            row.put(cf.column("sample_statistics"), JSON.json(statistics));
        }
        if (mergedBoxPlot != null) {
            row.put(cf.column("sample_statistics_all_populations"), JSON.json((Object)((Object)mergedBoxPlot)));
        }
    }
}

