/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.grouping.AnumGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.compute.stats.PValueAdjustmentMethod;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.recipes.eda.EDASchemaColumns;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.stats.AbstractNSampleTestStat;
import com.dataiku.dip.recipes.eda.stats.PopulationBoxPlot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractPairwiseTestStat
extends AbstractNSampleTestStat {
    public PValueAdjustmentMethod adjustmentMethod = PValueAdjustmentMethod.NONE;
    @Nullable
    public String referenceGroup;

    protected AbstractPairwiseTestStat(String testColumn, String groupByColumn, @Nullable List<String> groupValues, int maxPopulations, @Nullable String referenceGroup, PValueAdjustmentMethod adjustmentMethod) {
        super(testColumn, groupByColumn, groupValues, maxPopulations);
        this.referenceGroup = referenceGroup;
        this.adjustmentMethod = adjustmentMethod;
    }

    protected AbstractPairwiseTestStat() {
    }

    @Override
    protected Grouping getPopulationGrouping() {
        if (this.referenceGroup == null) {
            return super.getPopulationGrouping();
        }
        SubsetGrouping referenceGroupGrouping = new SubsetGrouping(AnumFilter.single(this.groupByColumn, this.referenceGroup));
        if (this.groupValues == null) {
            AnumGrouping testedGroupsGrouping = new AnumGrouping(this.groupByColumn, this.maxPopulations, Collections.singletonList(this.referenceGroup), false);
            return new UnionGrouping(referenceGroupGrouping, testedGroupsGrouping);
        }
        ArrayList<Grouping> subsets = new ArrayList<Grouping>();
        subsets.add(referenceGroupGrouping);
        for (String groupValue : this.groupValues) {
            if (groupValue.equals(this.referenceGroup)) continue;
            subsets.add(new SubsetGrouping(AnumFilter.single(this.groupByColumn, groupValue)));
        }
        return new UnionGrouping(subsets);
    }

    @Override
    protected void fillTestParams(Row row, ColumnFactory cf) {
        super.fillTestParams(row, cf);
        row.put(cf.column("p_values_adjustment"), this.adjustmentMethod.name());
    }

    protected abstract int getNumberOfPairs(AvailableResult var1);

    protected int getNumberOfPopulations(ComputationResult testResult, List<PopulationBoxPlot> populationBoxPlots) {
        if (!testResult.isAvailable()) {
            return populationBoxPlots.size();
        }
        int nPairs = this.getNumberOfPairs(testResult.asAvailable());
        if (this.referenceGroup != null) {
            return nPairs + 1;
        }
        int n = 1;
        while (n * (n - 1) < 2 * nPairs) {
            ++n;
        }
        return n;
    }

    @Override
    protected List<Row> extractTestRows(ComputationResult testResult, StatsTestRecipePayloadParams<?> payloadParams, List<PopulationBoxPlot> populationBoxPlots, @Nullable BoxPlotFragment mergedBoxPlot, Collection<String> boxPlotWarnings, Collection<String> boxPlotErrors, ColumnFactory cf, RowFactory rf) {
        LinkedHashSet<String> warnings = new LinkedHashSet<String>(testResult.collectWarnings());
        warnings.addAll(boxPlotWarnings);
        LinkedHashSet<String> errors = new LinkedHashSet<String>(testResult.collectErrors());
        errors.addAll(boxPlotErrors);
        double significanceLevel = payloadParams.significanceLevel();
        int n = this.getNumberOfPopulations(testResult, populationBoxPlots);
        if (n < 2) {
            Row row = this.rowBase(significanceLevel, warnings, errors, cf, rf);
            this.fillPopulations(populationBoxPlots, mergedBoxPlot, 0, 1, row, cf);
            return Collections.singletonList(row);
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        int flatIndex = 0;
        for (int i = 0; i < n && (this.referenceGroup == null || i <= 0); ++i) {
            for (int j = 0; j < n; ++j) {
                if (i >= j) continue;
                Row row = this.rowBase(significanceLevel, warnings, errors, cf, rf);
                this.fillPopulations(populationBoxPlots, mergedBoxPlot, i, j, row, cf);
                if (testResult.isAvailable()) {
                    this.fillTestResult(testResult.asAvailable(), significanceLevel, cf, row, flatIndex);
                }
                rows.add(row);
                ++flatIndex;
            }
        }
        return rows;
    }

    protected void fillPopulations(List<PopulationBoxPlot> populationBoxPlots, @Nullable BoxPlotFragment mergedBoxPlot, int i, int j, Row row, ColumnFactory cf) {
        String modality;
        PopulationBoxPlot pbp;
        this.fillPopulations(populationBoxPlots, mergedBoxPlot, row, cf);
        if (i < populationBoxPlots.size()) {
            pbp = populationBoxPlots.get(i);
            modality = pbp.getSingleValue();
            row.put(cf.column(EDASchemaColumns.population(1)), modality);
        }
        if (j < populationBoxPlots.size()) {
            pbp = populationBoxPlots.get(j);
            modality = pbp.getSingleValue();
            row.put(cf.column(EDASchemaColumns.population(2)), modality);
        }
    }
}

