/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.univariate.PairwiseTTest;
import com.dataiku.dip.eda.compute.stats.AlternativeHypothesis;
import com.dataiku.dip.eda.compute.stats.PValueAdjustmentMethod;
import com.dataiku.dip.eda.compute.stats.VarianceAssumption;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParamsWithAlternativeHypothesis;
import com.dataiku.dip.recipes.eda.stats.AbstractTestStat;
import com.dataiku.dip.recipes.eda.stats.AbstractTwoSampleTestStat;
import com.dataiku.dip.recipes.eda.stats.PopulationBoxPlot;
import com.dataiku.dip.recipes.eda.stats.TwoSampleTTestRecipePayloadParams;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

public class TwoSampleTTestStat
extends AbstractTwoSampleTestStat {
    private static final String TWO_SAMPLE_T_TEST = "T_TEST_TWO_SAMPLE";
    public VarianceAssumption varianceAssumption = VarianceAssumption.EQUAL;

    public TwoSampleTTestStat(String testColumn, String groupByColumn, @Nullable String[] groupValues1, @Nullable String[] groupValues2, VarianceAssumption varianceAssumption) {
        super(testColumn, groupByColumn, groupValues1, groupValues2);
        this.varianceAssumption = varianceAssumption;
    }

    public TwoSampleTTestStat() {
    }

    @Override
    protected void fillTestParams(Row row, ColumnFactory cf) {
        super.fillTestParams(row, cf);
        row.put(cf.column("test"), TWO_SAMPLE_T_TEST);
        row.put(cf.column("variance_assumption"), this.varianceAssumption.name());
    }

    @Override
    protected MultiComputation getTestComputation(StatsTestRecipePayloadParams<?> payloadParams) {
        ArrayList<Computation> tests = new ArrayList<Computation>();
        for (AlternativeHypothesis alternative : payloadParams.as(TwoSampleTTestRecipePayloadParams.class).getAlternatives()) {
            tests.add(new PairwiseTTest(this.testColumn, this.getPopulationGrouping(), false, this.varianceAssumption, PValueAdjustmentMethod.NONE, alternative, payloadParams.confidenceLevel));
        }
        return new MultiComputation(tests);
    }

    @Override
    protected List<Row> extractTestRows(ComputationResult testResult, StatsTestRecipePayloadParams<?> payloadParams, List<PopulationBoxPlot> populationBoxPlots, @Nullable BoxPlotFragment mergedBoxPlot, Collection<String> boxPlotWarnings, Collection<String> boxPlotErrors, ColumnFactory cf, RowFactory rf) {
        List<StatsTestRecipePayloadParamsWithAlternativeHypothesis.AlternativeComputationResult> alternativeResults = payloadParams.as(TwoSampleTTestRecipePayloadParams.class).buildResultsForAlternatives(testResult);
        double significanceLevel = payloadParams.significanceLevel();
        ArrayList<Row> rows = new ArrayList<Row>();
        for (StatsTestRecipePayloadParamsWithAlternativeHypothesis.AlternativeComputationResult alternativeResult : alternativeResults) {
            AlternativeHypothesis alternative = alternativeResult.alternative;
            ComputationResult tr = alternativeResult.result;
            LinkedHashSet<String> warningsForAlternative = new LinkedHashSet<String>(tr.collectWarnings());
            warningsForAlternative.addAll(boxPlotWarnings);
            LinkedHashSet<String> errorsForAlternative = new LinkedHashSet<String>(tr.collectErrors());
            errorsForAlternative.addAll(boxPlotErrors);
            Row row = this.rowBase(significanceLevel, warningsForAlternative, errorsForAlternative, cf, rf);
            this.fillPopulations(populationBoxPlots, mergedBoxPlot, row, cf);
            row.put(cf.column("alternative_hypothesis"), alternative.name());
            row.put(cf.column("alternative_hypothesis_explanation"), TwoSampleTTestStat.getAlternativeExplanation(alternative));
            if (tr.isAvailable()) {
                this.fillTestResult(tr.asAvailable(), significanceLevel, cf, row, 0);
            }
            rows.add(row);
        }
        return rows;
    }

    private static String getAlternativeExplanation(AlternativeHypothesis alternative) {
        switch (alternative) {
            case LOWER: {
                return "population 2 mean < population 1 mean";
            }
            case GREATER: {
                return "population 2 mean > population 1 mean";
            }
            case TWO_SIDED: {
                return "population 2 mean \u2260 population 1 mean";
            }
        }
        throw new IllegalArgumentException("Unknown alternative type");
    }

    @Override
    protected void fillTestResult(AvailableResult result, double significanceLevel, ColumnFactory cf, Row row, int rowIndex) {
        PairwiseTTest.PairwiseTTestResult tr = result.as(PairwiseTTest.PairwiseTTestResult.class);
        AbstractTestStat.DifferenceOfMeansCI differenceOfMeansCI = new AbstractTestStat.DifferenceOfMeansCI(tr.meanDiffs[0], 1.0 - significanceLevel, tr.ciLowers[0], tr.ciUppers[0]);
        row.put(cf.column("difference_of_sample_means_confidence_interval"), JSON.json((Object)differenceOfMeansCI));
        double pValue = tr.pvalues[0];
        String conclusion = TwoSampleTTestStat.conclusion(pValue, significanceLevel);
        row.put(cf.column("t_statistic"), tr.statistics[0]);
        row.put(cf.column("degrees_of_freedom"), tr.dofs[0]);
        row.put(cf.column("p_value"), pValue);
        row.put(cf.column("conclusion"), conclusion);
    }
}

